/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living;

import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.living.IGahMob;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class GahMonsterBase<S extends GahEntityState, A extends GahAnimationState>
extends Monster
implements IGahMob,
GeoEntity {
    private static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(GahMonsterBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ENTITY_STATE = SynchedEntityData.m_135353_(GahMonsterBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> VANILLA_ROT_FLAG = SynchedEntityData.m_135353_(GahMonsterBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> FORCE_Y_ROT = SynchedEntityData.m_135353_(GahMonsterBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y_ROT = SynchedEntityData.m_135353_(GahMonsterBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y_HEAD_ROT = SynchedEntityData.m_135353_(GahMonsterBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> Y_BODY_ROT = SynchedEntityData.m_135353_(GahMonsterBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> X_ROT = SynchedEntityData.m_135353_(GahMonsterBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GahMonsterBase(EntityType<? extends GahMonsterBase> entityType, Level level) {
        super(entityType, level);
    }

    public final AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public A getAnimationState() {
        return this.valueToAnimationState((Integer)this.f_19804_.m_135370_(ANIMATION_STATE));
    }

    public void setAnimationState(A state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state.value());
    }

    public S getEntityState() {
        return this.valueToEntityState((Integer)this.f_19804_.m_135370_(ENTITY_STATE));
    }

    public void setEntityState(S state) {
        this.f_19804_.m_135381_(ENTITY_STATE, (Object)state.value());
    }

    public void setAllYRot(float yRot) {
        this.m_146922_(yRot);
        this.m_5618_(yRot);
        this.m_5616_(yRot);
    }

    public float m_146908_() {
        if (this.isVanillaRotationDisabled()) {
            return ((Float)this.f_19804_.m_135370_(Y_ROT)).floatValue();
        }
        return super.m_146908_();
    }

    public void m_146922_(float p_146923_) {
        if (this.isVanillaRotationDisabled()) {
            this.f_19804_.m_135381_(Y_ROT, (Object)Float.valueOf(p_146923_));
            return;
        }
        super.m_146922_(p_146923_);
    }

    public float m_6080_() {
        if (this.isVanillaRotationDisabled()) {
            return ((Float)this.f_19804_.m_135370_(Y_HEAD_ROT)).floatValue();
        }
        return super.m_6080_();
    }

    public void m_5616_(float p_21306_) {
        if (this.isVanillaRotationDisabled()) {
            this.f_19804_.m_135381_(Y_HEAD_ROT, (Object)Float.valueOf(p_21306_));
            return;
        }
        super.m_5616_(p_21306_);
    }

    public float getYBodyRot() {
        if (this.isVanillaRotationDisabled()) {
            return ((Float)this.f_19804_.m_135370_(Y_BODY_ROT)).floatValue();
        }
        return this.f_20883_;
    }

    public void m_5618_(float p_21309_) {
        if (this.isVanillaRotationDisabled()) {
            this.f_19804_.m_135381_(Y_BODY_ROT, (Object)Float.valueOf(p_21309_));
            return;
        }
        super.m_5618_(p_21309_);
    }

    public float m_146909_() {
        if (this.isVanillaRotationDisabled()) {
            return ((Float)this.f_19804_.m_135370_(X_ROT)).floatValue();
        }
        return super.m_146909_();
    }

    public void m_146926_(float p_146927_) {
        if (this.isVanillaRotationDisabled()) {
            this.f_19804_.m_135381_(X_ROT, (Object)Float.valueOf(p_146927_));
            return;
        }
        super.m_146926_(p_146927_);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this::handleAnimation)});
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        if (accessor.equals(ANIMATION_STATE)) {
            this.onAnimationStateUpdated(this.getAnimationState(), this.m_9236_().f_46443_);
            return;
        }
        if (accessor.equals(ENTITY_STATE)) {
            this.onMobStateUpdated(this.getEntityState(), this.m_9236_().f_46443_);
            return;
        }
        if (accessor.equals(FORCE_Y_ROT)) {
            float yRot = ((Float)this.f_19804_.m_135370_(FORCE_Y_ROT)).floatValue();
            super.m_146922_(yRot);
            super.m_5616_(yRot);
            this.f_20883_ = yRot;
            return;
        }
        if (this.isVanillaRotationDisabled()) {
            super.m_146922_(((Float)this.f_19804_.m_135370_(Y_ROT)).floatValue());
            super.m_5616_(((Float)this.f_19804_.m_135370_(Y_HEAD_ROT)).floatValue());
            this.f_20883_ = ((Float)this.f_19804_.m_135370_(Y_BODY_ROT)).floatValue();
            super.m_146926_(((Float)this.f_19804_.m_135370_(X_ROT)).floatValue());
        }
    }

    public Optional<ServerPlayer> getPlayerTarget() {
        LivingEntity livingEntity = this.m_5448_();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            return Optional.of(player);
        }
        return Optional.empty();
    }

    public List<ServerPlayer> findPlayersSortedByDistance() {
        List<ServerPlayer> players = this.findNearbyPlayers();
        players.sort(Comparator.comparingDouble(arg_0 -> ((GahMonsterBase)this).m_20270_(arg_0)));
        return players;
    }

    public List<ServerPlayer> findNearbyPlayers() {
        Level level = this.m_9236_();
        if (level.f_46443_) {
            return new ArrayList<ServerPlayer>();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        double searchRange = this.m_21133_(Attributes.f_22277_);
        return EntityUtils.getTargetablePlayers(serverLevel, this.m_20191_().m_82400_(searchRange));
    }

    public AttributeInstance getAttributeUnsafe(Attribute attribute) {
        return Optional.ofNullable(this.m_21051_(attribute)).orElseThrow();
    }

    public boolean rollRandomBoolean() {
        return this.rollRandom(2);
    }

    public boolean rollRandom(int maxNotIncluded) {
        return this.m_217043_().m_188503_(maxNotIncluded) == 0;
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("entityState", this.getEntityState().value());
        nbt.m_128405_("animationState", this.getAnimationState().value());
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setEntityState(this.valueToEntityState(nbt.m_128451_("entityState")));
        this.setAnimationState(this.valueToAnimationState(nbt.m_128451_("animationState")));
    }

    protected abstract A valueToAnimationState(int var1);

    protected abstract S valueToEntityState(int var1);

    protected void forceYRot(float yRot) {
        this.f_19804_.m_135381_(FORCE_Y_ROT, (Object)Float.valueOf(yRot));
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new BodyRotationControl((Mob)this){

            public void m_8121_() {
                if (!GahMonsterBase.this.isVanillaRotationDisabled()) {
                    super.m_8121_();
                }
            }
        };
    }

    protected void m_19915_(float p_19916_, float p_19917_) {
        if (this.isVanillaRotationDisabled()) {
            return;
        }
        super.m_19915_(p_19916_, p_19917_);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(ENTITY_STATE, (Object)0);
        this.f_19804_.m_135372_(VANILLA_ROT_FLAG, (Object)true);
        this.f_19804_.m_135372_(Y_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(FORCE_Y_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(Y_HEAD_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(Y_BODY_ROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(X_ROT, (Object)Float.valueOf(0.0f));
    }

    protected void disableVanillaRotation() {
        this.f_19804_.m_135381_(VANILLA_ROT_FLAG, (Object)false);
        this.f_21342_ = new MoveControl((Mob)this){

            public void m_8126_() {
            }
        };
        this.f_21365_ = new LookControl((Mob)this){

            public void m_8128_() {
            }
        };
    }

    protected boolean isVanillaRotationDisabled() {
        return (Boolean)this.f_19804_.m_135370_(VANILLA_ROT_FLAG) == false;
    }

    protected void onAnimationStateUpdated(A newState, boolean isClientSide) {
    }

    protected void onMobStateUpdated(S newState, boolean isClientSide) {
    }

    protected boolean resetAnimation() {
        return false;
    }

    protected PlayState handleAnimation(AnimationState<GeoAnimatable> event) {
        if (this.resetAnimation()) {
            event.getController().forceAnimationReset();
        }
        return event.setAndContinue(this.getCurrentAnimation(event));
    }

    protected boolean isTargetInMeleeRange() {
        if (!this.isTargetValid()) {
            return false;
        }
        double meleeReach = this.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get());
        return this.m_20191_().m_82400_(meleeReach).m_82381_(this.getTargetUnsafe().m_20191_());
    }

    protected boolean isTargetValid() {
        if (this.m_5448_() == null) {
            return false;
        }
        return this.getTargetUnsafe().m_6084_();
    }

    @Nullable
    protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
        return this.getAnimationState().animation();
    }

    protected boolean randomCheck(int max) {
        return this.m_217043_().m_188503_(max) == 0;
    }

    protected LivingEntity getTargetUnsafe() {
        return Optional.ofNullable(this.m_5448_()).orElseThrow();
    }

    protected boolean allChecksPass(List<Boolean> checks) {
        return checks.stream().allMatch(check -> check);
    }
}

