/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living;

import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.living.GahMonsterBase;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Hellhound
extends GahMonsterBase<State, AnimationState> {
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.hellhound.idle");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.hellhound.walk");
    private static final RawAnimation SNIFF_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.hellhound.sniff");
    private static final RawAnimation HOWL_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.hellhound.howl");

    public Hellhound(EntityType<? extends Hellhound> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected AnimationState valueToAnimationState(int value) {
        return AnimationState.values()[value];
    }

    @Override
    protected State valueToEntityState(int value) {
        return State.values()[value];
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(9, (Goal)new RandomSniffGoal());
        this.f_21345_.m_25352_(10, (Goal)new HellhoundStrollGoal());
    }

    public static enum AnimationState implements GahAnimationState
    {
        IDLE(IDLE_ANIMATION, -1),
        WALK(WALK_ANIMATION, -1),
        SNIFF(SNIFF_ANIMATION, TimeUtils.secondsToTicks(2.0f)),
        HOWL(HOWL_ANIMATION, TimeUtils.secondsToTicks(1.0f));

        private final RawAnimation animation;
        private final int tickDuration;

        private AnimationState(RawAnimation animation, int tickDuration) {
            this.animation = animation;
            this.tickDuration = tickDuration;
        }

        @Override
        public int value() {
            return this.ordinal();
        }

        @Override
        public RawAnimation animation() {
            return this.animation;
        }
    }

    public static enum State implements GahEntityState
    {
        IDLE,
        SNIFF,
        ATTACK,
        HOWL;


        @Override
        public int value() {
            return this.ordinal();
        }
    }

    private class RandomSniffGoal
    extends Goal {
        int useTick = 0;

        private RandomSniffGoal() {
        }

        public boolean m_8036_() {
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{Hellhound.this.getEntityState() == State.IDLE, Hellhound.this.rollRandom(50)});
            if (!Hellhound.this.allChecksPass(checks)) {
                return false;
            }
            Hellhound.this.setEntityState(State.SNIFF);
            return true;
        }

        public boolean m_8045_() {
            return this.useTick < AnimationState.SNIFF.tickDuration;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.useTick;
        }

        public void m_8056_() {
            super.m_8056_();
            this.useTick = 0;
            Hellhound.this.setAnimationState(AnimationState.SNIFF);
        }

        public void m_8041_() {
            super.m_8041_();
            Hellhound.this.setEntityState(State.IDLE);
            Hellhound.this.setAnimationState(AnimationState.IDLE);
        }
    }

    private class HellhoundStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        public HellhoundStrollGoal() {
            super((PathfinderMob)Hellhound.this, 0.75);
        }

        public boolean m_8036_() {
            if (Hellhound.this.getEntityState() != State.IDLE) {
                return false;
            }
            return super.m_8036_();
        }

        public boolean m_8045_() {
            if (super.m_8045_()) {
                return Hellhound.this.getEntityState() == State.IDLE;
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            Hellhound.this.setAnimationState(AnimationState.WALK);
        }

        public void m_8041_() {
            super.m_8041_();
            Hellhound.this.setAnimationState(AnimationState.IDLE);
        }
    }
}

