/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.living.GahMonsterBase;
import com.dee12452.gahoodrpg.common.entities.living.ai.CooldownGoal;
import com.dee12452.gahoodrpg.common.entities.living.ai.FindPlayerTargetGoal;
import com.dee12452.gahoodrpg.common.entities.projectile.PoisonShot;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientMagicExplosion;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Jagarix
extends GahMonsterBase<JagarixState, JagarixAnimationState> {
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.jagarix.idle");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.jagarix.walk");
    private static final RawAnimation SHOOT_ANIMATION = RawAnimation.begin().thenPlay("animation.jagarix.shoot");
    private static final RawAnimation POUNCE_ANIMATION = RawAnimation.begin().thenLoop("animation.jagarix.pounce");

    public Jagarix(EntityType<? extends GahMonsterBase> entityType, Level level) {
        super(entityType, level);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)Sounds.JAGARIX_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_33034_) {
        return (SoundEvent)Sounds.JAGARIX_HURT.get();
    }

    @Override
    protected JagarixAnimationState valueToAnimationState(int value) {
        return JagarixAnimationState.values()[value];
    }

    @Override
    protected JagarixState valueToEntityState(int value) {
        return JagarixState.values()[value];
    }

    @Override
    @Nullable
    protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
        return ((JagarixAnimationState)this.getAnimationState()).animation;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new JagarixFindTargetGoal());
        this.f_21345_.m_25352_(7, (Goal)new JagarixMeleeAttack());
        this.f_21345_.m_25352_(8, (Goal)new JagarixRangedAttack());
        this.f_21345_.m_25352_(9, (Goal)new JagarixRandomStrollGoal());
    }

    public static enum JagarixAnimationState implements GahAnimationState
    {
        IDLE(IDLE_ANIMATION, TimeUtils.secondsToTicks(2.0f)),
        WALK(WALK_ANIMATION, TimeUtils.secondsToTicks(1.0f)),
        SHOOT(SHOOT_ANIMATION, TimeUtils.secondsToTicks(0.5f)),
        POUNCE(POUNCE_ANIMATION, TimeUtils.secondsToTicks(1.0f));

        private final RawAnimation animation;
        private final int animationTickLength;

        private JagarixAnimationState(RawAnimation animation, int animationTickLength) {
            this.animation = animation;
            this.animationTickLength = animationTickLength;
        }

        @Override
        public RawAnimation animation() {
            return this.animation;
        }

        public int getAnimationTickLength() {
            return this.animationTickLength;
        }

        @Override
        public int value() {
            return this.ordinal();
        }
    }

    public static enum JagarixState implements GahEntityState
    {
        IDLE,
        WALK,
        SHOOT,
        POUNCE;


        @Override
        public int value() {
            return this.ordinal();
        }
    }

    private class JagarixFindTargetGoal
    extends FindPlayerTargetGoal {
        public JagarixFindTargetGoal() {
            super((Mob)Jagarix.this);
        }

        @Override
        public void m_8056_() {
            boolean targetClosest;
            List<ServerPlayer> sortedPlayers = Jagarix.this.findPlayersSortedByDistance();
            if (sortedPlayers.isEmpty()) {
                return;
            }
            boolean bl = targetClosest = !Jagarix.this.rollRandom(4);
            if (sortedPlayers.size() == 1 || targetClosest) {
                Jagarix.this.m_6710_((LivingEntity)sortedPlayers.get(0));
            } else {
                int index = Jagarix.this.m_217043_().m_188503_(sortedPlayers.size());
                Jagarix.this.m_6710_((LivingEntity)sortedPlayers.get(Math.max(1, index)));
            }
        }
    }

    private class JagarixMeleeAttack
    extends CooldownGoal {
        private static final int COOLDOWN = TimeUtils.secondsToTicks(1.0f);
        private static final double POUNCE_DAMAGE_RANGE = 5.0;
        private int pounceTicks;
        private Path path;
        private boolean isPathing;
        private boolean hasShownExplosion;

        public JagarixMeleeAttack() {
            super(COOLDOWN);
        }

        @Override
        public boolean m_8036_() {
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{super.m_8036_(), Jagarix.this.getEntityState() == JagarixState.IDLE, Jagarix.this.isTargetInMeleeRange()});
            if (Jagarix.this.allChecksPass(checks)) {
                Jagarix.this.setEntityState(JagarixState.POUNCE);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (Jagarix.this.m_5448_() == null) {
                return false;
            }
            return this.pounceTicks <= ((JagarixAnimationState)Jagarix.this.getAnimationState()).getAnimationTickLength();
        }

        public void m_8056_() {
            super.m_8056_();
            this.pounceTicks = 0;
            LivingEntity target = Jagarix.this.getTargetUnsafe();
            Jagarix.this.f_21365_.m_148051_((Entity)target);
            this.path = Jagarix.this.m_21573_().m_6570_((Entity)target, 1);
            this.isPathing = true;
            this.hasShownExplosion = false;
            Jagarix.this.setAnimationState(JagarixAnimationState.WALK);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.isPathing) {
                this.continueOnPath();
                return;
            }
            ++this.pounceTicks;
            if (!this.hasShownExplosion && this.pounceTicks >= ((JagarixAnimationState)Jagarix.this.getAnimationState()).getAnimationTickLength() * 3 / 4) {
                this.hasShownExplosion = true;
                this.showExplosion();
            }
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            ServerLevel serverLevel = (ServerLevel)Jagarix.this.m_9236_();
            Jagarix.this.setAnimationState(JagarixAnimationState.IDLE);
            Jagarix.this.setEntityState(JagarixState.IDLE);
            this.damageNearbyPlayers(serverLevel);
        }

        private void continueOnPath() {
            ServerLevel level = (ServerLevel)Jagarix.this.m_9236_();
            if (level.m_7654_().m_129921_() % 10 != 0) {
                return;
            }
            if (Jagarix.this.m_21573_().m_26536_(this.path, 1.0)) {
                return;
            }
            Jagarix.this.m_216990_((SoundEvent)Sounds.JAGARIX_POUNCE.get());
            Jagarix.this.setAnimationState(JagarixAnimationState.POUNCE);
            this.isPathing = false;
        }

        private void damageNearbyPlayers(ServerLevel level) {
            List<ServerPlayer> damagedPlayers = EntityUtils.getTargetablePlayers(level, Jagarix.this.m_20191_().m_82400_(5.0));
            damagedPlayers.forEach(arg_0 -> ((Jagarix)Jagarix.this).m_7327_(arg_0));
        }

        private void showExplosion() {
            ServerLevel serverLevel = (ServerLevel)Jagarix.this.m_9236_();
            Vec3 location = new Vec3(Jagarix.this.m_20185_(), Jagarix.this.m_20186_(), Jagarix.this.m_20189_());
            this.sendExplosionMessage(serverLevel, location);
        }

        private void sendExplosionMessage(ServerLevel level, Vec3 location) {
            ClientMagicExplosion.Message message = new ClientMagicExplosion.Message(location.f_82479_, location.f_82480_, location.f_82481_);
            NetworkChannel.sendToClientsInLevel(level, message);
        }
    }

    private class JagarixRangedAttack
    extends CooldownGoal {
        private static final int COOLDOWN = TimeUtils.secondsToTicks(2.0f);
        private static final int MAX_PATH_TICKS = TimeUtils.secondsToTicks(0.25f);
        private int animationTicks;
        private Path path;
        private int pathingTicks;
        private boolean isPathing;
        private boolean hasShot;

        public JagarixRangedAttack() {
            super(COOLDOWN);
        }

        @Override
        public boolean m_8036_() {
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{super.m_8036_(), Jagarix.this.getEntityState() == JagarixState.IDLE, Jagarix.this.isTargetValid()});
            if (Jagarix.this.allChecksPass(checks)) {
                Jagarix.this.setEntityState(JagarixState.SHOOT);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (!Jagarix.this.isTargetValid()) {
                return false;
            }
            return this.animationTicks <= ((JagarixAnimationState)Jagarix.this.getAnimationState()).getAnimationTickLength();
        }

        public void m_8056_() {
            super.m_8056_();
            LivingEntity target = Jagarix.this.getTargetUnsafe();
            this.path = Jagarix.this.m_21573_().m_6570_((Entity)target, 0);
            this.isPathing = true;
            this.hasShot = false;
            this.pathingTicks = 0;
            this.animationTicks = 0;
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            Jagarix.this.setEntityState(JagarixState.IDLE);
            Jagarix.this.setAnimationState(JagarixAnimationState.IDLE);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            if (!Jagarix.this.isTargetValid()) {
                return;
            }
            Jagarix.this.m_21391_((Entity)Jagarix.this.getTargetUnsafe(), 30.0f, 30.0f);
            if (this.isPathing) {
                this.continueOnPath();
                return;
            }
            if (!this.hasShot) {
                this.shoot();
            }
            ++this.animationTicks;
        }

        private void continueOnPath() {
            ++this.pathingTicks;
            if (this.pathingTicks <= MAX_PATH_TICKS && Jagarix.this.m_21573_().m_26536_(this.path, 0.25)) {
                return;
            }
            this.isPathing = false;
            Jagarix.this.m_21573_().m_26573_();
        }

        private void shoot() {
            if (Jagarix.this.m_5448_() == null) {
                return;
            }
            PoisonShot projectile = new PoisonShot((LivingEntity)Jagarix.this);
            projectile.shootDirectlyAtEntity(Jagarix.this.getTargetUnsafe(), 1.5f);
            if (!Jagarix.this.m_9236_().m_7967_((Entity)projectile)) {
                return;
            }
            Jagarix.this.m_216990_((SoundEvent)Sounds.POISON_SHOT_SHOOT.get());
            Jagarix.this.setAnimationState(JagarixAnimationState.SHOOT);
            this.hasShot = true;
        }
    }

    private class JagarixRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        public JagarixRandomStrollGoal() {
            super((PathfinderMob)Jagarix.this, 1.0);
        }

        public boolean m_8036_() {
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{super.m_8036_(), Jagarix.this.getEntityState() == JagarixState.IDLE, !Jagarix.this.isTargetValid()});
            if (Jagarix.this.allChecksPass(checks)) {
                Jagarix.this.setEntityState(JagarixState.WALK);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_() && Jagarix.this.m_5448_() == null;
        }

        public void m_8056_() {
            super.m_8056_();
            Jagarix.this.setAnimationState(JagarixAnimationState.WALK);
        }

        public void m_8041_() {
            super.m_8041_();
            Jagarix.this.setEntityState(JagarixState.IDLE);
            Jagarix.this.setAnimationState(JagarixAnimationState.IDLE);
        }
    }
}

