/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.effects.GahMagicPoisonEffect;
import com.dee12452.gahoodrpg.common.combat.effects.MobEffects;
import com.dee12452.gahoodrpg.common.entities.living.IGahAnimatedMob;
import com.dee12452.gahoodrpg.common.entities.living.ai.CooldownGoal;
import com.dee12452.gahoodrpg.common.entities.living.ai.FindPlayerTargetGoal;
import com.dee12452.gahoodrpg.common.entities.projectile.FrogTongue;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class PoisonousFrog
extends Monster
implements IGahAnimatedMob {
    private static final EntityDataAccessor<Float> YROT = SynchedEntityData.m_135353_(PoisonousFrog.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> XROT = SynchedEntityData.m_135353_(PoisonousFrog.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.frog.idle");
    private static final RawAnimation JUMP_BEGIN_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.frog.jump_begin");
    private static final RawAnimation JUMP_END_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.frog.jump_end");
    private static final RawAnimation ATTACK_BEGIN_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.frog.attack_begin");
    private static final RawAnimation ATTACK_END_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.frog.attack_end");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private AnimationState animationState;
    private MobState mobState = MobState.IDLE;

    public PoisonousFrog(EntityType<? extends PoisonousFrog> entityType, Level level) {
        super(entityType, level);
        this.animationState = AnimationState.IDLE;
        this.f_21365_ = new LookControl((Mob)this){

            public void m_8128_() {
            }
        };
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)Sounds.FROG_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_33034_) {
        return (SoundEvent)Sounds.HISSING_HURT.get();
    }

    private void setAnimation(AnimationState animationState) {
        this.animationState = animationState;
        this.setAnimationState(animationState.ordinal());
    }

    @Override
    public void setSidedAnimationState(int state, boolean isClient) {
        this.animationState = AnimationState.values()[state];
    }

    @Override
    public RawAnimation tickAnimation(software.bernie.geckolib.core.animation.AnimationState<GeoAnimatable> event) {
        switch (this.animationState) {
            case JUMP_BEGIN: {
                return JUMP_BEGIN_ANIMATION;
            }
            case JUMP_END: {
                return JUMP_END_ANIMATION;
            }
            case ATTACK_BEGIN: {
                return ATTACK_BEGIN_ANIMATION;
            }
            case ATTACK_END: {
                return ATTACK_END_ANIMATION;
            }
        }
        return IDLE_ANIMATION;
    }

    @Override
    public GahDamage onDirectDamage(LivingEntity target) {
        GahCombat combat = GahCombat.entity((Entity)this);
        GahDamage damage = combat.calculatePowerDamage((Entity)target);
        if (!target.m_21023_((MobEffect)MobEffects.GAH_POISON.get())) {
            int amount = Math.max(1, (int)damage.magicDamage());
            MobEffectInstance effectInstance = new MobEffectInstance((MobEffect)MobEffects.GAH_POISON.get(), GahMagicPoisonEffect.DEFAULT_TICKS_ACTIVE, amount);
            target.m_7292_(effectInstance);
        }
        return damage;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean m_142535_(float p_147187_, float p_147188_, @NotNull DamageSource p_147189_) {
        return false;
    }

    public void m_146926_(float xRot) {
    }

    public void m_146922_(float yRot) {
    }

    public float m_146908_() {
        return ((Float)this.f_19804_.m_135370_(YROT)).floatValue();
    }

    public float m_146909_() {
        return ((Float)this.f_19804_.m_135370_(XROT)).floatValue();
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        super.m_146922_(((Float)this.f_19804_.m_135370_(YROT)).floatValue());
        this.f_19859_ = this.m_146908_();
        super.m_146926_(((Float)this.f_19804_.m_135370_(XROT)).floatValue());
        this.f_19860_ = this.m_146909_();
        this.f_20886_ = this.f_20885_;
        this.f_20884_ = this.f_20883_;
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new BodyRotationControl((Mob)this){

            public void m_8121_() {
            }
        };
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(YROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(XROT, (Object)Float.valueOf(0.0f));
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new FindPlayerTargetGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AttackTargetGoal());
        this.f_21345_.m_25352_(4, (Goal)new JumpTowardsTargetGoal());
        this.f_21345_.m_25352_(5, (Goal)new RandomJumpGoal());
    }

    private boolean getRandomBoolean() {
        return this.m_217043_().m_188503_(2) == 0;
    }

    private void lookAtTarget() {
        LivingEntity target = Optional.ofNullable(this.m_5448_()).orElseThrow();
        Vec3 targetPos = target.m_146892_();
        this.lookAt(targetPos);
    }

    private void lookAt(Vec3 targetPos) {
        Vec3 frogPos = this.m_20318_(1.0f).m_82492_(0.0, 0.1, 0.0);
        double d0 = targetPos.f_82479_ - frogPos.f_82479_;
        double d1 = targetPos.f_82480_ - frogPos.f_82480_;
        double d2 = targetPos.f_82481_ - frogPos.f_82481_;
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        float yRot = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
        float xRot = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.2957763671875));
        this.f_19804_.m_135381_(YROT, (Object)Float.valueOf(yRot));
        this.f_19804_.m_135381_(XROT, (Object)Float.valueOf(xRot));
    }

    private boolean isTargetInRange() {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return false;
        }
        double attackRange = this.m_21133_((Attribute)ForgeMod.ENTITY_REACH.get());
        return this.m_20191_().m_82400_(attackRange).m_82381_(target.m_20191_());
    }

    private static enum MobState {
        IDLE,
        JUMP,
        ATTACK;

    }

    private static enum AnimationState {
        IDLE,
        JUMP_BEGIN,
        JUMP_END,
        ATTACK_BEGIN,
        ATTACK_END;

    }

    private class AttackTargetGoal
    extends CooldownGoal {
        private static final int COOLDOWN = TimeUtils.secondsToTicks(2.5f);
        private static final int ATTACK_TICKS = TimeUtils.secondsToTicks(0.25f);
        private int currentAttackTick;
        private boolean canReach;
        private final List<FrogTongue> tongues;

        public AttackTargetGoal() {
            super(COOLDOWN, false);
            this.currentAttackTick = 0;
            this.tongues = new ArrayList<FrogTongue>();
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_() || PoisonousFrog.this.mobState != MobState.IDLE || !PoisonousFrog.this.isTargetInRange() || PoisonousFrog.this.m_20072_()) {
                return false;
            }
            PoisonousFrog.this.mobState = MobState.ATTACK;
            return true;
        }

        public boolean m_8045_() {
            if (!this.canReach || PoisonousFrog.this.m_5448_() == null || PoisonousFrog.this.m_5448_().m_21224_()) {
                return false;
            }
            return this.currentAttackTick <= ATTACK_TICKS;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            PoisonousFrog.this.lookAtTarget();
            this.summonTongue();
            PoisonousFrog.this.setAnimation(AnimationState.ATTACK_BEGIN);
            this.currentAttackTick = 0;
            this.canReach = true;
            SoundEvent sound = PoisonousFrog.this.m_7515_();
            if (sound != null) {
                PoisonousFrog.this.m_216990_(sound);
            }
        }

        public void m_8037_() {
            super.m_8037_();
            this.tongues.stream().filter(Entity::m_6084_).forEach(FrogTongue::m_8119_);
            ++this.currentAttackTick;
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            PoisonousFrog.this.mobState = MobState.IDLE;
            PoisonousFrog.this.setAnimation(AnimationState.ATTACK_END);
            this.tongues.stream().filter(Entity::m_6084_).forEach(Entity::m_146870_);
            this.tongues.clear();
        }

        private void summonTongue() {
            LivingEntity target = Optional.ofNullable(PoisonousFrog.this.m_5448_()).orElseThrow();
            double distance = EntityUtils.getDistanceToEntity((LivingEntity)PoisonousFrog.this, (Entity)target);
            int tonguesToSpawn = (int)distance + 2;
            for (int tongue = 0; tongue < tonguesToSpawn; ++tongue) {
                FrogTongue newTongue = new FrogTongue(PoisonousFrog.this, target, tongue, this::onTongueHit);
                if (!PoisonousFrog.this.m_9236_().m_7967_((Entity)newTongue)) continue;
                this.tongues.add(newTongue);
            }
        }

        private void onTongueHit(int tongue) {
            this.canReach = false;
            for (int idx = this.tongues.size() - 1; idx >= tongue; --idx) {
                this.tongues.get(idx).m_146870_();
            }
        }
    }

    private class JumpTowardsTargetGoal
    extends FrogJumpGoal {
        public JumpTowardsTargetGoal() {
            super(TimeUtils.secondsToTicks(0.5f));
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_() || PoisonousFrog.this.m_5448_() == null || PoisonousFrog.this.mobState != MobState.IDLE) {
                return false;
            }
            PoisonousFrog.this.mobState = MobState.JUMP;
            return true;
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
        }

        @Override
        protected double getXDelta(double moveSpeed) {
            return EntityUtils.getAngleTo((LivingEntity)PoisonousFrog.this, (Entity)this.getPlayerTarget()).f_82479_ * moveSpeed;
        }

        @Override
        protected double getZDelta(double moveSpeed) {
            return EntityUtils.getAngleTo((LivingEntity)PoisonousFrog.this, (Entity)this.getPlayerTarget()).f_82481_ * moveSpeed;
        }

        private ServerPlayer getPlayerTarget() {
            return (ServerPlayer)Optional.ofNullable(PoisonousFrog.this.m_5448_()).orElseThrow();
        }
    }

    private class RandomJumpGoal
    extends FrogJumpGoal {
        public RandomJumpGoal() {
            super(TimeUtils.secondsToTicks(0.5f));
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_() || PoisonousFrog.this.mobState != MobState.IDLE || PoisonousFrog.this.m_5448_() != null) {
                return false;
            }
            if (!PoisonousFrog.this.m_20072_() && PoisonousFrog.this.m_217043_().m_188503_(35) != 0) {
                return false;
            }
            PoisonousFrog.this.mobState = MobState.JUMP;
            return true;
        }

        @Override
        protected double getXDelta(double moveSpeed) {
            return moveSpeed * (double)PoisonousFrog.this.m_217043_().m_188501_() * (double)(PoisonousFrog.this.getRandomBoolean() ? -1 : 1);
        }

        @Override
        protected double getZDelta(double moveSpeed) {
            return moveSpeed * (double)PoisonousFrog.this.m_217043_().m_188501_() * (double)(PoisonousFrog.this.getRandomBoolean() ? -1 : 1);
        }
    }

    private abstract class FrogJumpGoal
    extends CooldownGoal {
        public FrogJumpGoal(int cooldownTicks) {
            super(cooldownTicks, false);
        }

        public boolean m_8045_() {
            if (PoisonousFrog.this.m_20096_()) {
                return false;
            }
            double yDelta = PoisonousFrog.this.m_20184_().f_82480_;
            if (yDelta >= 0.0) {
                return true;
            }
            PoisonousFrog.this.setAnimation(AnimationState.JUMP_END);
            BlockState possibleLandingBlockState = PoisonousFrog.this.m_9236_().m_8055_(PoisonousFrog.this.m_20097_());
            return possibleLandingBlockState.m_60795_();
        }

        public void m_8056_() {
            PoisonousFrog.this.setAnimation(AnimationState.JUMP_BEGIN);
            double moveSpeed = Optional.ofNullable(PoisonousFrog.this.m_21051_(Attributes.f_22279_)).map(AttributeInstance::m_22135_).orElseThrow();
            double x = this.getXDelta(moveSpeed);
            double y = 0.65f;
            double z = this.getZDelta(moveSpeed);
            Vec3 newDelta = new Vec3(x, (double)0.65f, z);
            PoisonousFrog.this.m_20256_(newDelta);
            PoisonousFrog.this.lookAt(PoisonousFrog.this.m_20318_(1.0f).m_82549_(newDelta));
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            PoisonousFrog.this.setAnimation(AnimationState.IDLE);
            PoisonousFrog.this.mobState = MobState.IDLE;
        }

        protected abstract double getXDelta(double var1);

        protected abstract double getZDelta(double var1);
    }
}

