/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.entities.living.IGahAnimatedMob;
import com.dee12452.gahoodrpg.common.entities.living.ai.GahRangedAttackGoal;
import com.dee12452.gahoodrpg.common.entities.projectile.GahThrowableProjectileBase;
import com.dee12452.gahoodrpg.common.entities.projectile.ItemProjectile;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Scorpion
extends Monster
implements IGahAnimatedMob {
    public static final double FOLLOW_RANGE = 25.0;
    private static final double MELEE_RANGE = 5.0;
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.scorpion.idle");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.scorpion.walk");
    private static final RawAnimation ATTACK_ANIMATION = RawAnimation.begin().thenPlay("animation.scorpion.attack").thenLoop("animation.scorpion.walk");
    private static final RawAnimation SHOOT_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.scorpion.shoot");
    private State state;
    private boolean resetAnimation = false;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Scorpion(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.state = State.IDLE;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new ScorpionRangedAttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new ScorpionMeleeAttackGoal());
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(5, (Goal)new ScorpionRandomMovementGoal());
    }

    @Override
    public void setSidedAnimationState(int state, boolean isClient) {
        this.state = State.values()[state];
        this.resetAnimation = isClient && this.state == State.ATTACK;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("scorpionState", this.state.ordinal());
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("scorpionState")) {
            this.state = State.values()[nbt.m_128451_("scorpionState")];
        }
    }

    @Override
    public GahDamage onDirectDamage(LivingEntity target) {
        return new GahCombat(this.getStats()).calculatePowerDamage((Entity)target);
    }

    @Override
    public GahDamage onIndirectDamage(Entity directDamageDealer, LivingEntity target) {
        return new GahCombat(this.getStats()).calculateMagicDamage((Entity)target);
    }

    @Override
    public boolean shouldResetAnimation() {
        return this.resetAnimation;
    }

    @Override
    public void onResetAnimation() {
        this.resetAnimation = false;
    }

    @Override
    public RawAnimation tickAnimation(AnimationState<GeoAnimatable> event) {
        switch (this.state) {
            case WALK: {
                return WALK_ANIMATION;
            }
            case ATTACK: {
                return ATTACK_ANIMATION;
            }
            case SHOOT: {
                return SHOOT_ANIMATION;
            }
        }
        return IDLE_ANIMATION;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)Sounds.SCORPION_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_33034_) {
        return (SoundEvent)Sounds.HISSING_HURT.get();
    }

    protected void setState(State state) {
        this.setAnimationState(state.ordinal());
    }

    protected static enum State {
        IDLE,
        WALK,
        ATTACK,
        SHOOT;

    }

    protected class ScorpionRangedAttackGoal
    extends GahRangedAttackGoal {
        public ScorpionRangedAttackGoal() {
            super((Mob)Scorpion.this);
        }

        @Override
        public boolean m_8036_() {
            if (super.m_8036_()) {
                Scorpion.this.setState(State.SHOOT);
                return true;
            }
            return false;
        }

        public void m_8041_() {
            super.m_8041_();
            Scorpion.this.setState(State.IDLE);
        }

        @Override
        protected boolean canShoot() {
            if (super.canShoot()) {
                Scorpion.this.m_216990_((SoundEvent)Sounds.POISON_SHOT_SHOOT.get());
                return true;
            }
            return false;
        }

        @Override
        protected boolean isInRange(LivingEntity target) {
            return super.isInRange(target) && !this.isInRange(target, 5.0);
        }

        @Override
        @NotNull
        protected GahThrowableProjectileBase createProjectile() {
            return new ItemProjectile((EntityType<? extends ItemProjectile>)((EntityType)ProjectileEntityRegistry.SCORPION_PROJECTILE.get()), (LivingEntity)Scorpion.this, 0.004f, SoundEvents.f_12133_, SoundEvents.f_12133_);
        }
    }

    protected class ScorpionMeleeAttackGoal
    extends MeleeAttackGoal {
        public ScorpionMeleeAttackGoal() {
            super((PathfinderMob)Scorpion.this, 1.0, true);
        }

        public boolean m_8036_() {
            if (super.m_8036_() && Scorpion.this.state != State.SHOOT) {
                Scorpion.this.setState(State.WALK);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (!super.m_8045_()) {
                return false;
            }
            LivingEntity target = Scorpion.this.m_5448_();
            if (target == null) {
                return false;
            }
            return this.isInMeleeRange(target);
        }

        public void m_8041_() {
            super.m_8041_();
            Scorpion.this.setState(State.IDLE);
        }

        protected void m_6739_(@NotNull LivingEntity target, double unused) {
            if (this.isInMeleeRange(target) && this.m_25564_()) {
                this.m_25563_();
                Scorpion.this.m_6674_(InteractionHand.MAIN_HAND);
                Scorpion.this.m_7327_((Entity)target);
                Scorpion.this.setState(State.ATTACK);
            }
        }

        private boolean isInMeleeRange(LivingEntity target) {
            return this.f_25540_.m_20191_().m_82377_(5.0, 4.0, 5.0).m_82381_(target.m_20191_());
        }
    }

    protected class ScorpionRandomMovementGoal
    extends WaterAvoidingRandomStrollGoal {
        public ScorpionRandomMovementGoal() {
            super((PathfinderMob)Scorpion.this, 0.75, 0.05f);
        }

        public boolean m_8036_() {
            if (super.m_8036_() && Scorpion.this.state == State.IDLE) {
                Scorpion.this.setState(State.WALK);
                return true;
            }
            return false;
        }

        public void m_8041_() {
            super.m_8041_();
            Scorpion.this.setState(State.IDLE);
        }
    }
}

