/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.entities.living.IGahAnimatedMob;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Sphinx
extends Monster
implements IGahAnimatedMob {
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.sphinx.idle");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.sphinx.walk");
    private static final RawAnimation LUNGE_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.sphinx.attack");
    private State state = State.IDLE;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Sphinx(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new LungeAttackPlayer());
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(5, (Goal)new SphinxRandomMovementGoal());
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public void setSidedAnimationState(int state, boolean isClient) {
        this.state = State.values()[state];
    }

    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("sphinxState", this.state.ordinal());
    }

    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128441_("sphinxState")) {
            this.state = State.values()[nbt.m_128451_("sphinxState")];
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)Sounds.SPHINX_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_33034_) {
        return (SoundEvent)Sounds.SPHINX_HURT.get();
    }

    private void setState(State state) {
        this.setAnimationState(state.ordinal());
    }

    @Override
    public RawAnimation tickAnimation(AnimationState<GeoAnimatable> event) {
        switch (this.state) {
            case WALK: {
                return WALK_ANIMATION;
            }
            case ATTACK: {
                return LUNGE_ANIMATION;
            }
        }
        return IDLE_ANIMATION;
    }

    private static enum State {
        IDLE,
        WALK,
        ATTACK;

    }

    private class LungeAttackPlayer
    extends MeleeAttackGoal {
        private int ticksInAir;
        private boolean hasLunged;

        public LungeAttackPlayer() {
            super((PathfinderMob)Sphinx.this, 1.0, true);
            this.hasLunged = false;
            this.ticksInAir = 0;
        }

        protected void m_6739_(@NotNull LivingEntity target, double unused) {
            if (!this.m_25564_()) {
                return;
            }
            Sphinx.this.setState(State.ATTACK);
        }

        public void m_8056_() {
            super.m_8056_();
            Sphinx.this.setState(State.WALK);
        }

        public void m_8041_() {
            super.m_8041_();
            Sphinx.this.setState(State.IDLE);
        }

        public void m_8037_() {
            Sphinx sphinx = Sphinx.this;
            LivingEntity target = sphinx.m_5448_();
            if (target == null) {
                return;
            }
            if (sphinx.state != State.ATTACK) {
                super.m_8037_();
                return;
            }
            if (!this.hasLunged) {
                this.hasLunged = true;
                Sphinx.this.m_21391_((Entity)target, 50.0f, 50.0f);
                Sphinx.this.m_5616_(Sphinx.this.m_146908_());
                Sphinx.this.f_21342_ = new MoveControl((Mob)Sphinx.this){

                    public void m_8126_() {
                    }
                };
                Sphinx.this.f_21344_.m_26573_();
                sphinx.m_20256_(this.calculateLungeDelta(target));
            }
            if (sphinx.m_217066_(target) && sphinx.m_21574_().m_148306_((Entity)target)) {
                sphinx.m_6674_(InteractionHand.MAIN_HAND);
                sphinx.m_7327_((Entity)target);
            }
            if (sphinx.m_20096_() && this.ticksInAir > 20) {
                Sphinx.this.f_21342_ = new MoveControl((Mob)Sphinx.this);
                Sphinx.this.m_21573_().m_5624_((Entity)target, 1.0);
                this.m_25563_();
                this.hasLunged = false;
                this.ticksInAir = 0;
                Sphinx.this.setState(State.WALK);
            } else {
                ++this.ticksInAir;
            }
        }

        private Vec3 calculateLungeDelta(LivingEntity target) {
            Sphinx sphinx = Sphinx.this;
            Vec3 directionVector = target.m_146892_().m_82546_(sphinx.m_146892_()).m_82541_();
            Vec3 originalDeltaMovement = sphinx.m_20184_();
            if (originalDeltaMovement.f_82480_ <= 0.0) {
                originalDeltaMovement = new Vec3(originalDeltaMovement.f_82479_, 0.375, originalDeltaMovement.f_82481_);
            }
            return originalDeltaMovement.m_82549_(directionVector);
        }
    }

    private class SphinxRandomMovementGoal
    extends WaterAvoidingRandomStrollGoal {
        public SphinxRandomMovementGoal() {
            super((PathfinderMob)Sphinx.this, 0.75, 0.05f);
        }

        public boolean m_8036_() {
            return super.m_8036_() && Sphinx.this.state == State.IDLE;
        }

        public void m_8056_() {
            super.m_8056_();
            Sphinx.this.setState(State.WALK);
        }

        public void m_8041_() {
            super.m_8041_();
            Sphinx.this.setState(State.IDLE);
        }
    }
}

