/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living;

import com.dee12452.gahoodrpg.common.data.GahWorldSavedData;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.living.GahMonsterBase;
import com.dee12452.gahoodrpg.common.items.Items;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Tradekeeper
extends GahMonsterBase<State, AnimationState>
implements Merchant {
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.tradekeeper.idle");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.tradekeeper.walk");
    @Nullable
    private Player tradingPlayer;
    private MerchantOffers offers;

    public Tradekeeper(EntityType<? extends Tradekeeper> entityType, Level level) {
        super(entityType, level);
        this.offers = Tradekeeper.createOffers(level);
    }

    public void m_20258_(CompoundTag p_20259_) {
        super.m_20258_(p_20259_);
        this.setEntityState(State.IDLE);
        this.setAnimationState(AnimationState.IDLE);
    }

    @Override
    protected AnimationState valueToAnimationState(int value) {
        return AnimationState.values()[value];
    }

    @Override
    protected State valueToEntityState(int value) {
        return State.values()[value];
    }

    public void m_7189_(@Nullable Player player) {
        this.tradingPlayer = player;
        if (player == null) {
            this.setEntityState(State.IDLE);
            this.setAnimationState(AnimationState.IDLE);
        }
    }

    @Nullable
    public Player m_7962_() {
        return this.tradingPlayer;
    }

    @NotNull
    public MerchantOffers m_6616_() {
        return this.offers;
    }

    public void m_6255_(@NotNull MerchantOffers merchantOffers) {
        this.offers = merchantOffers;
    }

    public void m_6996_(@NotNull MerchantOffer merchantOffer) {
    }

    public void m_7713_(@NotNull ItemStack stack) {
        if (!this.m_183595_() || stack.m_41619_()) {
            return;
        }
        this.m_5496_(this.m_7596_(), this.m_6121_(), this.m_6100_());
    }

    public int m_7809_() {
        return 0;
    }

    public void m_6621_(int p_45309_) {
    }

    public boolean m_7826_() {
        return false;
    }

    @NotNull
    public SoundEvent m_7596_() {
        return SoundEvents.f_12509_;
    }

    public boolean m_183595_() {
        return this.m_9236_().m_5776_();
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand interactionHand) {
        if (!this.m_183595_()) {
            this.m_7189_(player);
            this.m_45301_(player, this.m_5446_(), 1);
            this.setEntityState(State.SHOPPING);
            this.setAnimationState(AnimationState.IDLE);
        }
        return InteractionResult.m_19078_((boolean)this.m_183595_());
    }

    private static MerchantOffers createOffers(Level level) {
        ItemStack price2;
        ItemStack price1;
        MerchantOffers offers = new MerchantOffers();
        if (level.f_46443_) {
            return offers;
        }
        MinecraftServer server = ((ServerLevel)level).m_7654_();
        GahWorldSavedData savedData = GahWorldSavedData.load(server);
        if (savedData.isTheEnragedSlain()) {
            ItemStack price = new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42616_, 1);
            offers.add((Object)Tradekeeper.createOffer(price, new ItemStack((ItemLike)Items.ANCIENT_OAK_LOG.get(), 3)));
            offers.add((Object)Tradekeeper.createOffer(price, new ItemStack((ItemLike)Items.GLIMMERITE.get(), 3)));
            offers.add((Object)Tradekeeper.createOffer(price, new ItemStack((ItemLike)Items.RAW_TIN.get())));
            offers.add((Object)Tradekeeper.createOffer(price, new ItemStack((ItemLike)Items.RAW_LEAD.get())));
            offers.add((Object)Tradekeeper.createOffer(price, new ItemStack((ItemLike)net.minecraft.world.item.Items.f_151051_, 3)));
        }
        if (savedData.isThePharaohSlain()) {
            price1 = new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42616_, 3);
            offers.add((Object)Tradekeeper.createOffer(price1, new ItemStack((ItemLike)Items.RED_SAGUARO.get(), 3)));
            offers.add((Object)Tradekeeper.createOffer(price1, new ItemStack((ItemLike)Items.EMBERSTONE.get(), 3)));
            offers.add((Object)Tradekeeper.createOffer(price1, new ItemStack((ItemLike)Items.RAW_PLATINUM.get())));
            offers.add((Object)Tradekeeper.createOffer(price1, new ItemStack((ItemLike)Items.SUNFIRE_DUST.get())));
            price2 = new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42616_, 5);
            offers.add((Object)Tradekeeper.createOffer(price2, new ItemStack((ItemLike)Items.PHOENIXITE.get())));
            offers.add((Object)Tradekeeper.createOffer(price2, new ItemStack((ItemLike)Items.CARNELIAN.get())));
        }
        if (savedData.isTheDruidSlain()) {
            price1 = new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42616_, 8);
            offers.add((Object)Tradekeeper.createOffer(price1, new ItemStack((ItemLike)Items.JUNGLE_ROOT.get(), 3)));
            offers.add((Object)Tradekeeper.createOffer(price1, new ItemStack((ItemLike)Items.FERNIUM.get(), 3)));
            offers.add((Object)Tradekeeper.createOffer(price1, new ItemStack((ItemLike)Items.RAW_VINEGOLD.get())));
            price2 = new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42616_, 10);
            offers.add((Object)Tradekeeper.createOffer(price2, new ItemStack((ItemLike)Items.RAW_SCARLETITE.get())));
            offers.add((Object)Tradekeeper.createOffer(price2, new ItemStack((ItemLike)Items.RAW_PANTHERITE.get())));
            offers.add((Object)Tradekeeper.createOffer(price2, new ItemStack((ItemLike)Items.RAW_JADESTONE.get())));
        }
        if (savedData.isEnderDragonSlain()) {
            offers.add((Object)Tradekeeper.createOffer(new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42616_, 10), new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42584_, 5), new ItemStack((ItemLike)Items.ENDER_SCALE.get())));
        }
        if (savedData.isChieftainerSlain()) {
            offers.add((Object)Tradekeeper.createOffer(new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42616_, 15), new ItemStack((ItemLike)Items.JADESTONE.get(), 5), new ItemStack((ItemLike)Items.TOPAZ.get())));
        }
        if (savedData.isSentinelSlain()) {
            offers.add((Object)Tradekeeper.createOffer(new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42616_, 15), new ItemStack((ItemLike)Items.JADESTONE.get(), 5), new ItemStack((ItemLike)Items.AQUAMARINE.get())));
        }
        if (savedData.isWardenSlain()) {
            offers.add((Object)Tradekeeper.createOffer(new ItemStack((ItemLike)net.minecraft.world.item.Items.f_42616_, 15), new ItemStack((ItemLike)Items.JADESTONE.get(), 5), new ItemStack((ItemLike)Items.DEEP_ROCK.get())));
        }
        return offers;
    }

    private static MerchantOffer createOffer(ItemStack cost, ItemStack result) {
        return Tradekeeper.createOffer(cost, ItemStack.f_41583_, result);
    }

    private static MerchantOffer createOffer(ItemStack cost1, ItemStack cost2, ItemStack result) {
        return new MerchantOffer(cost1, cost2, result, 0, Integer.MAX_VALUE, 0, 0.0f, 0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new RandomMovementGoal());
    }

    public static enum State implements GahEntityState
    {
        IDLE,
        WALK,
        SHOPPING;


        @Override
        public int value() {
            return this.ordinal();
        }
    }

    public static enum AnimationState implements GahAnimationState
    {
        IDLE(IDLE_ANIMATION),
        WALK(WALK_ANIMATION);

        private final RawAnimation animation;

        private AnimationState(RawAnimation animation) {
            this.animation = animation;
        }

        @Override
        public int value() {
            return this.ordinal();
        }

        @Override
        public RawAnimation animation() {
            return this.animation;
        }
    }

    private class RandomMovementGoal
    extends WaterAvoidingRandomStrollGoal {
        public RandomMovementGoal() {
            super((PathfinderMob)Tradekeeper.this, 1.0, 0.05f);
        }

        public boolean m_8036_() {
            if (super.m_8036_() && Tradekeeper.this.getEntityState() == State.IDLE) {
                Tradekeeper.this.setEntityState(State.WALK);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return super.m_8045_() && Tradekeeper.this.getEntityState() == State.WALK;
        }

        public void m_8056_() {
            super.m_8056_();
            Tradekeeper.this.setAnimationState(AnimationState.WALK);
        }

        public void m_8041_() {
            super.m_8041_();
            Tradekeeper.this.setEntityState(State.IDLE);
            Tradekeeper.this.setAnimationState(AnimationState.IDLE);
        }
    }
}

