/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living.ai;

import com.dee12452.gahoodrpg.common.entities.projectile.GahThrowableProjectileBase;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public abstract class GahRangedAttackGoal
extends Goal {
    private final Mob mob;
    private int rangedAttackTick;

    public GahRangedAttackGoal(Mob mob) {
        this.mob = mob;
    }

    public boolean m_8036_() {
        Player player;
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return false;
        }
        if (target instanceof Player && ((player = (Player)target).m_5833_() || player.m_7500_())) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        return this.isInRange(target);
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        super.m_8056_();
        this.rangedAttackTick = 0;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        this.lookAtTarget(target);
        ++this.rangedAttackTick;
        if (!this.canShoot()) {
            return;
        }
        GahThrowableProjectileBase projectile = this.createProjectile();
        projectile.shootFromEntity((LivingEntity)this.mob, 1.5f, 0.1f);
        this.mob.m_9236_().m_7967_((Entity)projectile);
    }

    protected boolean isInRange(LivingEntity target) {
        double range = this.mob.m_21133_(Attributes.f_22277_);
        return this.isInRange(target, range);
    }

    protected final boolean isInRange(LivingEntity target, double range) {
        return this.mob.m_20191_().m_82377_(range, 4.0, range).m_82381_(target.m_20191_());
    }

    protected void lookAtTarget(LivingEntity target) {
        this.mob.m_21391_((Entity)target, 50.0f, 50.0f);
        this.mob.m_5616_(this.mob.m_146908_());
    }

    protected final int getAttackTicks() {
        return this.rangedAttackTick;
    }

    protected boolean canShoot() {
        return this.getAttackTicks() % 60 == 0;
    }

    @NotNull
    protected abstract GahThrowableProjectileBase createProjectile();
}

