/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living.boss;

import com.dee12452.gahoodrpg.common.data.Cooldown;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.living.ai.SerializableCooldownGoal;
import com.dee12452.gahoodrpg.common.entities.living.ai.SerializableGoal;
import com.dee12452.gahoodrpg.common.entities.living.boss.GahWorldBossBase;
import com.dee12452.gahoodrpg.common.entities.projectile.ChieftainerFang;
import com.dee12452.gahoodrpg.common.entities.projectile.GahLightningBolt;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.NbtUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Chieftainer
extends GahWorldBossBase<State, AnimationState> {
    private static final EntityDataAccessor<Float> CUSTOM_Y_ROT = SynchedEntityData.m_135353_(Chieftainer.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private SerializableGoal randomTeleportGoal;
    private SerializableGoal spawnVexesGoal;
    private SerializableGoal shootGoal;
    private SerializableGoal whirlGoal;
    private SerializableGoal strikeDownGoal;
    private INBTSerializable<CompoundTag> combatWalkGoal;
    private SerializableGoal spawnFriendliesGoal;

    public Chieftainer(EntityType<? extends Chieftainer> entityType, Level level) {
        super((EntityType<? extends GahWorldBossBase>)entityType, level);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("randomTeleportGoal", this.randomTeleportGoal.serializeNBT());
        nbt.m_128365_("spawnVexesGoal", this.spawnVexesGoal.serializeNBT());
        nbt.m_128365_("shootGoal", this.shootGoal.serializeNBT());
        nbt.m_128365_("whirlGoal", this.whirlGoal.serializeNBT());
        nbt.m_128365_("strikeDownGoal", this.strikeDownGoal.serializeNBT());
        nbt.m_128365_("combatWalkGoal", this.combatWalkGoal.serializeNBT());
        nbt.m_128365_("spawnFriendliesGoal", this.spawnFriendliesGoal.serializeNBT());
        nbt.m_128350_("customYRot", ((Float)this.f_19804_.m_135370_(CUSTOM_Y_ROT)).floatValue());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.randomTeleportGoal.deserializeNBT((Tag)nbt.m_128469_("randomTeleportGoal"));
        this.spawnVexesGoal.deserializeNBT((Tag)nbt.m_128469_("spawnVexesGoal"));
        this.shootGoal.deserializeNBT((Tag)nbt.m_128469_("shootGoal"));
        this.whirlGoal.deserializeNBT((Tag)nbt.m_128469_("whirlGoal"));
        this.strikeDownGoal.deserializeNBT((Tag)nbt.m_128469_("strikeDownGoal"));
        this.combatWalkGoal.deserializeNBT((Tag)nbt.m_128469_("combatWalkGoal"));
        this.spawnFriendliesGoal.deserializeNBT((Tag)nbt.m_128469_("spawnFriendliesGoal"));
        this.f_19804_.m_135381_(CUSTOM_Y_ROT, (Object)Float.valueOf(nbt.m_128457_("customYRot")));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CUSTOM_Y_ROT, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        if (accessor.equals(CUSTOM_Y_ROT)) {
            float newYRot = ((Float)this.f_19804_.m_135370_(CUSTOM_Y_ROT)).floatValue();
            this.m_146922_(newYRot);
            this.m_5618_(newYRot);
            this.m_5616_(newYRot);
        }
    }

    @Override
    protected AnimationState valueToAnimationState(int value) {
        return AnimationState.values()[value];
    }

    @Override
    protected State valueToEntityState(int value) {
        return State.values()[value];
    }

    @Override
    protected void registerBossGoals(GoalSelector goals) {
        this.shootGoal = new ShootGoal();
        this.randomTeleportGoal = new RandomTeleportGoal();
        this.spawnVexesGoal = new SpawnVexesGoal();
        this.whirlGoal = new WhirlGoal();
        this.strikeDownGoal = new StrikeDownGoal();
        this.combatWalkGoal = new RandomBattleWalk();
        this.spawnFriendliesGoal = new RandomlySpawnFriendlyGoal();
        this.f_21345_.m_25352_(5, (Goal)this.strikeDownGoal);
        this.f_21345_.m_25352_(6, (Goal)this.whirlGoal);
        this.f_21345_.m_25352_(7, (Goal)this.shootGoal);
        this.f_21345_.m_25352_(8, (Goal)this.randomTeleportGoal);
        this.f_21345_.m_25352_(9, (Goal)this.spawnVexesGoal);
        this.f_21345_.m_25352_(10, (Goal)new WalkGoal());
        this.f_21345_.m_25352_(11, (Goal)this.combatWalkGoal);
        this.f_21345_.m_25352_(12, (Goal)this.spawnFriendliesGoal);
        this.f_21345_.m_25352_(13, (Goal)new RandomlyDespawnGoal());
    }

    public boolean m_6469_(@NotNull DamageSource source, float p_21017_) {
        Entity entity = source.m_7639_();
        if (entity instanceof Raider) {
            Raider raider = (Raider)entity;
            raider.m_6710_(null);
            return false;
        }
        return super.m_6469_(source, p_21017_);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11861_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11864_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_32654_) {
        return SoundEvents.f_11866_;
    }

    public static enum AnimationState implements GahAnimationState
    {
        IDLE(RawAnimation.begin().thenLoop("animation.chieftainer.idle")),
        WALK(RawAnimation.begin().thenLoop("animation.chieftainer.walk")),
        STRIKE_DOWN(TimeUtils.secondsToTicks(1.25f), RawAnimation.begin().thenPlay("animation.chieftainer.strike_down")),
        WHIRL(RawAnimation.begin().thenLoop("animation.chieftainer.whirl")),
        SHOOT(TimeUtils.secondsToTicks(1.0f), RawAnimation.begin().thenPlay("animation.chieftainer.shoot"));

        private final int duration;
        private final RawAnimation animation;

        private AnimationState(RawAnimation animation) {
            this(0, animation);
        }

        private AnimationState(int duration, RawAnimation animation) {
            this.duration = duration;
            this.animation = animation;
        }

        @Override
        public int value() {
            return this.ordinal();
        }

        @Override
        public RawAnimation animation() {
            return this.animation;
        }
    }

    public static enum State implements GahEntityState
    {
        IDLE,
        WALK,
        COMBAT_WALK,
        STRIKE_DOWN,
        WHIRL,
        SHOOT,
        SPAWN_VEXES,
        TELEPORT;


        @Override
        public int value() {
            return this.ordinal();
        }
    }

    private class ShootGoal
    extends SerializableGoal {
        private int goalTick = 0;
        private boolean hasShot = false;

        private ShootGoal() {
        }

        public boolean m_8036_() {
            if (Chieftainer.this.getEntityState() == State.SHOOT) {
                return true;
            }
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{Chieftainer.this.getEntityState() == State.IDLE, Chieftainer.this.getPlayerTarget().isPresent()});
            if (Chieftainer.this.allChecksPass(checks)) {
                Chieftainer.this.setEntityState(State.SHOOT);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return Chieftainer.this.getPlayerTarget().isPresent() && this.goalTick < AnimationState.SHOOT.duration;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            Chieftainer.this.setAnimationState(AnimationState.SHOOT);
            Chieftainer.this.getPlayerTarget().ifPresent(arg_0 -> ((LookControl)Chieftainer.this.m_21563_()).m_148051_(arg_0));
        }

        public void m_8041_() {
            super.m_8041_();
            this.goalTick = 0;
            this.hasShot = false;
            Chieftainer.this.setPlayerTarget(null);
            Chieftainer.this.setAnimationState(AnimationState.IDLE);
            Chieftainer.this.setEntityState(State.IDLE);
        }

        public void m_8037_() {
            super.m_8037_();
            if (!this.hasShot && this.goalTick > AnimationState.SHOOT.duration * 2 / 3) {
                this.shoot();
                this.hasShot = true;
            }
            ++this.goalTick;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("goalTick", this.goalTick);
            nbt.m_128379_("hasShot", this.hasShot);
            return nbt;
        }

        public void deserializeNBT(CompoundTag compoundTag) {
            this.goalTick = compoundTag.m_128451_("goalTick");
            this.hasShot = compoundTag.m_128471_("hasShot");
        }

        private void shoot() {
            if (Chieftainer.this.getPlayerTarget().isEmpty()) {
                return;
            }
            ChieftainerFang fang = new ChieftainerFang((LivingEntity)Chieftainer.this);
            fang.shootDirectlyAtEntity((LivingEntity)Chieftainer.this.getPlayerTarget().get(), 2.0f);
            Chieftainer.this.m_9236_().m_7967_((Entity)fang);
        }
    }

    private class RandomTeleportGoal
    extends SerializableCooldownGoal {
        public RandomTeleportGoal() {
            super(TimeUtils.secondsToTicks(15.0f));
        }

        public boolean m_8036_() {
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{Chieftainer.this.getEntityState() == State.IDLE, Chieftainer.this.hasPlayers(), this.cooldown.check((LivingEntity)Chieftainer.this), Chieftainer.this.rollRandom(10)});
            if (Chieftainer.this.allChecksPass(checks)) {
                this.cooldown.reset((LivingEntity)Chieftainer.this);
                Chieftainer.this.setEntityState(State.TELEPORT);
                return true;
            }
            return false;
        }

        public void m_8041_() {
            int checksLeft;
            super.m_8041_();
            Chieftainer.this.setEntityState(State.IDLE);
            if (!Chieftainer.this.hasPlayers()) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)Chieftainer.this.m_9236_();
            List<ServerPlayer> allPlayers = Chieftainer.this.getPlayers(serverLevel);
            ServerPlayer player = allPlayers.get(Chieftainer.this.m_217043_().m_188503_(allPlayers.size()));
            BlockPos pos = player.m_20183_();
            pos = new BlockPos(Chieftainer.this.m_217043_().m_216332_(-5, 5) + pos.m_123341_(), pos.m_123342_(), Chieftainer.this.m_217043_().m_216332_(-5, 5) + pos.m_123343_());
            for (checksLeft = 25; checksLeft > 0 && WorldUtils.isNotAir((Level)serverLevel, pos) && WorldUtils.isNotAir((Level)serverLevel, pos.m_7494_()); --checksLeft) {
                pos = new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
            }
            if (checksLeft <= 0) {
                Chieftainer.this.setEntityState(State.IDLE);
                return;
            }
            this.showTeleportParticles(serverLevel);
            Chieftainer.this.m_6021_(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_());
            EntityUtils.playSound((LivingEntity)Chieftainer.this, SoundEvents.f_11852_);
            Chieftainer.this.setPlayerTarget((Player)player);
            Chieftainer.this.m_21563_().m_148051_((Entity)player);
            this.showTeleportParticles(serverLevel);
        }

        private void showTeleportParticles(ServerLevel serverLevel) {
            for (int times = 0; times < 4; ++times) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123771_, Chieftainer.this.m_20185_(), Chieftainer.this.m_20186_(), Chieftainer.this.m_20189_(), 1, 0.05, 0.05, 0.05, 0.25);
            }
        }
    }

    private class SpawnVexesGoal
    extends SerializableCooldownGoal {
        public SpawnVexesGoal() {
            super(TimeUtils.secondsToTicks(10.0f));
        }

        public boolean m_8036_() {
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{Chieftainer.this.getEntityState() == State.IDLE, Chieftainer.this.hasPlayers(), Chieftainer.this.getFriendliesCount() < Chieftainer.this.getPlayerCount(), this.cooldown.check((LivingEntity)Chieftainer.this)});
            if (Chieftainer.this.allChecksPass(checks)) {
                this.cooldown.reset((LivingEntity)Chieftainer.this);
                Chieftainer.this.setEntityState(State.SPAWN_VEXES);
                return true;
            }
            return false;
        }

        public void m_8041_() {
            super.m_8041_();
            Chieftainer.this.setEntityState(State.IDLE);
            if (!Chieftainer.this.hasPlayers()) {
                return;
            }
            ServerLevel serverlevel = (ServerLevel)Chieftainer.this.m_9236_();
            RandomSource random = Chieftainer.this.m_217043_();
            int vexesToSpawn = Chieftainer.this.getPlayerCount() - Chieftainer.this.getFriendliesCount();
            if (vexesToSpawn <= 0) {
                return;
            }
            EntityUtils.playSound((LivingEntity)Chieftainer.this, SoundEvents.f_11862_);
            float f = Chieftainer.this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)Chieftainer.this.f_19797_ * 0.6662f)) * 0.25f;
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            serverlevel.m_8767_((ParticleOptions)ParticleTypes.f_123811_, Chieftainer.this.m_20185_() + (double)f1 * 0.6, Chieftainer.this.m_20186_() + 1.8, Chieftainer.this.m_20189_() + (double)f2 * 0.6, 5, 0.1, 0.1, 0.1, 1.0);
            for (int i = 0; i < vexesToSpawn; ++i) {
                BlockPos blockpos = Chieftainer.this.m_20183_().m_7918_(-2 + random.m_188503_(5), 1, -2 + random.m_188503_(5));
                Vex vex = (Vex)EntityType.f_20491_.m_20615_((Level)serverlevel);
                if (vex == null) continue;
                vex.m_20035_(blockpos, 0.0f, 0.0f);
                vex.m_6518_((ServerLevelAccessor)serverlevel, serverlevel.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                vex.m_33994_((Mob)Chieftainer.this);
                vex.m_34033_(blockpos);
                vex.m_33987_(20 * (30 + random.m_188503_(90)));
                serverlevel.m_47205_((Entity)vex);
                Chieftainer.this.getRandomPlayer(serverlevel).ifPresent(arg_0 -> ((Vex)vex).m_6710_(arg_0));
                vex.m_21561_(true);
                Chieftainer.this.addFriendly((Mob)vex);
            }
        }
    }

    private class WhirlGoal
    extends SerializableCooldownGoal {
        private int goalTicks;

        public WhirlGoal() {
            super(TimeUtils.secondsToTicks(20.0f));
            this.goalTicks = 0;
        }

        public boolean m_8036_() {
            if (Chieftainer.this.getEntityState() == State.WHIRL) {
                return true;
            }
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{Chieftainer.this.hasPlayers() && Chieftainer.this.getEntityState() == State.IDLE, this.cooldown.check((LivingEntity)Chieftainer.this), Chieftainer.this.rollRandom(5)});
            if (Chieftainer.this.allChecksPass(checks)) {
                this.cooldown.reset((LivingEntity)Chieftainer.this);
                Chieftainer.this.setEntityState(State.WHIRL);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.goalTicks < TimeUtils.secondsToTicks(5.0f);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            Chieftainer.this.setAnimationState(AnimationState.WHIRL);
            this.goalTicks = 0;
            Chieftainer.this.m_20331_(true);
        }

        public void m_8041_() {
            super.m_8041_();
            Chieftainer.this.setAnimationState(AnimationState.IDLE);
            Chieftainer.this.setEntityState(State.IDLE);
            Chieftainer.this.m_20331_(false);
        }

        public void m_8037_() {
            super.m_8037_();
            float yRot = Chieftainer.this.m_146908_() + 30.0f >= 360.0f ? 0.0f : Chieftainer.this.m_146908_() + 30.0f;
            Chieftainer.this.f_19804_.m_135381_(CUSTOM_Y_ROT, (Object)Float.valueOf(yRot));
            if (Chieftainer.this.rollRandom(2)) {
                this.shoot();
            }
            ++this.goalTicks;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = super.serializeNBT();
            nbt.m_128405_("goalTicks", this.goalTicks);
            return nbt;
        }

        @Override
        public void deserializeNBT(CompoundTag compoundTag) {
            super.deserializeNBT(compoundTag);
            this.goalTicks = compoundTag.m_128451_("goalTicks");
        }

        private void shoot() {
            ChieftainerFang fang = new ChieftainerFang((LivingEntity)Chieftainer.this);
            fang.shootFromEntity((LivingEntity)Chieftainer.this, 2.0f, 0.0f);
            Chieftainer.this.m_9236_().m_7967_((Entity)fang);
        }
    }

    private class StrikeDownGoal
    extends SerializableCooldownGoal {
        private int goalTicks;
        private boolean hasStruck;
        private final List<BlockPos> strikeLocations;

        public StrikeDownGoal() {
            super(TimeUtils.secondsToTicks(20.0f));
            this.goalTicks = 0;
            this.hasStruck = false;
            this.strikeLocations = new ArrayList<BlockPos>();
        }

        public boolean m_8036_() {
            if (Chieftainer.this.getEntityState() == State.STRIKE_DOWN) {
                return true;
            }
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{Chieftainer.this.getEntityState() == State.IDLE, this.cooldown.check((LivingEntity)Chieftainer.this), Chieftainer.this.rollRandom(20), Chieftainer.this.hasPlayers()});
            if (Chieftainer.this.allChecksPass(checks)) {
                this.cooldown.reset((LivingEntity)Chieftainer.this);
                Chieftainer.this.setEntityState(State.STRIKE_DOWN);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return Chieftainer.this.hasPlayers() && this.goalTicks < AnimationState.STRIKE_DOWN.duration;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            Chieftainer.this.setAnimationState(AnimationState.STRIKE_DOWN);
            this.goalTicks = 0;
            this.hasStruck = false;
            this.strikeLocations.clear();
            ServerLevel serverLevel = (ServerLevel)Chieftainer.this.m_9236_();
            List<ServerPlayer> allPlayers = Chieftainer.this.getPlayers(serverLevel);
            ServerPlayer randomPlayer = allPlayers.get(Chieftainer.this.m_217043_().m_188503_(allPlayers.size()));
            Chieftainer.this.m_21563_().m_148051_((Entity)randomPlayer);
            this.strikeLocations.addAll(allPlayers.stream().map(Entity::m_20183_).toList());
        }

        public void m_8041_() {
            super.m_8041_();
            Chieftainer.this.setAnimationState(AnimationState.IDLE);
            Chieftainer.this.setEntityState(State.IDLE);
        }

        public void m_8037_() {
            super.m_8037_();
            if (!this.hasStruck && this.goalTicks > AnimationState.STRIKE_DOWN.duration * 2 / 3) {
                for (BlockPos loc : this.strikeLocations) {
                    GahLightningBolt bolt = new GahLightningBolt((LivingEntity)Chieftainer.this, Chieftainer.this.m_9236_());
                    bolt.setTargetBlock(loc);
                    Chieftainer.this.m_9236_().m_7967_((Entity)bolt);
                }
                this.hasStruck = true;
            }
            ++this.goalTicks;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = super.serializeNBT();
            nbt.m_128405_("goalTicks", this.goalTicks);
            nbt.m_128379_("hasStruck", this.hasStruck);
            NbtUtils.writeList(nbt, "strikeLocations", this.strikeLocations, NbtUtils::writeBlockPos);
            return nbt;
        }

        @Override
        public void deserializeNBT(CompoundTag compoundTag) {
            super.deserializeNBT(compoundTag);
            this.goalTicks = compoundTag.m_128451_("goalTicks");
            this.hasStruck = compoundTag.m_128471_("hasStruck");
            this.strikeLocations.clear();
            this.strikeLocations.addAll(NbtUtils.readList(compoundTag, "strikeLocations", NbtUtils::readBlockPos));
        }
    }

    private class RandomBattleWalk
    extends WaterAvoidingRandomStrollGoal
    implements INBTSerializable<CompoundTag> {
        private final Cooldown cooldown;

        public RandomBattleWalk() {
            super((PathfinderMob)Chieftainer.this, 1.1);
            this.cooldown = new Cooldown(TimeUtils.secondsToTicks(3.0f));
        }

        public boolean m_8036_() {
            if (Chieftainer.this.getEntityState() == State.COMBAT_WALK) {
                this.m_8041_();
            }
            if (!super.m_8036_()) {
                return false;
            }
            if (Chieftainer.this.getEntityState() == State.IDLE && this.cooldown.check((LivingEntity)Chieftainer.this) && Chieftainer.this.rollRandom(5)) {
                Chieftainer.this.setEntityState(State.COMBAT_WALK);
                this.cooldown.reset((LivingEntity)Chieftainer.this);
                return true;
            }
            return false;
        }

        public void m_8056_() {
            super.m_8056_();
            Chieftainer.this.setAnimationState(AnimationState.WALK);
        }

        public void m_8041_() {
            super.m_8041_();
            Chieftainer.this.setAnimationState(AnimationState.IDLE);
            Chieftainer.this.setEntityState(State.IDLE);
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("cooldown", (Tag)this.cooldown.serializeNBT());
            return nbt;
        }

        public void deserializeNBT(CompoundTag compoundTag) {
            this.cooldown.deserializeNBT(compoundTag.m_128469_("cooldown"));
        }
    }

    private class RandomlySpawnFriendlyGoal
    extends SerializableCooldownGoal {
        public RandomlySpawnFriendlyGoal() {
            super(TimeUtils.secondsToTicks(60.0f));
        }

        public boolean m_8036_() {
            return Chieftainer.this.hasPlayers() && Chieftainer.this.rollRandom(100) && this.cooldown.checkAndReset((LivingEntity)Chieftainer.this);
        }

        public void m_8041_() {
            super.m_8041_();
            EntityType randomRaiderType = (EntityType)Lists.newArrayList((Object[])new EntityType[]{EntityType.f_20513_, EntityType.f_20568_, EntityType.f_20493_, EntityType.f_20495_}).get(Chieftainer.this.m_217043_().m_188503_(4));
            Raider raider = (Raider)randomRaiderType.m_262496_((ServerLevel)Chieftainer.this.m_9236_(), Chieftainer.this.m_20183_(), MobSpawnType.MOB_SUMMONED);
            if (raider == null) {
                return;
            }
            ServerLevel level = (ServerLevel)Chieftainer.this.m_9236_();
            Chieftainer.this.getRandomPlayer(level).ifPresent(arg_0 -> ((Raider)raider).m_6710_(arg_0));
            raider.m_21561_(true);
            level.m_7967_((Entity)raider);
        }
    }

    private class WalkGoal
    extends WaterAvoidingRandomStrollGoal {
        public WalkGoal() {
            super((PathfinderMob)Chieftainer.this, 0.75);
        }

        public boolean m_8036_() {
            if (!super.m_8036_() || !Chieftainer.this.hasPlayers()) {
                return false;
            }
            if (Chieftainer.this.getEntityState() == State.IDLE) {
                Chieftainer.this.setEntityState(State.WALK);
                return true;
            }
            return Chieftainer.this.getEntityState() == State.WALK;
        }

        public void m_8056_() {
            super.m_8056_();
            Chieftainer.this.setAnimationState(AnimationState.WALK);
        }

        public void m_8041_() {
            super.m_8041_();
            Chieftainer.this.setAnimationState(AnimationState.IDLE);
            Chieftainer.this.setEntityState(State.IDLE);
        }
    }

    private class RandomlyDespawnGoal
    extends Goal {
        private RandomlyDespawnGoal() {
        }

        public boolean m_8036_() {
            return Chieftainer.this.f_19797_ > TimeUtils.secondsToTicks(60.0f) && Chieftainer.this.rollRandom(50);
        }

        public void m_8041_() {
            super.m_8041_();
            AABB searchBox = Chieftainer.this.m_20191_().m_82377_(50.0, 10.0, 50.0);
            boolean shouldDiscard = EntityUtils.getTargetablePlayers((ServerLevel)Chieftainer.this.m_9236_(), searchBox).stream().map(Entity::m_20148_).toList().isEmpty();
            if (shouldDiscard) {
                Chieftainer.this.onRemovedFromWorld();
                Chieftainer.this.m_146870_();
            }
        }
    }
}

