/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living.boss;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.living.GahMonsterBase;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientStopSound;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.NbtUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GahBossBase<S extends GahEntityState, A extends GahAnimationState>
extends GahMonsterBase<S, A> {
    protected final ServerBossEvent bossEvent = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
    private int lastMusicTick;
    private final List<UUID> players;
    private final List<UUID> friendlies;
    @Nullable
    protected BlockPos firstTickPos;

    public GahBossBase(EntityType<? extends GahBossBase> entityType, Level level) {
        super(entityType, level);
        this.bossEvent.m_7003_(true);
        this.lastMusicTick = -1;
        this.players = new ArrayList<UUID>();
        this.friendlies = new ArrayList<UUID>();
    }

    public void scaleHealthToPlayers() {
        this.scaleHealth(this.players.size());
    }

    public void scaleHealth(int times) {
        float previousHealthPercent = this.getHealthPercent();
        AttributeInstance attr = this.getAttributeUnsafe(Attributes.f_22276_);
        double maxHealth = attr.m_22115_() * (double)times;
        attr.m_22100_(maxHealth);
        this.m_21153_(previousHealthPercent * (float)maxHealth);
    }

    public void addPlayer(ServerPlayer player) {
        this.players.add(player.m_20148_());
        this.bossEvent.m_6543_(player);
    }

    public void removePlayer(ServerPlayer player) {
        this.players.removeIf(p -> player.m_20148_().equals(p));
        this.bossEvent.m_6539_(player);
    }

    public void removeAllPlayers() {
        this.players.clear();
        this.bossEvent.m_7706_();
    }

    public List<ServerPlayer> getPlayers(ServerLevel level) {
        return this.players.stream().map(arg_0 -> ((ServerLevel)level).m_46003_(arg_0)).filter(Objects::nonNull).map(p -> (ServerPlayer)p).toList();
    }

    public Optional<ServerPlayer> getRandomPlayer(ServerLevel level) {
        List<ServerPlayer> players = this.getPlayers(level);
        if (players.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(players.get(this.m_217043_().m_188503_(players.size())));
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    public boolean hasPlayers() {
        return !this.players.isEmpty();
    }

    public void addFriendly(Mob mob) {
        this.friendlies.add(mob.m_20148_());
    }

    public void removeFriendly(Mob mob) {
        this.friendlies.removeIf(f -> mob.m_20148_().equals(f));
    }

    public void removeDeadFriendlies(ServerLevel level) {
        this.getFriendlies(level).stream().filter(e -> !e.m_6084_()).forEach(this::removeFriendly);
    }

    public void removeAllFriendlies() {
        this.friendlies.clear();
    }

    public int getFriendliesCount() {
        return this.friendlies.size();
    }

    @Override
    public boolean isBoss() {
        return true;
    }

    public int getLastMusicTick() {
        return this.lastMusicTick;
    }

    public void setLastMusicTick(int lastMusicTick) {
        this.lastMusicTick = lastMusicTick;
    }

    public boolean isSoloFight(ServerLevel level) {
        return this.getPlayers(level).size() == 1;
    }

    public ServerBossEvent getBossEvent() {
        return this.bossEvent;
    }

    public List<Mob> getFriendlies(ServerLevel level) {
        return this.friendlies.stream().map(arg_0 -> ((ServerLevel)level).m_8791_(arg_0)).filter(e -> e instanceof Mob).map(e -> (Mob)e).toList();
    }

    public List<Mob> getLivingFriendlies(ServerLevel level) {
        return this.friendlies.stream().map(arg_0 -> ((ServerLevel)level).m_8791_(arg_0)).filter(e -> {
            Mob mob;
            return e instanceof Mob && (mob = (Mob)e).m_6084_();
        }).map(e -> (Mob)e).toList();
    }

    public List<ServerPlayer> getPlayersSortedByDistance(ServerLevel level) {
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>(this.getPlayers(level));
        players.sort(Comparator.comparingDouble(arg_0 -> ((GahBossBase)this).m_20270_(arg_0)));
        return players;
    }

    public void m_6667_(@NotNull DamageSource damageSource) {
        super.m_6667_(damageSource);
        this.bossEvent.m_142711_(0.0f);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.friendlies.clear();
        this.friendlies.addAll(NbtUtils.readList(nbt, "friendlies", CompoundTag::m_128342_));
        this.bossEvent.m_7706_();
        this.players.clear();
        this.players.addAll(NbtUtils.readList(nbt, "playerIds", CompoundTag::m_128342_));
        nbt.m_128379_("firstTickPosExists", this.firstTickPos != null);
        if (this.firstTickPos != null) {
            NbtUtils.writeBlockPos(nbt, "firstTickPos", this.firstTickPos);
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        NbtUtils.writeList(nbt, "friendlies", this.friendlies, CompoundTag::m_128362_);
        NbtUtils.writeList(nbt, "playerIds", this.players, CompoundTag::m_128362_);
        if (nbt.m_128471_("firstTickPosExists")) {
            this.firstTickPos = NbtUtils.readBlockPos(nbt, "firstTickPos");
        }
    }

    public void clearFriendlies(ServerLevel level) {
        this.friendlies.stream().map(arg_0 -> ((ServerLevel)level).m_8791_(arg_0)).filter(Objects::nonNull).forEach(Entity::m_146870_);
        this.friendlies.clear();
    }

    public float getHealthPercent() {
        return this.m_21223_() / this.m_21233_();
    }

    public void m_142687_(@NotNull Entity.RemovalReason p_276115_) {
        super.m_142687_(p_276115_);
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (this.getBossMusic() != null) {
            NetworkChannel.sendToClients(this.getPlayers(level2), new ClientStopSound.Message(this.getBossMusic(), SoundSource.MUSIC));
        }
        this.bossEvent.m_7706_();
        this.clearFriendlies(level2);
    }

    protected boolean m_6125_() {
        return false;
    }

    protected void m_8024_() {
        if (this.f_19797_ <= 1) {
            this.firstTickPos = this.m_20183_();
        }
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.bossEvent.m_8324_().size() != this.players.size()) {
            this.bossEvent.m_7706_();
            this.getPlayers((ServerLevel)this.m_9236_()).forEach(arg_0 -> ((ServerBossEvent)this.bossEvent).m_6543_(arg_0));
        }
        this.onServerTick((ServerLevel)this.m_9236_());
    }

    protected void m_8099_() {
        this.registerBossGoals(this.f_21345_);
        if (this.getBossMusic() != null) {
            this.f_21345_.m_25352_(11, (Goal)new LoopMusicBossGoal());
        }
    }

    @Nullable
    protected SoundEvent getBossMusic() {
        return (SoundEvent)Sounds.BOSS_MUSIC.get();
    }

    protected Optional<ServerPlayer> findRandomPlayerTarget(ServerLevel level) {
        List<ServerPlayer> players = EntityUtils.getTargetablePlayers(level);
        if (players.isEmpty()) {
            return Optional.empty();
        }
        int randomIdx = this.m_217043_().m_188503_(players.size());
        return Optional.of(players.get(randomIdx));
    }

    protected void onServerTick(ServerLevel serverLevel) {
    }

    protected abstract void registerBossGoals(GoalSelector var1);

    private class LoopMusicBossGoal
    extends Goal {
        private static final int MUSIC_DURATION_IN_SECONDS = 205;
        private static final int MUSIC_TICK_DURATION = 4100;

        private LoopMusicBossGoal() {
        }

        public boolean m_8036_() {
            if (GahBossBase.this.getLastMusicTick() == -1) {
                return true;
            }
            ServerLevel serverLevel = (ServerLevel)GahBossBase.this.m_9236_();
            return serverLevel.m_7654_().m_129921_() - GahBossBase.this.getLastMusicTick() > 4100;
        }

        public void m_8056_() {
            super.m_8056_();
            ClientStopSound.Message musicMessage = new ClientStopSound.Message(SoundEvents.f_271165_, SoundSource.MASTER);
            GahBossBase.this.getPlayers((ServerLevel)GahBossBase.this.m_9236_()).forEach(p -> NetworkChannel.sendToClient(p, musicMessage));
            Integer tickCount = Optional.ofNullable(GahBossBase.this.m_20194_()).map(MinecraftServer::m_129921_).orElseThrow();
            GahBossBase.this.setLastMusicTick(tickCount);
            if (GahBossBase.this.getBossMusic() != null) {
                GahBossBase.this.m_9236_().m_247517_(null, GahBossBase.this.m_20097_(), GahBossBase.this.getBossMusic(), SoundSource.MUSIC);
            }
        }
    }
}

