/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living.boss;

import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.living.boss.GahBossBase;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.NbtUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GahWorldBossBase<S extends GahEntityState, A extends GahAnimationState>
extends GahBossBase<S, A> {
    private int maxPlayerCount = 1;
    @Nullable
    private UUID playerTarget;

    public GahWorldBossBase(EntityType<? extends GahWorldBossBase> entityType, Level level) {
        super((EntityType<? extends GahBossBase>)entityType, level);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.maxPlayerCount = nbt.m_128451_("maxPlayerCount");
        this.playerTarget = NbtUtils.getIfPresent(nbt, "playerTarget", CompoundTag::m_128342_).orElse(null);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("maxPlayerCount", this.maxPlayerCount);
        NbtUtils.putIfPresent(nbt, "playerTarget", this.playerTarget, CompoundTag::m_128362_);
    }

    @Override
    public Optional<ServerPlayer> getPlayerTarget() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return Optional.ofNullable(this.playerTarget).map(arg_0 -> ((ServerLevel)serverLevel).m_46003_(arg_0)).map(p -> (ServerPlayer)p);
        }
        return Optional.empty();
    }

    public void setPlayerTarget(@Nullable Player player) {
        this.playerTarget = Optional.ofNullable(player).map(Entity::m_20148_).orElse(null);
    }

    public int getMaxPlayerCount() {
        return this.maxPlayerCount;
    }

    @Override
    protected boolean m_6125_() {
        return true;
    }

    @Override
    protected void onServerTick(ServerLevel serverLevel) {
        super.onServerTick(serverLevel);
        this.tickPlayers(serverLevel);
        this.removeDeadFriendlies(serverLevel);
    }

    @Override
    @Nullable
    protected SoundEvent getBossMusic() {
        return null;
    }

    protected AABB getPlayerSearchBox() {
        return this.m_20191_().m_82377_(50.0, 10.0, 50.0);
    }

    protected void tickPlayers(ServerLevel serverLevel) {
        if (this.f_19797_ % 20 == 0) {
            AABB searchBox = this.getPlayerSearchBox();
            this.removeAllPlayers();
            EntityUtils.getTargetablePlayers(serverLevel, searchBox).forEach(this::addPlayer);
        }
        if (this.maxPlayerCount < this.getPlayerCount()) {
            this.maxPlayerCount = this.getPlayerCount();
            this.scaleHealth(this.maxPlayerCount);
            for (ServerPlayer player : this.getPlayers(serverLevel)) {
                player.m_5661_((Component)Component.m_237115_((String)"message.gahoodrpg.boss.more_players"), true);
            }
        }
    }
}

