/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living.boss;

import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahDamageSource;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.living.ai.SerializableCooldownGoal;
import com.dee12452.gahoodrpg.common.entities.living.ai.SerializableGoal;
import com.dee12452.gahoodrpg.common.entities.living.boss.GahWorldBossBase;
import com.dee12452.gahoodrpg.common.entities.projectile.SentinelBeam;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.NbtUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Sentinel
extends GahWorldBossBase<State, AnimationState> {
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.sentinel.idle");
    private static final RawAnimation IDLE_RETRACTED_ANIMATION = RawAnimation.begin().thenLoop("animation.sentinel.retracted.idle");
    private static final RawAnimation PREPARE_BEAM_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.sentinel.prepare_beam");
    private static final RawAnimation PREPARE_BEAM_RETRACTED_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.sentinel.retracted.prepare_beam");
    private static final RawAnimation BEAM_ANIMATION = RawAnimation.begin().thenLoop("animation.sentinel.beam");
    private static final RawAnimation BEAM_RETRACTED_ANIMATION = RawAnimation.begin().thenLoop("animation.sentinel.retracted.beam");
    private static final List<oshi.util.tuples.Pair<AnimationState, AnimationState>> RETRACTED_PAIRS = Lists.newArrayList((Object[])new oshi.util.tuples.Pair[]{new oshi.util.tuples.Pair((Object)AnimationState.IDLE, (Object)AnimationState.IDLE_RETRACTED), new oshi.util.tuples.Pair((Object)AnimationState.PREPARE_BEAM, (Object)AnimationState.PREPARE_BEAM_RETRACTED), new oshi.util.tuples.Pair((Object)AnimationState.BEAM, (Object)AnimationState.BEAM_RETRACTED)});
    private boolean floatUp = true;
    private boolean retracted = false;
    private SerializableGoal retractGoal;
    private SerializableGoal spawnBeamsGoal;
    private SerializableGoal selectPlayerGoal;
    private SerializableGoal spawnGuardiansGoal;
    private ShootBeamGoal shootBeamGoal;

    public Sentinel(EntityType<? extends Sentinel> entityType, Level level) {
        super((EntityType<? extends GahWorldBossBase>)entityType, level);
        this.disableVanillaRotation();
    }

    @Override
    public void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("retracted", this.retracted);
        nbt.m_128379_("floatUp", this.floatUp);
        nbt.m_128365_("retractGoal", this.retractGoal.serializeNBT());
        nbt.m_128365_("spawnBeamsGoal", this.spawnBeamsGoal.serializeNBT());
        nbt.m_128365_("selectPlayerGoal", this.selectPlayerGoal.serializeNBT());
        nbt.m_128365_("shootBeamGoal", (Tag)this.shootBeamGoal.serializeNBT());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.retracted = nbt.m_128471_("retracted");
        this.floatUp = nbt.m_128471_("floatUp");
        this.retractGoal.deserializeNBT((Tag)nbt.m_128469_("retractGoal"));
        this.spawnBeamsGoal.deserializeNBT((Tag)nbt.m_128469_("spawnBeamsGoal"));
        this.selectPlayerGoal.deserializeNBT((Tag)nbt.m_128469_("selectPlayerGoal"));
        this.spawnGuardiansGoal.deserializeNBT((Tag)nbt.m_128469_("spawnGuardiansGoal"));
        this.shootBeamGoal.deserializeNBT(nbt.m_128469_("shootBeamGoal"));
    }

    public boolean m_6469_(@NotNull DamageSource source, float total) {
        if (!(source instanceof GahDamageSource)) {
            return super.m_6469_(source, total);
        }
        GahDamageSource gahDamageSource = (GahDamageSource)source;
        if (this.retracted && !gahDamageSource.isMagicDamage()) {
            if (this.shootBeamGoal != null) {
                --this.shootBeamGoal.hitsToCancel;
            }
            return super.m_6469_(source, total);
        }
        if (!this.retracted && !gahDamageSource.isPowerDamage()) {
            if (this.shootBeamGoal != null) {
                --this.shootBeamGoal.hitsToCancel;
            }
            return super.m_6469_(source, total);
        }
        Entity entity = source.m_7639_();
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            GahDamage damage = this.onDirectDamage(target);
            target.m_6469_(GahDamageSource.direct((Entity)this, (Entity)this, damage), damage.total());
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return this.m_20072_() ? SoundEvents.f_11878_ : SoundEvents.f_11879_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_32468_) {
        return this.m_20072_() ? SoundEvents.f_11884_ : SoundEvents.f_11885_;
    }

    protected SoundEvent m_5592_() {
        return this.m_20072_() ? SoundEvents.f_11881_ : SoundEvents.f_11882_;
    }

    @Override
    protected AnimationState valueToAnimationState(int value) {
        return AnimationState.values()[value];
    }

    @Override
    protected State valueToEntityState(int value) {
        return State.values()[value];
    }

    public boolean m_6040_() {
        return true;
    }

    @Override
    protected void onServerTick(ServerLevel serverLevel) {
        super.onServerTick(serverLevel);
        this.followPlayerTarget();
        this.waterFloat();
    }

    private AnimationState getCorrectedAnimationState(AnimationState desiredAnimation) {
        Optional<Object> retractedPair = Optional.empty();
        for (oshi.util.tuples.Pair<AnimationState, AnimationState> pair : RETRACTED_PAIRS) {
            if (pair.getA() != desiredAnimation && pair.getB() != desiredAnimation) continue;
            retractedPair = Optional.of(pair);
            break;
        }
        oshi.util.tuples.Pair animationPair = (oshi.util.tuples.Pair)retractedPair.orElseThrow();
        if (this.retracted) {
            return (AnimationState)animationPair.getB();
        }
        return (AnimationState)animationPair.getA();
    }

    private void waterFloat() {
        if (!this.m_20072_()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.m_9236_();
        if (this.f_19797_ % 20 == 0) {
            this.floatUp = !this.floatUp;
        }
        float yMov = 0.04f * (float)(this.floatUp ? 1 : -1);
        this.m_20334_(0.0, yMov, 0.0);
        if (this.f_19797_ % 3 == 0) {
            Vec3 view = this.m_20252_(0.0f);
            for (int $$2 = 0; $$2 < 2; ++$$2) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123795_, this.m_20208_(0.5) - view.f_82479_ * 1.5, this.m_20187_() - view.f_82480_ * 1.5, this.m_20262_(0.5) - view.f_82481_ * 1.5, 5, 0.0, 0.0, 0.0, 0.25);
            }
        }
    }

    private void followPlayerTarget() {
        Optional<ServerPlayer> target = this.getPlayerTarget();
        if (target.isEmpty()) {
            return;
        }
        Pair<Float, Float> rotation = EntityUtils.getRotationTo((LivingEntity)this, (LivingEntity)target.get());
        this.m_5618_(0.0f);
        this.m_5616_(0.0f);
        this.m_146922_(((Float)rotation.getLeft()).floatValue());
        this.m_146926_(((Float)rotation.getRight()).floatValue());
    }

    @Override
    protected void registerBossGoals(GoalSelector goals) {
        this.retractGoal = new RetractGoal();
        this.spawnBeamsGoal = new SpawnBeamsAroundGoal();
        this.selectPlayerGoal = new SelectPlayerTargetGoal();
        this.spawnGuardiansGoal = new SpawnGuardiansGoal();
        this.shootBeamGoal = new ShootBeamGoal();
        goals.m_25352_(1, (Goal)this.retractGoal);
        goals.m_25352_(2, (Goal)this.shootBeamGoal);
        goals.m_25352_(3, (Goal)this.spawnBeamsGoal);
        goals.m_25352_(9, (Goal)this.spawnGuardiansGoal);
        goals.m_25352_(10, (Goal)this.selectPlayerGoal);
    }

    private class ShootBeamGoal
    extends SerializableCooldownGoal {
        private static final int PREPARE_TICKS = TimeUtils.secondsToTicks(4.0f);
        private static final int SHOOT_TICKS = TimeUtils.secondsToTicks(8.0f);
        @Nullable
        private UUID beam;
        private int goalTick;
        private int hitsToCancel;

        public ShootBeamGoal() {
            super(TimeUtils.secondsToTicks(20.0f));
            this.goalTick = 0;
            this.hitsToCancel = 0;
        }

        public boolean m_8036_() {
            if (Sentinel.this.getEntityState() == State.BEAM_SHOOT) {
                return true;
            }
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{Sentinel.this.getPlayerTarget().isPresent(), Sentinel.this.getEntityState() == State.IDLE, this.cooldown.check((LivingEntity)Sentinel.this)});
            if (Sentinel.this.allChecksPass(checks)) {
                Sentinel.this.setEntityState(State.BEAM_SHOOT);
                this.cooldown.reset((LivingEntity)Sentinel.this);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (Sentinel.this.getPlayerTarget().isEmpty()) {
                return false;
            }
            if (this.goalTick < PREPARE_TICKS && this.hitsToCancel <= 0) {
                return false;
            }
            return this.goalTick < PREPARE_TICKS + SHOOT_TICKS;
        }

        public void m_8056_() {
            super.m_8056_();
            this.goalTick = 0;
            this.beam = null;
            this.hitsToCancel = 3 * Sentinel.this.getPlayerCount();
            Sentinel.this.setAnimationState(Sentinel.this.getCorrectedAnimationState(AnimationState.PREPARE_BEAM));
        }

        public void m_8041_() {
            super.m_8041_();
            this.getBeam().ifPresent(Entity::m_146870_);
            Sentinel.this.setEntityState(State.IDLE);
            Sentinel.this.setAnimationState(Sentinel.this.getCorrectedAnimationState(AnimationState.IDLE));
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.goalTick > PREPARE_TICKS && this.beam == null) {
                this.beam = this.shootBeam().m_20148_();
            } else if (this.beam != null) {
                this.tickBeam();
            }
            ++this.goalTick;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = super.serializeNBT();
            nbt.m_128405_("goalTick", this.goalTick);
            NbtUtils.putIfPresent(nbt, "beam", this.beam, CompoundTag::m_128362_);
            nbt.m_128405_("hitsToCancel", this.hitsToCancel);
            return nbt;
        }

        @Override
        public void deserializeNBT(CompoundTag compoundTag) {
            super.deserializeNBT(compoundTag);
            this.goalTick = compoundTag.m_128451_("goalTick");
            this.beam = NbtUtils.getIfPresent(compoundTag, "beam", CompoundTag::m_128342_).orElse(null);
            this.hitsToCancel = compoundTag.m_128451_("hitsToCancel");
        }

        private Optional<SentinelBeam> getBeam() {
            ServerLevel level = (ServerLevel)Sentinel.this.m_9236_();
            return Optional.ofNullable(this.beam).map(arg_0 -> ((ServerLevel)level).m_8791_(arg_0)).map(b -> (SentinelBeam)((Object)b));
        }

        private SentinelBeam shootBeam() {
            Optional<ServerPlayer> target = Sentinel.this.getPlayerTarget();
            if (target.isEmpty()) {
                return null;
            }
            SentinelBeam beam = new SentinelBeam((LivingEntity)Sentinel.this);
            beam.setScaleRate(0.5f);
            Sentinel.this.m_9236_().m_7967_((Entity)beam);
            this.positionBeam(beam, target.get());
            return beam;
        }

        private void tickBeam() {
            Optional<SentinelBeam> beam = this.getBeam();
            Optional<ServerPlayer> target = Sentinel.this.getPlayerTarget();
            if (target.isEmpty() || beam.isEmpty()) {
                return;
            }
            this.positionBeam(beam.get(), target.get());
        }

        private void positionBeam(@NotNull SentinelBeam beam, ServerPlayer target) {
            Vec3 eyePosition = Sentinel.this.m_20299_(1.0f);
            Vec3 lookVector = Sentinel.this.m_20252_(1.0f);
            double offsetX = lookVector.f_82479_;
            double offsetY = lookVector.f_82480_;
            double offsetZ = lookVector.f_82481_;
            beam.m_6034_(eyePosition.f_82479_ + offsetX, eyePosition.f_82480_ + offsetY, eyePosition.f_82481_ + offsetZ);
            beam.setProjectileYRot(-Sentinel.this.m_146908_());
            beam.setProjectileXRot(90.0f + Sentinel.this.m_146909_());
            beam.setTarget((Player)target);
        }
    }

    public static enum AnimationState implements GahAnimationState
    {
        IDLE(IDLE_ANIMATION),
        IDLE_RETRACTED(IDLE_RETRACTED_ANIMATION),
        PREPARE_BEAM(PREPARE_BEAM_ANIMATION, TimeUtils.secondsToTicks(0.75f)),
        PREPARE_BEAM_RETRACTED(PREPARE_BEAM_RETRACTED_ANIMATION, TimeUtils.secondsToTicks(0.75f)),
        BEAM(BEAM_ANIMATION),
        BEAM_RETRACTED(BEAM_RETRACTED_ANIMATION);

        private final RawAnimation animation;
        private final int duration;

        private AnimationState(RawAnimation animation) {
            this(animation, -1);
        }

        private AnimationState(RawAnimation animation, int duration) {
            this.animation = animation;
            this.duration = duration;
        }

        @Override
        public int value() {
            return this.ordinal();
        }

        @Override
        public RawAnimation animation() {
            return this.animation;
        }

        public int getDuration() {
            return this.duration;
        }
    }

    public static enum State implements GahEntityState
    {
        IDLE,
        BEAM_AROUND,
        BEAM_SHOOT;


        @Override
        public int value() {
            return this.ordinal();
        }
    }

    private class RetractGoal
    extends SerializableCooldownGoal {
        public RetractGoal() {
            super(TimeUtils.secondsToTicks(20.0f));
        }

        public boolean m_8036_() {
            return this.cooldown.checkAndReset((LivingEntity)Sentinel.this);
        }

        public void m_8041_() {
            super.m_8041_();
            Sentinel.this.retracted = !Sentinel.this.retracted;
            AnimationState animation = (AnimationState)Sentinel.this.getAnimationState();
            Sentinel.this.setAnimationState(Sentinel.this.getCorrectedAnimationState(animation));
        }
    }

    private class SpawnBeamsAroundGoal
    extends SerializableCooldownGoal {
        private static final int TICK_DURATION = TimeUtils.secondsToTicks(3.0f);
        private int goalTick;
        private int timesSpawned;

        public SpawnBeamsAroundGoal() {
            super(TimeUtils.secondsToTicks(10.0f));
            this.goalTick = 0;
            this.timesSpawned = 0;
        }

        public boolean m_8036_() {
            if (Sentinel.this.getEntityState() == State.BEAM_AROUND) {
                return true;
            }
            ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{Sentinel.this.getEntityState() == State.IDLE, Sentinel.this.hasPlayers(), this.cooldown.check((LivingEntity)Sentinel.this)});
            if (Sentinel.this.allChecksPass(checks)) {
                Sentinel.this.setEntityState(State.BEAM_AROUND);
                this.cooldown.reset((LivingEntity)Sentinel.this);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.goalTick < TICK_DURATION;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            super.m_8056_();
            this.goalTick = 0;
            this.timesSpawned = 0;
        }

        public void m_8041_() {
            super.m_8041_();
            Sentinel.this.setEntityState(State.IDLE);
        }

        public void m_8037_() {
            super.m_8037_();
            if (this.goalTick > 0 && this.timesSpawned == 0) {
                this.spawnBeams(++this.timesSpawned);
            } else if (this.goalTick > TICK_DURATION / 3 && this.timesSpawned == 1) {
                this.spawnBeams(++this.timesSpawned);
            } else if (this.goalTick > TICK_DURATION * 2 / 3 && this.timesSpawned == 2) {
                this.spawnBeams(++this.timesSpawned);
            }
            ++this.goalTick;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = super.serializeNBT();
            nbt.m_128405_("goalTick", this.goalTick);
            nbt.m_128405_("timesSpawned", this.timesSpawned);
            return nbt;
        }

        @Override
        public void deserializeNBT(CompoundTag compoundTag) {
            super.deserializeNBT(compoundTag);
            this.goalTick = compoundTag.m_128451_("goalTick");
            this.timesSpawned = compoundTag.m_128451_("timesSpawned");
        }

        private void spawnBeams(int time) {
            BlockPos pos = Sentinel.this.m_20183_();
            int dist = 5 * time;
            ArrayList positionsToBeam = Lists.newArrayList((Object[])new BlockPos[]{pos.m_122013_(dist), pos.m_122020_(dist), pos.m_122030_(dist), pos.m_122025_(dist)});
            positionsToBeam.forEach(this::spawnBeam);
        }

        private void spawnBeam(BlockPos pos) {
            SentinelBeam beam = new SentinelBeam((LivingEntity)Sentinel.this);
            beam.m_146884_(WorldUtils.toVec3(pos));
            beam.m_20334_(0.0, -0.075, 0.0);
            Sentinel.this.m_9236_().m_7967_((Entity)beam);
        }
    }

    private class SelectPlayerTargetGoal
    extends SerializableCooldownGoal {
        public SelectPlayerTargetGoal() {
            super(TimeUtils.secondsToTicks(10.0f));
        }

        public boolean m_8036_() {
            return Sentinel.this.hasPlayers() && this.cooldown.checkAndReset((LivingEntity)Sentinel.this);
        }

        public void m_8041_() {
            super.m_8041_();
            ServerLevel level = (ServerLevel)Sentinel.this.m_9236_();
            List<ServerPlayer> players = Sentinel.this.getPlayers(level);
            Sentinel.this.setPlayerTarget((Player)players.get(Sentinel.this.m_217043_().m_188503_(players.size())));
        }
    }

    private class SpawnGuardiansGoal
    extends SerializableCooldownGoal {
        public SpawnGuardiansGoal() {
            super(TimeUtils.secondsToTicks(25.0f));
        }

        public boolean m_8036_() {
            return this.getGuardiansToSpawn() > 0 && this.cooldown.checkAndReset((LivingEntity)Sentinel.this);
        }

        public void m_8041_() {
            super.m_8041_();
            ServerLevel level = (ServerLevel)Sentinel.this.m_9236_();
            for (int guardiansToSpawn = this.getGuardiansToSpawn(); guardiansToSpawn > 0; --guardiansToSpawn) {
                Guardian newGuardian = (Guardian)EntityType.f_20455_.m_262496_(level, Sentinel.this.m_20183_(), MobSpawnType.MOB_SUMMONED);
                if (newGuardian == null) continue;
                Sentinel.this.addFriendly((Mob)newGuardian);
                Sentinel.this.getPlayerTarget().ifPresent(target -> {
                    newGuardian.m_6710_((LivingEntity)target);
                    newGuardian.m_21561_(true);
                });
            }
        }

        private int getGuardiansToSpawn() {
            return Sentinel.this.getPlayerCount() * 2 - Sentinel.this.getFriendliesCount();
        }
    }
}

