/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living.boss;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.combat.GahDamageSource;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.living.GahSkeleton;
import com.dee12452.gahoodrpg.common.entities.living.boss.GahBossBase;
import com.dee12452.gahoodrpg.common.entities.living.boss.ai.SpawnFriendliesGoal;
import com.dee12452.gahoodrpg.common.registries.LivingEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class TheEnraged
extends GahBossBase<Phase, GahAnimationState> {
    @Nullable
    private Consumer<DamageSource> onActuallyHurt;

    public TheEnraged(EntityType<TheEnraged> entityType, Level level) {
        super((EntityType<? extends GahBossBase>)entityType, level);
    }

    @Override
    protected GahAnimationState valueToAnimationState(int value) {
        return GahAnimationState.EMPTY;
    }

    @Override
    protected Phase valueToEntityState(int value) {
        return Phase.values()[value];
    }

    @Override
    @Nullable
    protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
        return null;
    }

    @Override
    protected void registerBossGoals(GoalSelector goalSelector) {
        goalSelector.m_25352_(1, (Goal)new TheEnragedSpawnFriendliesPhaseGoal());
        goalSelector.m_25352_(2, (Goal)new TheEnragedMeleeAttackGoal());
    }

    protected void m_6475_(@NotNull DamageSource damageSource, float amount) {
        super.m_6475_(damageSource, amount);
        if (this.onActuallyHurt != null) {
            this.onActuallyHurt.accept(damageSource);
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)Sounds.THE_ENRAGED_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_33034_) {
        return (SoundEvent)Sounds.THE_ENRAGED_HURT.get();
    }

    public static enum Phase implements GahEntityState
    {
        NONE,
        SPAWN_FRIENDLIES,
        MELEE_ATTACK;


        @Override
        public int value() {
            return this.ordinal();
        }
    }

    private class TheEnragedSpawnFriendliesPhaseGoal
    extends SpawnFriendliesGoal {
        private float nextHealthPercent;

        public TheEnragedSpawnFriendliesPhaseGoal() {
            super(TheEnraged.this, true);
            this.nextHealthPercent = 0.75f;
        }

        public boolean m_8036_() {
            if (TheEnraged.this.getEntityState() != Phase.NONE) {
                return false;
            }
            if (TheEnraged.this.getHealthPercent() <= this.nextHealthPercent) {
                TheEnraged.this.setEntityState(Phase.SPAWN_FRIENDLIES);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return TheEnraged.this.getFriendlies((ServerLevel)TheEnraged.this.m_9236_()).stream().anyMatch(LivingEntity::m_6084_);
        }

        @Override
        public void m_8056_() {
            super.m_8056_();
            TheEnraged.this.m_20331_(true);
        }

        @Override
        public void m_8041_() {
            super.m_8041_();
            TheEnraged.this.setEntityState(Phase.NONE);
            TheEnraged.this.m_20331_(false);
            this.nextHealthPercent = Math.max(this.nextHealthPercent - 0.25f, 0.0f);
            TheEnraged.this.removeAllFriendlies();
        }

        @Override
        protected int getSpawnCount() {
            return TheEnraged.this.isSoloFight((ServerLevel)TheEnraged.this.m_9236_()) ? 2 : 5;
        }

        @Override
        protected Optional<? extends Monster> createFriendly(int spawnNumber) {
            if (TheEnraged.this.firstTickPos == null) {
                return Optional.empty();
            }
            HashMap<Integer, EntityType<? extends Monster>> viableMonsterTypes = new HashMap<Integer, EntityType<? extends Monster>>(){
                {
                    int idx = 0;
                    this.put(idx++, (EntityType)LivingEntityRegistry.ENRAGED_SKELETON.get());
                    this.put(idx++, (EntityType)LivingEntityRegistry.ENRAGED_SPIDER.get());
                    this.put(idx++, (EntityType)LivingEntityRegistry.ENRAGED_CREEPER.get());
                    this.put(idx, (EntityType)LivingEntityRegistry.ENRAGED_ZOMBIE.get());
                }
            };
            double x = TheEnraged.this.firstTickPos.m_123341_() + TheEnraged.this.m_217043_().m_188503_(8) * (TheEnraged.this.m_217043_().m_188499_() ? 1 : -1);
            double z = TheEnraged.this.firstTickPos.m_123343_() + TheEnraged.this.m_217043_().m_188503_(8) * (TheEnraged.this.m_217043_().m_188499_() ? 1 : -1);
            double y = TheEnraged.this.firstTickPos.m_123342_() + 1;
            int monsterTypeIdx = TheEnraged.this.m_217043_().m_188503_(viableMonsterTypes.size());
            Optional<? extends Monster> monster = this.tryCreateFriendly((EntityType<? extends Monster>)((EntityType)viableMonsterTypes.get(monsterTypeIdx)), new Vec3(x, y, z));
            List<ServerPlayer> allPlayers = TheEnraged.this.getPlayers((ServerLevel)TheEnraged.this.m_9236_());
            return monster.map(m -> {
                if (m instanceof GahSkeleton) {
                    GahSkeleton skeleton = (GahSkeleton)m;
                    skeleton.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
                }
                m.m_6710_((LivingEntity)allPlayers.get(m.m_217043_().m_188503_(allPlayers.size())));
                return m;
            });
        }
    }

    private class TheEnragedMeleeAttackGoal
    extends MeleeAttackGoal {
        private static final int COOLDOWN = TimeUtils.secondsToTicks(2.0f);
        private static final int TELEPORT_COOLDOWN = TimeUtils.secondsToTicks(4.0f);
        private int cooldownTicks;
        private int hitsUntilStop;
        private int teleportCooldownTicks;

        public TheEnragedMeleeAttackGoal() {
            super((PathfinderMob)TheEnraged.this, 1.0, true);
            this.cooldownTicks = 0;
            this.hitsUntilStop = 0;
            this.teleportCooldownTicks = TELEPORT_COOLDOWN;
        }

        public boolean m_8036_() {
            if (this.cooldownTicks < COOLDOWN) {
                ++this.cooldownTicks;
                return false;
            }
            if (TheEnraged.this.getEntityState() != Phase.NONE) {
                return false;
            }
            Optional<ServerPlayer> target = TheEnraged.this.findRandomPlayerTarget((ServerLevel)TheEnraged.this.m_9236_());
            if (target.isEmpty()) {
                return false;
            }
            TheEnraged.this.m_6710_((LivingEntity)target.get());
            if (super.m_8036_()) {
                TheEnraged.this.setEntityState(Phase.MELEE_ATTACK);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity target = TheEnraged.this.m_5448_();
            if (!(target instanceof ServerPlayer)) {
                return false;
            }
            ServerPlayer serverPlayer = (ServerPlayer)target;
            if (!EntityUtils.isPlayerTargetable((Player)serverPlayer)) {
                return false;
            }
            return this.hitsUntilStop > 0;
        }

        public void m_8056_() {
            TheEnraged.this.onActuallyHurt = this::onEnragedHurt;
            this.teleportCooldownTicks = TELEPORT_COOLDOWN;
            this.resetHitsToStop();
            super.m_8056_();
        }

        public void m_8041_() {
            TheEnraged.this.setEntityState(Phase.NONE);
            TheEnraged.this.m_6710_(null);
            TheEnraged.this.onActuallyHurt = null;
            this.cooldownTicks = 0;
            super.m_8041_();
        }

        public void m_8037_() {
            LivingEntity livingEntity = TheEnraged.this.m_5448_();
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer target = (ServerPlayer)livingEntity;
            this.teleportCooldownTicks = Math.max(0, this.teleportCooldownTicks - 1);
            int randFactor = (int)Math.ceil(10.0f * (1.0f - TheEnraged.this.getHealthPercent()));
            Vec3 pos = TheEnraged.this.m_20318_(1.0f);
            if (this.teleportCooldownTicks == 0 && TheEnraged.this.m_217043_().m_188503_(25 - randFactor) == 0) {
                this.teleportCooldownTicks = TELEPORT_COOLDOWN;
                this.teleportToPlayer(target);
                if (TheEnraged.this.m_9236_().m_8055_(TheEnraged.this.m_20183_().m_7495_()).m_60795_()) {
                    TheEnraged.this.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
                }
            }
            super.m_8037_();
        }

        private void onEnragedHurt(DamageSource source) {
            if (!GahDamageSource.is(source)) {
                return;
            }
            LivingEntity livingEntity = TheEnraged.this.m_5448_();
            if (!(livingEntity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer target = (ServerPlayer)livingEntity;
            Entity entity = source.m_7639_();
            if (!(entity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer attacker = (ServerPlayer)entity;
            if (TheEnraged.this.isSoloFight((ServerLevel)TheEnraged.this.m_9236_())) {
                this.hitsUntilStop = Math.max(this.hitsUntilStop - 1, 0);
            } else if (!EntityUtils.is((Entity)target, (Entity)attacker)) {
                this.hitsUntilStop = Math.max(this.hitsUntilStop - 1, 0);
            }
        }

        private void teleportToPlayer(ServerPlayer player) {
            EntityUtils.teleportToTarget((LivingEntity)TheEnraged.this, (LivingEntity)player, 8, true);
            TheEnraged.this.m_21573_().m_5624_((Entity)player, 1.0);
            TheEnraged.this.m_21563_().m_24960_((Entity)player, 30.0f, 30.0f);
        }

        private void resetHitsToStop() {
            this.hitsUntilStop = 5;
        }
    }
}

