/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living.boss;

import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.living.boss.GahBossBase;
import com.dee12452.gahoodrpg.common.entities.living.boss.ai.SpawnFriendliesGoal;
import com.dee12452.gahoodrpg.common.entities.projectile.GahLightningBolt;
import com.dee12452.gahoodrpg.common.registries.LivingEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.RawAnimation;

public class ThePharaoh
extends GahBossBase<Phase, Phase> {
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.the_pharaoh.idle");
    private static final RawAnimation LEAP_START_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.the_pharaoh.leap_start");
    private static final RawAnimation LEAP_ANIMATION = RawAnimation.begin().thenPlay("animation.the_pharaoh.leap");
    private static final RawAnimation LEAP_END_ANIMATION = RawAnimation.begin().thenPlay("animation.the_pharaoh.leap_end");
    private static final RawAnimation REFLECT_ANIMATION = RawAnimation.begin().thenPlay("animation.the_pharaoh.reflect");
    private static final RawAnimation WHACK_ANIMATION = RawAnimation.begin().thenPlay("animation.the_pharaoh.whack");
    private static final RawAnimation STRIKE_DOWN_START_ANIMATION = RawAnimation.begin().thenPlayAndHold("animation.the_pharaoh.strike_down_start");
    private static final RawAnimation STRIKE_DOWN_ANIMATION = RawAnimation.begin().thenLoop("animation.the_pharaoh.strike_down");
    private static final RawAnimation STRIKE_DOWN_END_ANIMATION = RawAnimation.begin().thenPlay("animation.the_pharaoh.strike_down_end");
    private int goalTick = 0;
    @Nullable
    private Path currentPath;
    private final LeapMoveControl leapMoveControl = new LeapMoveControl();
    private LeapGoal leapGoal;
    private RandomlyTeleportAttackGoal teleportAttackGoal;

    public ThePharaoh(EntityType<? extends GahBossBase> entityType, Level level) {
        super(entityType, level);
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (target instanceof ServerPlayer) {
            ServerPlayer serverPlayer;
            this.leapGoal.target = serverPlayer = (ServerPlayer)target;
            this.teleportAttackGoal.target = serverPlayer;
        }
    }

    @Override
    protected Phase valueToAnimationState(int value) {
        return Phase.values()[value];
    }

    @Override
    protected Phase valueToEntityState(int value) {
        return this.valueToAnimationState(value);
    }

    @Override
    public void setEntityState(Phase state) {
        super.setEntityState(state);
        this.setAnimationState(state);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_33034_) {
        return SoundEvents.f_12608_;
    }

    @Override
    protected void registerBossGoals(GoalSelector goalSelector) {
        this.leapGoal = new LeapGoal();
        this.teleportAttackGoal = new RandomlyTeleportAttackGoal();
        goalSelector.m_25352_(1, (Goal)new StrikeDownGoal());
        goalSelector.m_25352_(2, (Goal)this.leapGoal);
        goalSelector.m_25352_(3, (Goal)this.teleportAttackGoal);
        goalSelector.m_25352_(5, (Goal)new ThePharaohSpawnFriendliesGoal());
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        return 0;
    }

    private void tickLeapStart(ServerPlayer target) {
        if (this.goalTick == 1) {
            --this.goalTick;
            BlockPos targetPos = new BlockPos(this.m_146903_(), this.m_146904_() + 7, this.m_146907_());
            this.currentPath = this.f_21344_.m_7864_(targetPos, 0);
            this.leapMoveControl.yOnly = true;
            this.m_20242_(true);
        }
        if (this.f_21344_.m_26536_(this.currentPath, 1.0)) {
            this.m_21391_((Entity)target, 50.0f, 50.0f);
            this.m_5616_(this.m_146908_());
            return;
        }
        this.m_20256_(Vec3.f_82478_);
        this.setEntityState(Phase.LEAP);
        this.goalTick = 1;
    }

    private void tickLeap(ServerPlayer target) {
        if (this.goalTick == 1) {
            --this.goalTick;
            this.currentPath = this.f_21344_.m_6570_((Entity)target, 0);
            this.leapMoveControl.yOnly = false;
        }
        if (this.f_21344_.m_26536_(this.currentPath, 2.3)) {
            return;
        }
        this.setEntityState(Phase.LEAP_END);
        this.goalTick = LeapGoal.LEAP_END_TICKS;
    }

    private void tickLeapEnd() {
        if (this.goalTick != LeapGoal.LEAP_END_TICKS) {
            --this.goalTick;
            return;
        }
        this.m_20256_(Vec3.f_82478_);
        if (this.firstTickPos != null) {
            this.m_20219_(new Vec3(this.m_20185_(), (double)this.firstTickPos.m_123342_(), this.m_20189_()));
        }
        this.m_20242_(false);
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11892_, SoundSource.HOSTILE, 1.0f, 1.2f / (this.m_217043_().m_188501_() * 0.2f + 0.9f));
        AABB leapHitbox = this.m_20191_().m_82400_(3.0);
        List<ServerPlayer> playersToHurt = EntityUtils.getTargetablePlayers((ServerLevel)this.m_9236_(), leapHitbox);
        playersToHurt.forEach(arg_0 -> ((ThePharaoh)this).m_7327_(arg_0));
        this.goalTick = Math.max(0, this.goalTick - 1);
    }

    private class LeapMoveControl
    extends MoveControl {
        boolean yOnly;

        public LeapMoveControl() {
            super((Mob)ThePharaoh.this);
            this.yOnly = false;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                float speed = (float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_));
                double dy = this.f_24976_ - this.f_24974_.m_20186_();
                if (this.yOnly) {
                    ThePharaoh.this.m_21567_(speed * (float)(dy < 0.0 ? -1 : 1));
                    if (Math.abs(dy) < 0.5 && ThePharaoh.this.currentPath != null && !ThePharaoh.this.currentPath.m_77392_()) {
                        ThePharaoh.this.currentPath.m_77374_();
                    }
                    return;
                }
                double startX = this.f_24974_.m_20185_();
                double startY = this.f_24974_.m_20186_();
                double startZ = this.f_24974_.m_20189_();
                double targetX = this.f_24975_;
                double targetY = this.f_24976_;
                double targetZ = this.f_24977_;
                double dirX = targetX - startX;
                double dirY = targetY - startY;
                double dirZ = targetZ - startZ;
                double distance = Math.sqrt(dirX * dirX + dirY * dirY + dirZ * dirZ);
                double endX = startX + (dirX /= distance) * (double)speed;
                double endY = startY + (dirY /= distance) * (double)speed;
                double endZ = startZ + (dirZ /= distance) * (double)speed;
                this.f_24974_.m_6034_(endX, endY, endZ);
                this.advanceIfPast(startX, startY, startZ, endX, endY, endZ);
            } else {
                this.f_24974_.m_21567_(0.0f);
                this.f_24974_.m_21564_(0.0f);
            }
        }

        private void advanceIfPast(double startX, double startY, double startZ, double endX, double endY, double endZ) {
            if (ThePharaoh.this.currentPath == null) {
                return;
            }
            if (this.didPass(startX, this.f_24975_, endX) || this.didPass(startY, this.f_24976_, endY) || this.didPass(startZ, this.f_24977_, endZ)) {
                ThePharaoh.this.currentPath.m_77374_();
            }
        }

        private boolean didPass(double start, double wanted, double end) {
            return start < wanted && end > wanted || start > wanted && end < wanted;
        }
    }

    private class LeapGoal
    extends Goal {
        private static final int LEAP_HEIGHT = 7;
        private static final int LEAP_END_TICKS = TimeUtils.secondsToTicks(2.0f);
        boolean done = false;
        @Nullable
        ServerPlayer target;

        private LeapGoal() {
        }

        public boolean m_8036_() {
            float healthPercent = ThePharaoh.this.m_21223_() / ThePharaoh.this.m_21233_();
            int extraChance = (int)(10.0f - 10.0f * healthPercent);
            if (ThePharaoh.this.getEntityState() == Phase.IDLE && ThePharaoh.this.randomCheck(20 - extraChance)) {
                ThePharaoh.this.setEntityState(Phase.LEAP_START);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return !this.done;
        }

        public void m_8056_() {
            this.done = false;
            this.target = ThePharaoh.this.findRandomPlayerTarget((ServerLevel)ThePharaoh.this.m_9236_()).orElse(null);
            ThePharaoh.this.f_21342_ = ThePharaoh.this.leapMoveControl;
            ThePharaoh.this.f_21344_ = (PathNavigation)new FlyingPathNavigation((Mob)ThePharaoh.this, ThePharaoh.this.m_9236_());
            ThePharaoh.this.goalTick = 1;
        }

        public void m_8041_() {
            ThePharaoh.this.setEntityState(Phase.IDLE);
            ThePharaoh.this.f_21342_ = new MoveControl((Mob)ThePharaoh.this);
            ThePharaoh.this.f_21344_ = ThePharaoh.this.m_6037_(ThePharaoh.this.m_9236_());
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target == null) {
                this.done = true;
                return;
            }
            if (ThePharaoh.this.getEntityState() == Phase.LEAP_START) {
                ThePharaoh.this.tickLeapStart(this.target);
            } else if (ThePharaoh.this.getEntityState() == Phase.LEAP) {
                ThePharaoh.this.tickLeap(this.target);
            } else if (ThePharaoh.this.goalTick > 0) {
                ThePharaoh.this.tickLeapEnd();
            } else {
                this.done = true;
            }
        }
    }

    private class RandomlyTeleportAttackGoal
    extends Goal {
        private static final int WHACK_TICKS = TimeUtils.secondsToTicks(1.5f);
        @Nullable
        private ServerPlayer target;

        private RandomlyTeleportAttackGoal() {
        }

        public boolean m_8036_() {
            if (ThePharaoh.this.getEntityState() != Phase.IDLE || !ThePharaoh.this.randomCheck(100)) {
                return false;
            }
            this.findNewTarget();
            return this.target != null;
        }

        public boolean m_8045_() {
            return this.target != null && this.target.m_6084_();
        }

        public void m_8056_() {
            ThePharaoh.this.setEntityState(Phase.WHACK);
            ThePharaoh.this.goalTick = 0;
            if (this.target == null) {
                return;
            }
            EntityUtils.teleportToTarget((LivingEntity)ThePharaoh.this, (LivingEntity)this.target, 5, false);
        }

        public void m_8041_() {
            ThePharaoh.this.setEntityState(Phase.IDLE);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (ThePharaoh.this.goalTick >= WHACK_TICKS) {
                this.target = null;
                return;
            }
            if (ThePharaoh.this.goalTick == WHACK_TICKS / 2) {
                this.swing();
            }
            ++ThePharaoh.this.goalTick;
        }

        private void findNewTarget() {
            this.target = null;
            List<ServerPlayer> players = ThePharaoh.this.getPlayersSortedByDistance((ServerLevel)ThePharaoh.this.m_9236_());
            for (int idx = players.size() - 1; idx >= 0; --idx) {
                ServerPlayer playerToCheck = players.get(idx);
                if (!this.isTooFarFromFriendlies(players.get(idx))) continue;
                this.target = playerToCheck;
                return;
            }
        }

        private boolean isTooFarFromFriendlies(ServerPlayer player) {
            ServerLevel level = (ServerLevel)ThePharaoh.this.m_9236_();
            if (ThePharaoh.this.getFriendlies(level).isEmpty()) {
                return false;
            }
            return ThePharaoh.this.getFriendlies(level).stream().allMatch(friendly -> this.isTooFarFrom(player, (Mob)friendly));
        }

        private boolean isTooFarFrom(ServerPlayer player, Mob friendly) {
            double threshold = 2.0 * friendly.m_21133_(Attributes.f_22277_);
            return (double)friendly.m_20270_((Entity)player) > threshold;
        }

        private void swing() {
            if (this.target == null) {
                return;
            }
            EntityUtils.legacyRaytraceEntitiesInView((LivingEntity)ThePharaoh.this, 2.0).stream().filter(e -> e instanceof ServerPlayer).map(e -> (ServerPlayer)e).forEach(arg_0 -> ((ThePharaoh)ThePharaoh.this).m_7327_(arg_0));
        }
    }

    public static enum Phase implements GahEntityState,
    GahAnimationState
    {
        IDLE(IDLE_ANIMATION),
        LEAP_START(LEAP_START_ANIMATION),
        LEAP(LEAP_ANIMATION),
        LEAP_END(LEAP_END_ANIMATION),
        REFLECT(REFLECT_ANIMATION),
        WHACK(WHACK_ANIMATION),
        STRIKE_DOWN_START(STRIKE_DOWN_START_ANIMATION),
        STRIKE_DOWN(STRIKE_DOWN_ANIMATION),
        STRIKE_DOWN_END(STRIKE_DOWN_END_ANIMATION);

        private final RawAnimation animation;

        private Phase(RawAnimation animation) {
            this.animation = animation;
        }

        @Override
        public RawAnimation animation() {
            return this.animation;
        }

        @Override
        public int value() {
            return this.ordinal();
        }
    }

    private class StrikeDownGoal
    extends Goal {
        private static final int STRIKE_DOWN_START_TICKS = TimeUtils.secondsToTicks(1.5f);
        private static final int STRIKE_DOWN_END_TICKS = TimeUtils.secondsToTicks(1.5f);
        private static final int STRIKE_DOWN_TICKS = TimeUtils.secondsToTicks(15.0f);
        float lastCheckedHealth;
        float damageTaken;
        float nextStrikeDownHealth;
        boolean running;

        public StrikeDownGoal() {
            this.nextStrikeDownHealth = ThePharaoh.this.m_21233_();
            this.calculateNextHealth();
            this.running = false;
        }

        public boolean m_8036_() {
            if (ThePharaoh.this.getEntityState() == Phase.IDLE && ThePharaoh.this.m_21223_() <= this.nextStrikeDownHealth && ThePharaoh.this.randomCheck(20)) {
                ThePharaoh.this.setEntityState(Phase.STRIKE_DOWN_START);
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return this.running;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8056_() {
            if (ThePharaoh.this.firstTickPos != null) {
                ThePharaoh.this.m_20219_(WorldUtils.toVec3(ThePharaoh.this.firstTickPos));
            }
            ThePharaoh.this.goalTick = 0;
            this.lastCheckedHealth = ThePharaoh.this.m_21223_();
            this.damageTaken = 0.0f;
            this.running = true;
        }

        public void m_8041_() {
            ThePharaoh.this.removeDeadFriendlies((ServerLevel)ThePharaoh.this.m_9236_());
            ThePharaoh.this.setEntityState(Phase.IDLE);
            this.calculateNextHealth();
        }

        public void m_8037_() {
            if (!this.running) {
                return;
            }
            if (ThePharaoh.this.getEntityState() == Phase.STRIKE_DOWN_START) {
                this.tickStart();
                return;
            }
            if (ThePharaoh.this.getEntityState() == Phase.STRIKE_DOWN_END) {
                this.tickEnd();
                return;
            }
            if (ThePharaoh.this.goalTick >= STRIKE_DOWN_TICKS) {
                ThePharaoh.this.setEntityState(Phase.STRIKE_DOWN_END);
                ThePharaoh.this.goalTick = 0;
                ThePharaoh.this.getPlayers((ServerLevel)ThePharaoh.this.m_9236_()).forEach(this::strikeDown);
                return;
            }
            this.damageTaken += this.lastCheckedHealth - ThePharaoh.this.m_21223_();
            this.lastCheckedHealth = ThePharaoh.this.m_21223_();
            if (this.damageTaken > ThePharaoh.this.m_21233_() / 25.0f) {
                ThePharaoh.this.setEntityState(Phase.STRIKE_DOWN_END);
                ThePharaoh.this.goalTick = 0;
            }
            ++ThePharaoh.this.goalTick;
        }

        private void tickStart() {
            if (ThePharaoh.this.goalTick >= STRIKE_DOWN_START_TICKS) {
                ThePharaoh.this.setEntityState(Phase.STRIKE_DOWN);
                ThePharaoh.this.goalTick = 0;
                return;
            }
            ++ThePharaoh.this.goalTick;
        }

        private void tickEnd() {
            if (ThePharaoh.this.goalTick >= STRIKE_DOWN_END_TICKS) {
                ThePharaoh.this.goalTick = 0;
                this.running = false;
                return;
            }
            ++ThePharaoh.this.goalTick;
        }

        private void calculateNextHealth() {
            this.nextStrikeDownHealth = Math.max(0.0f, this.nextStrikeDownHealth - ThePharaoh.this.m_21233_() / 3.0f);
        }

        private void strikeDown(ServerPlayer player) {
            GahLightningBolt bolt = new GahLightningBolt((LivingEntity)ThePharaoh.this, ThePharaoh.this.m_9236_());
            bolt.setTarget((Entity)player);
            ThePharaoh.this.m_9236_().m_7967_((Entity)bolt);
        }
    }

    private class ThePharaohSpawnFriendliesGoal
    extends SpawnFriendliesGoal {
        private static final int TOTAL_COOLDOWN_TICKS = TimeUtils.secondsToTicks(3.0f);
        private int cooldownTicks;

        public ThePharaohSpawnFriendliesGoal() {
            super(ThePharaoh.this, false);
            this.cooldownTicks = 0;
        }

        public boolean m_8036_() {
            if (this.cooldownTicks < TOTAL_COOLDOWN_TICKS) {
                ++this.cooldownTicks;
                return false;
            }
            if (!ThePharaoh.this.randomCheck(50)) {
                return false;
            }
            ServerLevel level = (ServerLevel)ThePharaoh.this.m_9236_();
            ThePharaoh.this.getFriendlies(level).stream().filter(e -> !e.m_6084_()).forEach(ThePharaoh.this::removeFriendly);
            return ThePharaoh.this.getFriendlies(level).size() < ThePharaoh.this.getPlayers(level).size() * 2;
        }

        @Override
        public void m_8041_() {
            this.cooldownTicks = 0;
        }

        @Override
        protected int getSpawnCount() {
            return 1;
        }

        @Override
        protected Optional<? extends Monster> createFriendly(int spawnNumber) {
            int nextFriendly = ThePharaoh.this.m_217043_().m_188503_(10);
            Vec3 locationToSpawn = this.nextLocation();
            Optional<? extends Monster> newFriendly = nextFriendly <= 5 ? this.tryCreateFriendly((EntityType<? extends Monster>)((EntityType)LivingEntityRegistry.DESERT_CREEPER.get()), locationToSpawn) : (nextFriendly <= 8 ? this.tryCreateFriendly((EntityType<? extends Monster>)((EntityType)LivingEntityRegistry.SCORPION.get()), locationToSpawn) : this.tryCreateFriendly((EntityType<? extends Monster>)((EntityType)LivingEntityRegistry.SPHINX.get()), locationToSpawn));
            return newFriendly;
        }

        private Vec3 nextLocation() {
            ServerPlayer playerToSpawnAt;
            List<ServerPlayer> players = ThePharaoh.this.getPlayersSortedByDistance((ServerLevel)ThePharaoh.this.m_9236_());
            int random = ThePharaoh.this.m_217043_().m_188503_(10);
            if (random <= 5) {
                playerToSpawnAt = players.get(players.size() - 1);
            } else if (random <= 8) {
                if (players.size() <= 2) {
                    playerToSpawnAt = players.get(players.size() - 1);
                } else if (players.size() == 3) {
                    playerToSpawnAt = players.get(2);
                } else {
                    int midRand = ThePharaoh.this.m_217043_().m_188503_(players.size() - 3);
                    playerToSpawnAt = players.get(1 + midRand);
                }
            } else {
                playerToSpawnAt = players.get(0);
            }
            Function<Double, Double> randomCoordinateNear = coordinate -> coordinate + (double)(ThePharaoh.this.m_217043_().m_216339_(1, 4) * (ThePharaoh.this.randomCheck(1) ? 1 : -1));
            return new Vec3(randomCoordinateNear.apply(playerToSpawnAt.m_20185_()).doubleValue(), playerToSpawnAt.m_20186_(), randomCoordinateNear.apply(playerToSpawnAt.m_20189_()).doubleValue());
        }
    }
}

