/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living.boss.ai;

import com.dee12452.gahoodrpg.common.entities.living.boss.GahBossBase;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public abstract class SpawnFriendliesGoal
extends Goal {
    private final GahBossBase<?, ?> boss;
    private final boolean clearFriendliesOnStop;

    public SpawnFriendliesGoal(GahBossBase<?, ?> boss, boolean clearFriendliesOnStop) {
        this.boss = boss;
        this.clearFriendliesOnStop = clearFriendliesOnStop;
    }

    public void m_8056_() {
        super.m_8056_();
        for (int spawnNumber = 0; spawnNumber < this.getSpawnCount(); ++spawnNumber) {
            Optional<? extends Monster> friendlyMonster = this.createFriendly(spawnNumber);
            friendlyMonster.ifPresent(this.boss::addFriendly);
        }
    }

    public void m_8041_() {
        super.m_8041_();
        if (this.clearFriendliesOnStop) {
            this.boss.clearFriendlies((ServerLevel)this.boss.m_9236_());
        }
    }

    protected Optional<? extends Monster> tryCreateFriendly(EntityType<? extends Monster> friendlyType, Vec3 location) {
        BlockPos pos = new BlockPos((int)location.f_82479_, (int)location.f_82480_, (int)location.f_82481_);
        Level level = this.boss.m_9236_();
        double y = location.f_82480_;
        double maxY = y + 15.0;
        while (WorldUtils.isNotAir(level, pos) && y < maxY) {
            pos = new BlockPos((int)location.f_82479_, (int)(y += 1.0), (int)location.f_82481_);
        }
        if (WorldUtils.isNotAir(level, pos)) {
            return Optional.empty();
        }
        Monster monster = (Monster)friendlyType.m_262496_((ServerLevel)this.boss.m_9236_(), pos, MobSpawnType.MOB_SUMMONED);
        if (monster == null) {
            return Optional.empty();
        }
        level.m_7967_((Entity)monster);
        return Optional.of(monster);
    }

    protected abstract int getSpawnCount();

    protected abstract Optional<? extends Monster> createFriendly(int var1);
}

