/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living.boss.druid;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.living.boss.GahBossBase;
import com.dee12452.gahoodrpg.common.entities.living.boss.druid.ai.PlantChomplantGoal;
import com.dee12452.gahoodrpg.common.entities.living.boss.druid.ai.ShootPoisonShotsGoal;
import com.dee12452.gahoodrpg.common.entities.living.boss.druid.ai.ShootRootingVineGoal;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class TheDruid
extends GahBossBase<DruidState, DruidAnimationState> {
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.druid.idle");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.druid.walk");
    private static final RawAnimation PLANT_ANIMATION = RawAnimation.begin().thenLoop("animation.druid.plant");
    private static final RawAnimation SHOOT_ANIMATION = RawAnimation.begin().thenLoop("animation.druid.shoot");

    public TheDruid(EntityType<? extends GahBossBase> entityType, Level level) {
        super(entityType, level);
    }

    public Optional<BlockPos> generateRandomPositionFrom(Vec3 startPosition, double range) {
        Level level = this.m_9236_();
        for (int times = 0; times < 5; ++times) {
            double randomAngle = this.m_217043_().m_188500_() * 2.0 * Math.PI;
            double randomX = Math.cos(randomAngle);
            double randomY = Math.sin(randomAngle);
            Vec3 randomDirection = new Vec3(randomX, 0.0, randomY).m_82541_();
            Vec3 newPosVec3 = startPosition.m_82549_(randomDirection.m_82490_(range));
            BlockPos newPos = new BlockPos((int)newPosVec3.f_82479_, (int)startPosition.f_82480_, (int)newPosVec3.f_82481_);
            BlockState newPosState = level.m_8055_(newPos);
            BlockState newPosBelowState = level.m_8055_(newPos.m_7495_());
            if (!newPosState.m_60795_() || newPosBelowState.m_60795_()) continue;
            return Optional.of(newPos);
        }
        return Optional.empty();
    }

    @Override
    protected DruidAnimationState valueToAnimationState(int value) {
        return DruidAnimationState.values()[value];
    }

    @Override
    protected DruidState valueToEntityState(int value) {
        return DruidState.values()[value];
    }

    @Override
    @Nullable
    protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
        return ((DruidAnimationState)this.getAnimationState()).animation;
    }

    @Override
    @Nullable
    protected SoundEvent getBossMusic() {
        return (SoundEvent)Sounds.BOSS_MUSIC.get();
    }

    @Override
    protected boolean m_6125_() {
        return false;
    }

    @Override
    protected void registerBossGoals(GoalSelector goals) {
        goals.m_25352_(1, (Goal)new PlantChomplantGoal(this));
        goals.m_25352_(2, (Goal)new ShootRootingVineGoal(this));
        goals.m_25352_(3, (Goal)new ShootPoisonShotsGoal(this));
    }

    public static enum DruidAnimationState implements GahAnimationState
    {
        IDLE(IDLE_ANIMATION, -1),
        WALK(WALK_ANIMATION, -1),
        PLANT(PLANT_ANIMATION, TimeUtils.secondsToTicks(1.0f)),
        SHOOT(SHOOT_ANIMATION, TimeUtils.secondsToTicks(1.0f));

        private final RawAnimation animation;
        private final int duration;

        private DruidAnimationState(RawAnimation animation, int duration) {
            this.animation = animation;
            this.duration = duration;
        }

        @Override
        public int value() {
            return this.ordinal();
        }

        @Override
        public RawAnimation animation() {
            return this.animation;
        }

        @Override
        public int duration() {
            return this.duration;
        }
    }

    public static enum DruidState implements GahEntityState
    {
        IDLE,
        PLANT,
        SHOOT;


        @Override
        public int value() {
            return this.ordinal();
        }
    }
}

