/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living.boss.druid.ai;

import com.dee12452.gahoodrpg.common.entities.living.Chomplant;
import com.dee12452.gahoodrpg.common.entities.living.ai.CooldownGoal;
import com.dee12452.gahoodrpg.common.entities.living.boss.druid.TheDruid;
import com.dee12452.gahoodrpg.common.registries.LivingEntityRegistry;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PlantChomplantGoal
extends CooldownGoal {
    private static final double CHOMPLANT_PLANT_RANGE = 5.0;
    private final TheDruid boss;
    private final LinkedList<BlockPos> chomplantPositions;
    @Nullable
    private Path path;
    private int pathTicks = 0;
    private int plantTicks = 0;
    private GoalState state = GoalState.IDLE;

    public PlantChomplantGoal(TheDruid boss) {
        super(TimeUtils.secondsToTicks(5.0f));
        this.boss = boss;
        this.chomplantPositions = new LinkedList();
    }

    @Override
    public boolean m_8036_() {
        int randomRoll = this.boss.getHealthPercent() < 0.5f ? 10 : 30;
        ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{super.m_8036_(), this.boss.getEntityState() == TheDruid.DruidState.IDLE, this.boss.rollRandom(randomRoll)});
        if (checks.stream().allMatch(check -> check)) {
            this.boss.setEntityState(TheDruid.DruidState.PLANT);
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.state != GoalState.IDLE;
    }

    public void m_8056_() {
        super.m_8056_();
        this.pathTicks = 0;
        this.queueChomplantPositions();
        this.state = GoalState.WALK;
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.boss.setEntityState(TheDruid.DruidState.IDLE);
        this.boss.setAnimationState(TheDruid.DruidAnimationState.IDLE);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        super.m_8037_();
        switch (this.state) {
            case PLANT: {
                this.tickPlant();
                break;
            }
            case WALK: {
                this.tickPath();
                break;
            }
        }
    }

    private void tickPath() {
        while (this.path == null) {
            if (this.chomplantPositions.isEmpty()) {
                this.state = GoalState.IDLE;
                return;
            }
            BlockPos nextPosition = this.chomplantPositions.poll();
            if (nextPosition == null) {
                this.state = GoalState.IDLE;
                return;
            }
            this.path = this.boss.m_21573_().m_7864_(nextPosition, 1);
        }
        this.boss.setAnimationState(TheDruid.DruidAnimationState.WALK);
        if (this.pathTicks % 2 == 0 && (!this.boss.m_21573_().m_26536_(this.path, 1.0) || this.path.m_77392_())) {
            this.path = null;
            this.plantChomplant();
        }
        ++this.pathTicks;
    }

    private void queueChomplantPositions() {
        int numPlants = this.boss.getPlayers((ServerLevel)this.boss.m_9236_()).size();
        float healthPercent = this.boss.getHealthPercent();
        if (healthPercent < 0.5f) {
            ++numPlants;
        }
        Vec3 nextPosition = this.boss.m_20318_(1.0f);
        for (int times = 0; times < numPlants; ++times) {
            Optional<BlockPos> nextPos = this.boss.generateRandomPositionFrom(nextPosition, 5.0);
            if (!nextPos.isPresent()) continue;
            BlockPos pos = nextPos.get();
            this.chomplantPositions.offer(pos);
            nextPosition = pos.m_252807_();
        }
    }

    private void tickPlant() {
        this.boss.setAnimationState(TheDruid.DruidAnimationState.PLANT);
        if (this.plantTicks <= TheDruid.DruidAnimationState.PLANT.duration()) {
            ++this.plantTicks;
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.boss.m_9236_();
        Chomplant nextChomplant = (Chomplant)((EntityType)LivingEntityRegistry.CHOMPLANT.get()).m_262496_(serverLevel, this.boss.m_20097_().m_7494_(), MobSpawnType.MOB_SUMMONED);
        if (nextChomplant != null) {
            serverLevel.m_7967_((Entity)nextChomplant);
        }
        this.state = GoalState.WALK;
        this.pathTicks = 0;
    }

    private void plantChomplant() {
        this.state = GoalState.PLANT;
        this.plantTicks = 0;
    }

    private static enum GoalState {
        IDLE,
        WALK,
        PLANT;

    }
}

