/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living.boss.druid.ai;

import com.dee12452.gahoodrpg.common.entities.living.ai.CooldownGoal;
import com.dee12452.gahoodrpg.common.entities.living.boss.druid.TheDruid;
import com.dee12452.gahoodrpg.common.entities.projectile.PoisonShot;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class ShootPoisonShotsGoal
extends CooldownGoal {
    private static final int TICK_DURATION_BETWEEN_ATTACKS = TimeUtils.secondsToTicks(1.0f);
    private final TheDruid boss;
    private int rounds;
    private int ticks;
    private int ticksBetweenAttacks;

    public ShootPoisonShotsGoal(TheDruid boss) {
        super(TimeUtils.secondsToTicks(3.0f));
        this.boss = boss;
    }

    @Override
    public boolean m_8036_() {
        int randomRoll = this.boss.getHealthPercent() > 0.5f ? 10 : 20;
        ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{super.m_8036_(), this.boss.getEntityState() == TheDruid.DruidState.IDLE, this.boss.rollRandom(randomRoll)});
        if (checks.stream().allMatch(c -> c)) {
            this.boss.setEntityState(TheDruid.DruidState.SHOOT);
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.boss.getEntityState() == TheDruid.DruidState.SHOOT;
    }

    public void m_8056_() {
        super.m_8056_();
        this.rounds = this.boss.getHealthPercent() > 0.5f ? 3 : 4;
        this.ticks = 0;
        this.ticksBetweenAttacks = this.boss.getHealthPercent() > 0.5f ? TICK_DURATION_BETWEEN_ATTACKS : TICK_DURATION_BETWEEN_ATTACKS / 2;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.rounds <= 0) {
            this.boss.setEntityState(TheDruid.DruidState.IDLE);
            return;
        }
        if (this.ticks % this.ticksBetweenAttacks == 0) {
            this.boss.setAnimationState(TheDruid.DruidAnimationState.SHOOT);
            --this.rounds;
            this.shootRound();
        }
        ++this.ticks;
    }

    private void shootRound() {
        float skew = this.rounds % 2 == 0 ? 0.0f : 45.0f;
        for (int times = 0; times < 4; ++times) {
            PoisonShot projectile = new PoisonShot((LivingEntity)this.boss);
            projectile.m_6034_(this.boss.m_20185_(), (this.boss.m_20186_() + this.boss.m_20188_()) / 2.0, this.boss.m_20189_());
            float speed = (float)this.boss.m_21133_(Attributes.f_22279_) * 2.0f;
            projectile.m_37251_((Entity)this.boss, 0.0f, (float)(times * 90) + skew, 0.0f, speed, 0.0f);
            this.boss.m_9236_().m_7967_((Entity)projectile);
        }
    }
}

