/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.living.boss.druid.ai;

import com.dee12452.gahoodrpg.common.entities.living.ai.CooldownGoal;
import com.dee12452.gahoodrpg.common.entities.living.boss.druid.TheDruid;
import com.dee12452.gahoodrpg.common.entities.projectile.RootingVine;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class ShootRootingVineGoal
extends CooldownGoal {
    private final TheDruid boss;
    @Nullable
    private Path path;
    private int ticks;

    public ShootRootingVineGoal(TheDruid boss) {
        super(TimeUtils.secondsToTicks(1.5f), true);
        this.boss = boss;
    }

    @Override
    public boolean m_8036_() {
        ArrayList checks = Lists.newArrayList((Object[])new Boolean[]{super.m_8036_(), this.boss.getEntityState() == TheDruid.DruidState.IDLE, this.boss.rollRandom(15)});
        if (checks.stream().allMatch(check -> check)) {
            this.boss.setEntityState(TheDruid.DruidState.SHOOT);
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.boss.getEntityState() == TheDruid.DruidState.SHOOT;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        super.m_8056_();
        this.ticks = 0;
        this.findTarget();
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.shootProjectile();
        this.boss.m_6710_(null);
        this.path = null;
        this.boss.setAnimationState(TheDruid.DruidAnimationState.IDLE);
        this.boss.setEntityState(TheDruid.DruidState.IDLE);
    }

    public void m_8037_() {
        super.m_8037_();
        LivingEntity target = this.boss.m_5448_();
        if (target == null || this.path == null) {
            this.boss.setEntityState(TheDruid.DruidState.IDLE);
            return;
        }
        this.boss.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        this.boss.m_21573_().m_26536_(this.path, 0.25);
        this.boss.setAnimationState(TheDruid.DruidAnimationState.SHOOT);
        if (this.ticks > TheDruid.DruidAnimationState.SHOOT.duration()) {
            this.boss.setEntityState(TheDruid.DruidState.IDLE);
            return;
        }
        if (this.ticks % 3 == 0 || this.path.m_77392_()) {
            this.updatePath(target);
        }
        ++this.ticks;
    }

    private void findTarget() {
        Optional closestPlayer = this.boss.getPlayersSortedByDistance((ServerLevel)this.boss.m_9236_()).stream().findFirst();
        if (closestPlayer.isEmpty()) {
            return;
        }
        this.boss.m_6710_((LivingEntity)closestPlayer.get());
        this.updatePath((LivingEntity)closestPlayer.get());
    }

    private void updatePath(LivingEntity target) {
        this.path = this.boss.m_21573_().m_6570_((Entity)target, 1);
    }

    private void shootProjectile() {
        LivingEntity target = this.boss.m_5448_();
        if (target == null) {
            return;
        }
        RootingVine projectile = new RootingVine((LivingEntity)this.boss);
        projectile.m_6034_(this.boss.m_20185_(), (this.boss.m_20186_() + this.boss.m_20188_()) / 2.0, this.boss.m_20189_());
        float speed = (float)this.boss.m_21133_(Attributes.f_22279_) * 2.0f;
        if (this.boss.getHealthPercent() < 0.5f) {
            speed *= 1.15f;
        }
        projectile.shootDirectlyAtEntity(target, speed);
        this.boss.m_9236_().m_7967_((Entity)projectile);
    }
}

