/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.entities.projectile.GahProjectileBase;
import com.dee12452.gahoodrpg.common.entities.projectile.GuardianShield;
import com.dee12452.gahoodrpg.common.items.weapons.GahShieldItem;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientMagicExplosion;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CrashGuardShield
extends GuardianShield {
    private boolean crashed = false;

    public CrashGuardShield(EntityType<? extends GahProjectileBase<GuardianShield.State, GuardianShield.AnimationState>> entityType, Level level) {
        super(entityType, level);
    }

    public CrashGuardShield(LivingEntity owner, Vec3 position, float yRot, int ticksToLive) {
        super((EntityType<? extends GahProjectileBase<GuardianShield.State, GuardianShield.AnimationState>>)((EntityType)ProjectileEntityRegistry.CRASH_GUARD_SHIELD.get()), owner.m_9236_());
        this.m_146884_(position);
        this.m_5602_((Entity)owner);
        this.setProjectileYRot(-owner.m_6080_() + yRot);
        this.setTicksToLive(ticksToLive);
        Item item = owner.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        if (item instanceof GahShieldItem) {
            GahShieldItem shieldItem = (GahShieldItem)item;
            this.setItem(shieldItem);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_146926_(0.0f);
        this.m_146922_(this.getProjectileYRot());
        if (this.crashed) {
            this.m_20256_(Vec3.f_82478_);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82400_(2.0), e -> {
                if (!(e instanceof Projectile)) return false;
                Projectile p = (Projectile)e;
                if (EntityUtils.is(this.m_19749_(), p.m_19749_())) return false;
                return true;
            }).forEach(Entity::m_146870_);
        }
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.crashed = nbt.m_128471_("crashed");
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("crashed", this.crashed);
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult result) {
    }

    @Override
    protected void m_8060_(@NotNull BlockHitResult result) {
        this.crashed = true;
        this.m_20256_(Vec3.f_82478_);
        Entity entity = this.m_19749_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        player.m_9236_().m_6249_((Entity)player, this.m_20191_().m_82400_(2.0), e -> e instanceof LivingEntity).forEach(e -> this.crashTarget(player, (LivingEntity)e));
        EntityUtils.playSound((LivingEntity)player, (SoundEvent)Sounds.GUARDIAN_CRASH_GUARD_SLAM.get());
        NetworkChannel.sendToClient(player, new ClientMagicExplosion.Message(this.m_20185_(), this.m_20186_(), this.m_20189_()));
    }

    private void crashTarget(ServerPlayer player, LivingEntity target) {
        this.hurtHitEntity((LivingEntity)player, target);
        Vec3 vec3 = EntityUtils.getAngleTo((LivingEntity)player, (Entity)target).m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(1.25);
        if (vec3.m_82556_() > 0.0) {
            target.m_5997_(vec3.f_82479_, 0.25, vec3.f_82481_);
        }
    }
}

