/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.blocks.BlockParticleEmitter;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.projectile.GahProjectileBase;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Fireball
extends GahProjectileBase<GahEntityState, GahAnimationState> {
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.fireball.idle");

    public Fireball(EntityType<? extends Fireball> entityType, Level level) {
        super(entityType, level);
    }

    public Fireball(LivingEntity owner) {
        super((EntityType)ProjectileEntityRegistry.FIREBALL.get(), owner);
    }

    @Override
    @Nullable
    protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
        return IDLE_ANIMATION;
    }

    @Override
    protected GahAnimationState valueToAnimationState(int value) {
        return GahAnimationState.EMPTY;
    }

    @Override
    protected GahEntityState valueToEntityState(int value) {
        return GahEntityState.EMPTY;
    }

    @Override
    protected void animate() {
        Vec3 location;
        if (this.f_19796_.m_188499_()) {
            location = new Vec3(0.0, 0.0, (double)this.f_19796_.m_188501_());
            location = this.f_19796_.m_188499_() ? this.m_20182_().m_82549_(location) : this.m_20182_().m_82546_(location);
            new BlockParticleEmitter(BlockParticleEmitter.dust("#ff3300"), this.m_9236_(), WorldUtils.toBlockPos(location)).addParticles(this.f_19796_);
        }
        if (this.f_19796_.m_188499_()) {
            location = new Vec3(0.0, 0.0, (double)this.f_19796_.m_188501_());
            location = this.f_19796_.m_188499_() ? this.m_20182_().m_82549_(location) : this.m_20182_().m_82546_(location);
            new BlockParticleEmitter(BlockParticleEmitter.dust("#ff6a00"), this.m_9236_(), WorldUtils.toBlockPos(location)).addParticles(this.f_19796_);
        }
        if (this.f_19796_.m_188499_()) {
            location = new Vec3(0.0, 0.0, (double)this.f_19796_.m_188501_());
            location = this.f_19796_.m_188499_() ? this.m_20182_().m_82549_(location) : this.m_20182_().m_82546_(location);
            new BlockParticleEmitter(BlockParticleEmitter.dust("#fcba03"), this.m_9236_(), WorldUtils.toBlockPos(location)).addParticles(this.f_19796_);
        }
    }
}

