/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.entities.IGahAnimatedEntity;
import com.dee12452.gahoodrpg.common.entities.living.PoisonousFrog;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FrogTongue
extends Projectile
implements IGahAnimatedEntity {
    private static final EntityDataAccessor<Float> YROT = SynchedEntityData.m_135353_(FrogTongue.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> XROT = SynchedEntityData.m_135353_(FrogTongue.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean dirty = false;
    @Nullable
    private PoisonousFrog frog;
    @Nullable
    private LivingEntity target;
    @Nullable
    private Consumer<Integer> onTongueBlockHit;
    private int tongueNumber = 0;

    public FrogTongue(EntityType<? extends FrogTongue> entityType, Level level) {
        super(entityType, level);
    }

    public FrogTongue(PoisonousFrog frog, @Nullable LivingEntity target, int tongueNumber, @Nullable Consumer<Integer> onTongueBlockHit) {
        super((EntityType)ProjectileEntityRegistry.FROG_TONGUE.get(), frog.m_9236_());
        this.frog = frog;
        this.target = target;
        this.onTongueBlockHit = onTongueBlockHit;
        this.tongueNumber = tongueNumber;
    }

    public void m_8119_() {
        if (this.dirty) {
            this.m_146870_();
        }
        super.m_8119_();
        if (this.frog != null && this.target != null) {
            this.moveToPosition(this.frog, this.target, this.tongueNumber);
        }
        if (this.isHittingBlock() && this.onTongueBlockHit != null) {
            this.onTongueBlockHit.accept(this.tongueNumber);
            return;
        }
        this.checkHitTarget();
    }

    @Override
    public void setSidedAnimationState(int state, boolean isClient) {
    }

    @Override
    public RawAnimation tickAnimation(AnimationState<GeoAnimatable> event) {
        return null;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isHittingBlock() {
        AABB boundingBox = this.m_20191_().m_165897_(0.0, 0.8, 0.8);
        Stream collidingBlockStates = this.m_9236_().m_45556_(boundingBox);
        return collidingBlockStates.anyMatch(BlockBehaviour.BlockStateBase::m_280296_);
    }

    public void moveToPosition(PoisonousFrog frog, LivingEntity target, int tongueNumber) {
        Vec3 frogPos = frog.m_20318_(1.0f).m_82492_(0.0, 0.1, 0.0);
        Vec3 targetPos = target.m_146892_().m_82492_(0.0, 1.0, 0.0);
        Vec3 lookVector = frogPos.m_82505_(targetPos).m_82541_();
        double offsetX = lookVector.f_82479_ * ((double)tongueNumber + 0.4);
        double offsetY = lookVector.f_82480_ * (double)tongueNumber;
        double offsetZ = lookVector.f_82481_ * ((double)tongueNumber + 0.4);
        Vec3 newPos = new Vec3(frogPos.f_82479_ + offsetX, frogPos.f_82480_ + offsetY, frogPos.f_82481_ + offsetZ);
        this.m_146884_(newPos);
        double d0 = Math.sqrt(lookVector.f_82479_ * lookVector.f_82479_ + lookVector.f_82481_ * lookVector.f_82481_);
        float yRot = (float)(Mth.m_14136_((double)lookVector.f_82481_, (double)lookVector.f_82479_) * 57.2957763671875) - 90.0f;
        float xRot = (float)(-(Mth.m_14136_((double)lookVector.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19804_.m_135381_(YROT, (Object)Float.valueOf(-yRot));
        this.f_19804_.m_135381_(XROT, (Object)Float.valueOf(-xRot));
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> p_20059_) {
        super.m_7350_(p_20059_);
        this.m_146926_(((Float)this.f_19804_.m_135370_(XROT)).floatValue());
        this.m_146922_(((Float)this.f_19804_.m_135370_(YROT)).floatValue());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(YROT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(XROT, (Object)Float.valueOf(0.0f));
    }

    protected void m_7378_(@NotNull CompoundTag p_37262_) {
        this.dirty = true;
    }

    private void checkHitTarget() {
        Optional<AABB> targetBoundingBox = Optional.ofNullable(this.target).map(Entity::m_20191_);
        if (targetBoundingBox.isEmpty()) {
            return;
        }
        if (!this.m_20191_().m_82381_(targetBoundingBox.get())) {
            return;
        }
        if (this.frog != null && this.target != null) {
            this.frog.m_7327_((Entity)this.target);
        }
    }
}

