/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.blocks.BlockParticleEmitter;
import com.dee12452.gahoodrpg.common.combat.GahDamageSource;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.projectile.GahProjectileBase;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class FrostBeam
extends GahProjectileBase<GahEntityState, GahAnimationState> {
    protected static final EntityDataAccessor<Boolean> MARKED_FOR_REMOVAL = SynchedEntityData.m_135353_(FrostBeam.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.frost_beam.idle");
    private static final int MAX_TICKS_TO_LIVE = TimeUtils.secondsToTicks(4.0f);
    private static final int MARK_DELAY_TICKS = 7;

    @Override
    @Nullable
    protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
        return IDLE_ANIMATION;
    }

    @Override
    protected GahAnimationState valueToAnimationState(int value) {
        return GahAnimationState.EMPTY;
    }

    @Override
    protected GahEntityState valueToEntityState(int value) {
        return GahEntityState.EMPTY;
    }

    public FrostBeam(EntityType<? extends GahProjectileBase<GahEntityState, GahAnimationState>> entityType, Level level) {
        super(entityType, level);
    }

    public FrostBeam(LivingEntity owner) {
        super((EntityType)ProjectileEntityRegistry.FROST_BEAM.get(), owner);
        this.setTicksToLive(MAX_TICKS_TO_LIVE);
    }

    public void markForRemoval() {
        this.setTicksToLive(this.getTicksAlive() + 7);
        this.f_19804_.m_135381_(MARKED_FOR_REMOVAL, (Object)true);
    }

    public boolean isMarkedForRemoval() {
        return (Boolean)this.f_19804_.m_135370_(MARKED_FOR_REMOVAL);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.moveToFrontOfPlayer();
    }

    @Override
    protected void checkForHit() {
        Entity entity;
        if (this.isMarkedForRemoval() || this.getTicksAlive() % 3 != 0 || !((entity = this.m_19749_()) instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        EntityUtils.raytraceEntitiesInView((LivingEntity)player, this.getScale()).stream().map(EntityHitResult::new).forEach(this::m_5790_);
    }

    public float getScale() {
        return (float)this.getTicksAlive() * 0.35f;
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult result) {
        Player player;
        Entity entity;
        block6: {
            block5: {
                entity = this.m_19749_();
                if (!(entity instanceof Player)) break block5;
                player = (Player)entity;
                entity = result.m_82443_();
                if (entity instanceof LivingEntity) break block6;
            }
            return;
        }
        LivingEntity target = (LivingEntity)entity;
        DamageSource source = GahDamageSource.indirect((Entity)player, (Entity)this);
        target.m_6469_(source, 2.0f);
        if (EntityUtils.isPvpEnabledEntity(target)) {
            return;
        }
        if (!target.m_21023_(MobEffects.f_19597_)) {
            target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5));
        }
    }

    @Override
    protected void m_8060_(@NotNull BlockHitResult result) {
    }

    private void moveToFrontOfPlayer() {
        Entity entity;
        if (this.isMarkedForRemoval() || !((entity = this.m_19749_()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        this.m_146922_(-player.m_146908_());
        this.m_146926_(90.0f + player.m_146909_());
        Vec3 eyePosition = player.m_20299_(1.0f);
        Vec3 lookVector = player.m_20252_(1.0f);
        double offsetX = lookVector.f_82479_ * 1.4;
        double offsetY = lookVector.f_82480_ - 0.75;
        double offsetZ = lookVector.f_82481_ * 1.4;
        this.m_6034_(eyePosition.f_82479_ + offsetX, eyePosition.f_82480_ + offsetY, eyePosition.f_82481_ + offsetZ);
    }

    @Override
    protected void animate() {
        Entity entity;
        if (this.isMarkedForRemoval() || !((entity = this.m_19749_()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        for (int times = 0; times < 5; ++times) {
            float randomScale = this.getScale() * this.f_19796_.m_188501_();
            Vec3 location = player.m_20154_().m_82490_((double)randomScale);
            new BlockParticleEmitter(BlockParticleEmitter.dust("#34ebcf"), this.m_9236_(), WorldUtils.toBlockPos(this.m_20182_().m_82549_(location))).addParticles(this.f_19796_, true);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MARKED_FOR_REMOVAL, (Object)false);
    }
}

