/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.client.GahoodRPGClient;
import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.blocks.BlockParticleEmitter;
import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.combat.GahDamageSource;
import com.dee12452.gahoodrpg.common.entities.IGahAnimatedEntity;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientSetProgressBar;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientStopSound;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class FrostBlast
extends Projectile
implements IGahAnimatedEntity {
    public static final int GUI_WIDTH = 100;
    public static final int GUI_HEIGHT = 10;
    public static final int TICK_DURATION = TimeUtils.secondsToTicks(4.0f);
    private static final ParticleOptions OPTIONS = BlockParticleEmitter.dust("#59fffc");
    private static final RawAnimation ANIMATION = RawAnimation.begin().thenLoop("animation.frost_blast");
    private static final EntityDataAccessor<Integer> BEAM_NUMBER = SynchedEntityData.m_135353_(FrostBlast.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int ticks = 0;

    public FrostBlast(EntityType<? extends FrostBlast> type, Level level) {
        super(type, level);
    }

    public FrostBlast(Player player, int beamNumber) {
        this((EntityType<? extends FrostBlast>)((EntityType)ProjectileEntityRegistry.FROST_BLAST.get()), player.m_9236_());
        this.f_19804_.m_135381_(BEAM_NUMBER, (Object)beamNumber);
        this.m_5602_((Entity)player);
        this.moveToFrontOfPlayer();
    }

    public void m_8119_() {
        Entity entity;
        super.m_8119_();
        this.findEntityHits().forEach(this::hitEntity);
        if (this.ticks >= TICK_DURATION || this.m_19749_() != null && ((LivingEntity)this.m_19749_()).m_21224_()) {
            this.die();
            return;
        }
        if (this.ticks % 2 == 0) {
            this.moveToFrontOfPlayer();
        }
        if ((entity = this.m_19749_()) instanceof LivingEntity) {
            LivingEntity owner = (LivingEntity)entity;
            if (this.ticks % 20 == 0) {
                new BlockParticleEmitter(OPTIONS, this.m_9236_(), this.m_20183_()).addParticles(owner.m_217043_());
            }
        }
        ++this.ticks;
    }

    public void die() {
        Entity entity = this.m_19749_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            NetworkChannel.sendToClient(player, new ClientSetProgressBar.Message(GahoodRPGClient.ProgressBarType.NONE));
            NetworkChannel.sendToClientsInLevel((ServerLevel)this.m_9236_(), new ClientStopSound.Message((SoundEvent)Sounds.MAGE_FROST_BEAM_CHARGE.get(), SoundSource.PLAYERS));
        }
        this.m_146870_();
    }

    @Override
    public void setSidedAnimationState(int state, boolean isClient) {
    }

    @Override
    public RawAnimation tickAnimation(AnimationState<GeoAnimatable> event) {
        return ANIMATION;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(BEAM_NUMBER, (Object)0);
    }

    protected void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("ticks", this.ticks);
    }

    protected void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.ticks = nbt.m_128451_("ticks");
    }

    protected void m_5790_(@NotNull EntityHitResult entityHitResult) {
    }

    private void moveToFrontOfPlayer() {
        Entity entity = this.m_19749_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        this.m_146922_(-player.m_146908_());
        this.m_146926_(90.0f + player.m_146909_());
        Vec3 eyePosition = player.m_20299_(1.0f);
        Vec3 lookVector = player.m_20252_(1.0f);
        int beamNumber = this.getBeamNumber();
        double offsetX = lookVector.f_82479_ * ((double)beamNumber + 0.4);
        double offsetY = lookVector.f_82480_ * (double)beamNumber - 1.0;
        double offsetZ = lookVector.f_82481_ * ((double)beamNumber + 0.4);
        this.m_6034_(eyePosition.f_82479_ + offsetX, eyePosition.f_82480_ + offsetY, eyePosition.f_82481_ + offsetZ);
    }

    private int getBeamNumber() {
        return (Integer)this.f_19804_.m_135370_(BEAM_NUMBER);
    }

    private List<LivingEntity> findEntityHits() {
        AABB collider = this.m_20191_().m_82377_(2.0, 2.0, 0.0);
        return this.m_9236_().m_6443_(LivingEntity.class, collider, this::isValidTarget);
    }

    private void hitEntity(LivingEntity livingEntity) {
        Entity entity = this.m_19749_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        DamageSource source = GahDamageSource.indirect((Entity)player, (Entity)this);
        livingEntity.m_6469_(source, 2.0f);
        if (livingEntity.m_21124_(MobEffects.f_19597_) == null) {
            livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5));
        }
    }

    private boolean isValidTarget(LivingEntity entity) {
        TamableAnimal animal;
        LivingEntity livingEntity;
        if (EntityUtils.is(this.m_19749_(), (Entity)entity)) {
            return false;
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer otherPlayer = (ServerPlayer)entity;
            return Capabilities.serverPlayer(otherPlayer).isPvpEnabled();
        }
        if (entity instanceof TamableAnimal && (livingEntity = (animal = (TamableAnimal)entity).m_269323_()) instanceof ServerPlayer) {
            ServerPlayer animalOwner = (ServerPlayer)livingEntity;
            return !EntityUtils.is(this.m_19749_(), (Entity)animalOwner) && Capabilities.serverPlayer(animalOwner).isPvpEnabled();
        }
        return true;
    }
}

