/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.combat.GahDamageSource;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GahLightningBolt
extends Entity {
    @Nullable
    private LivingEntity source;
    private int life = 2;
    private int flashes = 1;
    private long seed;

    public GahLightningBolt(EntityType<? extends GahLightningBolt> entityType, Level level) {
        super(entityType, level);
    }

    public GahLightningBolt(@Nullable LivingEntity source, Level level) {
        this((EntityType<? extends GahLightningBolt>)((EntityType)ProjectileEntityRegistry.GAH_LIGHTNING_BOLT.get()), level);
        this.source = source;
        this.seed = this.f_19796_.m_188505_();
    }

    public void setTarget(Entity entity) {
        this.setTargetBlock(entity.m_20097_());
    }

    public void setTargetBlock(BlockPos pos) {
        this.m_146884_(WorldUtils.getBlockPosCenter(pos));
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.life == 2) {
            if (this.m_9236_().m_5776_()) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12090_, SoundSource.WEATHER, 10000.0f, 0.8f + this.f_19796_.m_188501_() * 0.2f, false);
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12089_, SoundSource.WEATHER, 2.0f, 0.5f + this.f_19796_.m_188501_() * 0.2f, false);
            } else {
                this.m_146850_(GameEvent.f_157772_);
            }
        }
        --this.life;
        if (this.life < 0) {
            if (this.flashes == 0) {
                this.m_146870_();
            } else if (this.life < -this.f_19796_.m_188503_(10)) {
                --this.flashes;
                this.life = 1;
                this.seed = this.f_19796_.m_188505_();
            }
        }
        if (this.life >= 0) {
            if (!(this.m_9236_() instanceof ServerLevel)) {
                this.m_9236_().m_6580_(2);
            } else {
                List list1 = this.m_9236_().m_6249_((Entity)this, new AABB(this.m_20185_() - 3.0, this.m_20186_() - 3.0, this.m_20189_() - 3.0, this.m_20185_() + 3.0, this.m_20186_() + 6.0 + 3.0, this.m_20189_() + 3.0), entity -> entity.m_6084_() && !EntityUtils.is(entity, (Entity)this.source) && entity instanceof LivingEntity);
                for (Entity entity2 : list1) {
                    float baseDamage = 2.0f;
                    if (this.source == null) continue;
                    entity2.m_6469_(GahDamageSource.indirect((Entity)this.source, this), baseDamage);
                }
            }
        }
    }

    public long getSeed() {
        return this.seed;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(@NotNull CompoundTag nbt) {
        this.life = nbt.m_128451_("life");
        this.flashes = nbt.m_128451_("flashes");
        this.seed = nbt.m_128454_("seed");
        if (nbt.m_128441_("sourceId")) {
            this.source = (Player)this.m_9236_().m_6815_(nbt.m_128451_("sourceId"));
        }
    }

    protected void m_7380_(@NotNull CompoundTag nbt) {
        nbt.m_128405_("life", this.life);
        nbt.m_128405_("flashes", this.flashes);
        nbt.m_128356_("seed", this.seed);
        Optional.ofNullable(this.source).map(Entity::m_19879_).ifPresent(id -> nbt.m_128405_("sourceId", id.intValue()));
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }
}

