/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.combat.GahDamageSource;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TheEndGatewayBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class GahProjectileBase<S extends GahEntityState, A extends GahAnimationState>
extends Projectile
implements GeoEntity {
    protected static final EntityDataAccessor<Integer> ENTITY_STATE = SynchedEntityData.m_135353_(GahProjectileBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> ANIMATION_STATE = SynchedEntityData.m_135353_(GahProjectileBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Boolean> VANILLA_ROT_FLAG = SynchedEntityData.m_135353_(GahProjectileBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Float> Y_ROT = SynchedEntityData.m_135353_(GahProjectileBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> X_ROT = SynchedEntityData.m_135353_(GahProjectileBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> TICKS_TO_LIVE = SynchedEntityData.m_135353_(GahProjectileBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final float DEFAULT_GRAVITY = 0.03f;
    private int ticksAlive = 0;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GahProjectileBase(EntityType<? extends GahProjectileBase<S, A>> entityType, Level level) {
        super(entityType, level);
    }

    public GahProjectileBase(EntityType<? extends GahProjectileBase<S, A>> entityType, LivingEntity owner) {
        this(entityType, owner.m_9236_());
        this.m_6034_(owner.m_20185_(), owner.m_20188_(), owner.m_20189_());
        this.m_5602_((Entity)owner);
    }

    public int getTicksAlive() {
        return this.ticksAlive;
    }

    public void shootFromEntity(LivingEntity entity, float horizontalSpeed, float verticalSpeed) {
        this.m_37251_((Entity)entity, entity.m_146909_(), entity.m_146908_(), 0.0f, horizontalSpeed, verticalSpeed);
    }

    public void shootDirectlyAtEntity(LivingEntity target, float speed) {
        Entity owner = this.m_19749_();
        if (!(owner instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingOwner = (LivingEntity)owner;
        Pair<Float, Float> rotation = EntityUtils.getRotationTo(livingOwner, target);
        this.m_37251_((Entity)livingOwner, ((Float)rotation.getRight()).floatValue(), ((Float)rotation.getLeft()).floatValue(), 0.0f, speed, 0.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        this.checkForHit();
        this.m_20101_();
        this.checkMovement();
        this.tickAlive();
        if (this.m_9236_().m_5776_()) {
            this.animate();
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public A getAnimationState() {
        return this.valueToAnimationState((Integer)this.f_19804_.m_135370_(ANIMATION_STATE));
    }

    public void setAnimationState(A state) {
        this.f_19804_.m_135381_(ANIMATION_STATE, (Object)state.value());
    }

    public S getEntityState() {
        return this.valueToEntityState((Integer)this.f_19804_.m_135370_(ENTITY_STATE));
    }

    public void setEntityState(S state) {
        this.f_19804_.m_135381_(ENTITY_STATE, (Object)state.value());
    }

    public void setProjectileYRot(float yRot) {
        this.f_19804_.m_135381_(Y_ROT, (Object)Float.valueOf(yRot));
    }

    public float getProjectileYRot() {
        return ((Float)this.f_19804_.m_135370_(Y_ROT)).floatValue();
    }

    public void setProjectileXRot(float xRot) {
        this.f_19804_.m_135381_(X_ROT, (Object)Float.valueOf(xRot));
    }

    public float getProjectileXRot() {
        return ((Float)this.f_19804_.m_135370_(X_ROT)).floatValue();
    }

    protected void m_19915_(float yRot, float xRot) {
        if (this.isVanillaRotationDisabled()) {
            return;
        }
        super.m_19915_(yRot, xRot);
    }

    public void m_146922_(float yRot) {
        if (this.isVanillaRotationDisabled()) {
            return;
        }
        super.m_146922_(yRot);
    }

    public void m_146926_(float xRot) {
        if (this.isVanillaRotationDisabled()) {
            return;
        }
        super.m_146926_(xRot);
    }

    public float m_146908_() {
        if (this.isVanillaRotationDisabled()) {
            return ((Float)this.f_19804_.m_135370_(Y_ROT)).floatValue();
        }
        return super.m_146908_();
    }

    public float m_146909_() {
        if (this.isVanillaRotationDisabled()) {
            return ((Float)this.f_19804_.m_135370_(X_ROT)).floatValue();
        }
        return super.m_146909_();
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        super.m_7350_(accessor);
        this.checkAccessorSync(accessor, ANIMATION_STATE, animationState -> this.onAnimationStateUpdated(this.getAnimationState(), this.m_9236_().f_46443_));
        this.checkAccessorSync(accessor, ENTITY_STATE, animationState -> this.onMobStateUpdated(this.getEntityState(), this.m_9236_().f_46443_));
        this.checkAccessorSync(accessor, Y_ROT, x$0 -> super.m_146922_(x$0));
        this.checkAccessorSync(accessor, X_ROT, x$0 -> super.m_146926_(x$0));
    }

    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
        Entity hitEntity = result.m_82443_();
        Entity owner = this.m_19749_();
        if (owner instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)owner;
            if (hitEntity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)hitEntity;
                this.hurtHitEntity(livingOwner, target);
            }
        }
        Optional.ofNullable(this.getHitEntitySoundEffect()).ifPresent(arg_0 -> ((GahProjectileBase)this).m_216990_(arg_0));
        this.onDiscard(DiscardReason.ENTITY_HIT);
        this.m_146870_();
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        super.m_8060_(result);
        Optional.ofNullable(this.getHitBlockSoundEffect()).ifPresent(arg_0 -> ((GahProjectileBase)this).m_216990_(arg_0));
        this.onDiscard(DiscardReason.BLOCK_HIT);
        this.m_146870_();
    }

    protected void hurtHitEntity(LivingEntity owner, LivingEntity target) {
        if (EntityUtils.isClientSide((Entity)owner)) {
            return;
        }
        DamageSource damageSource = GahDamageSource.indirect((Entity)owner, (Entity)this);
        target.m_6469_(damageSource, 2.0f);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ANIMATION_STATE, (Object)0);
        this.f_19804_.m_135372_(ENTITY_STATE, (Object)0);
        this.f_19804_.m_135372_(VANILLA_ROT_FLAG, (Object)true);
        this.f_19804_.m_135372_(Y_ROT, (Object)Float.valueOf(super.m_146908_()));
        this.f_19804_.m_135372_(X_ROT, (Object)Float.valueOf(super.m_146909_()));
        this.f_19804_.m_135372_(TICKS_TO_LIVE, (Object)-1);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, this::handleAnimation)});
    }

    protected void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128379_("vanillaRotationDisabled", this.isVanillaRotationDisabled());
        nbt.m_128405_("entityState", this.getEntityState().value());
        nbt.m_128405_("animationState", this.getAnimationState().value());
        nbt.m_128405_("ticksAlive", this.ticksAlive);
        nbt.m_128405_("ticksToLive", this.getTicksToLive());
    }

    protected void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128471_("vanillaRotationDisabled")) {
            this.disableVanillaRotation();
        }
        this.setEntityState(this.valueToEntityState(nbt.m_128451_("entityState")));
        this.setAnimationState(this.valueToAnimationState(nbt.m_128451_("animationState")));
        this.ticksAlive = nbt.m_128451_("ticksAlive");
        this.setTicksToLive(nbt.m_128451_("ticksToLive"));
    }

    protected void disableVanillaRotation() {
        this.f_19804_.m_135381_(VANILLA_ROT_FLAG, (Object)false);
    }

    protected PlayState handleAnimation(AnimationState<GeoAnimatable> event) {
        if (this.resetAnimation()) {
            event.getController().forceAnimationReset();
        }
        return event.setAndContinue(this.getCurrentAnimation(event));
    }

    protected boolean resetAnimation() {
        return false;
    }

    protected void onAnimationStateUpdated(A newState, boolean isClientSide) {
    }

    protected void onMobStateUpdated(S newState, boolean isClientSide) {
    }

    protected boolean isVanillaRotationDisabled() {
        return (Boolean)this.f_19804_.m_135370_(VANILLA_ROT_FLAG) == false;
    }

    protected float getGravity() {
        return 0.03f;
    }

    @Nullable
    protected SoundEvent getHitEntitySoundEffect() {
        return null;
    }

    @Nullable
    protected SoundEvent getHitBlockSoundEffect() {
        return null;
    }

    @Nullable
    protected abstract RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> var1);

    protected abstract A valueToAnimationState(int var1);

    protected abstract S valueToEntityState(int var1);

    protected final int getTicksToLive() {
        return (Integer)this.f_19804_.m_135370_(TICKS_TO_LIVE);
    }

    protected final void setTicksToLive(int ttl) {
        this.f_19804_.m_135381_(TICKS_TO_LIVE, (Object)ttl);
    }

    protected void checkForHit() {
        HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        boolean flag = false;
        if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockHitResult)hitresult).m_82425_();
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (blockstate.m_60713_(Blocks.f_50142_)) {
                this.m_20221_(blockpos);
                flag = true;
            } else if (blockstate.m_60713_(Blocks.f_50446_)) {
                BlockEntity blockentity = this.m_9236_().m_7702_(blockpos);
                if (blockentity instanceof TheEndGatewayBlockEntity && TheEndGatewayBlockEntity.m_59940_((Entity)this)) {
                    TheEndGatewayBlockEntity.m_155828_((Level)this.m_9236_(), (BlockPos)blockpos, (BlockState)blockstate, (Entity)this, (TheEndGatewayBlockEntity)((TheEndGatewayBlockEntity)blockentity));
                }
                flag = true;
            }
        }
        if (hitresult.m_6662_() != HitResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
    }

    protected void onDiscard(DiscardReason reason) {
    }

    protected void animate() {
    }

    private void checkMovement() {
        Vec3 vec3 = this.m_20184_();
        double d2 = this.m_20185_() + vec3.f_82479_;
        double d0 = this.m_20186_() + vec3.f_82480_;
        double d1 = this.m_20189_() + vec3.f_82481_;
        if (!this.isVanillaRotationDisabled()) {
            this.m_37283_();
        }
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d2 - vec3.f_82479_ * 0.25, d0 - vec3.f_82480_ * 0.25, d1 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
        }
        if (this.getGravity() > 0.0f) {
            Vec3 vec31 = this.m_20184_();
            this.m_20334_(vec31.f_82479_, vec31.f_82480_ - (double)this.getGravity(), vec31.f_82481_);
        }
        this.m_6034_(d2, d0, d1);
    }

    private <T> void checkAccessorSync(EntityDataAccessor<?> accessorBeingSynced, EntityDataAccessor<T> accessorToCheck, Consumer<T> onSync) {
        if (accessorBeingSynced.equals(accessorToCheck)) {
            onSync.accept(this.f_19804_.m_135370_(accessorToCheck));
        }
    }

    private void tickAlive() {
        int maxTicksAlive = this.getTicksToLive();
        if (maxTicksAlive >= 0 && this.ticksAlive >= maxTicksAlive && !this.m_9236_().f_46443_) {
            this.onDiscard(DiscardReason.TIMEOUT);
            this.m_146870_();
            return;
        }
        ++this.ticksAlive;
    }

    protected static enum DiscardReason {
        TIMEOUT,
        ENTITY_HIT,
        BLOCK_HIT;

    }
}

