/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.combat.GahDamageSource;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Deprecated
public abstract class GahThrowableProjectileBase
extends ThrowableProjectile {
    private final double baseDamage;
    private final SoundEvent hitEnemyEvent;
    private final SoundEvent hitGroundSoundEvent;
    private int knockback;
    private float gravity;
    private int maxTicksAlive;
    private int ticksAlive;

    protected GahThrowableProjectileBase(EntityType<? extends GahThrowableProjectileBase> projectile, Level level) {
        super(projectile, level);
        this.baseDamage = 2.0;
        this.knockback = 0;
        this.hitEnemyEvent = SoundEvents.f_12515_;
        this.hitGroundSoundEvent = SoundEvents.f_12515_;
        this.gravity = 0.03f;
        this.maxTicksAlive = -1;
        this.ticksAlive = 0;
    }

    protected GahThrowableProjectileBase(EntityType<? extends GahThrowableProjectileBase> projectile, LivingEntity entity, Level level, double baseDamage, int knockback, float gravity, SoundEvent hitEnemyEvent, SoundEvent hitGroundSoundEvent) {
        this(projectile, entity, level, baseDamage, knockback, gravity, hitEnemyEvent, hitGroundSoundEvent, -1);
    }

    protected GahThrowableProjectileBase(EntityType<? extends GahThrowableProjectileBase> projectile, LivingEntity entity, Level level, double baseDamage, int knockback, float gravity, SoundEvent hitEnemyEvent, SoundEvent hitGroundSoundEvent, int maxTicksAlive) {
        super(projectile, entity, level);
        this.baseDamage = baseDamage;
        this.knockback = knockback;
        this.hitEnemyEvent = hitEnemyEvent;
        this.hitGroundSoundEvent = hitGroundSoundEvent;
        this.gravity = gravity;
        if (gravity <= 0.0f) {
            this.m_20242_(true);
        }
        this.maxTicksAlive = maxTicksAlive;
        this.ticksAlive = 0;
    }

    public void shootFromEntity(LivingEntity entity, float horizontalSpeed, float verticalSpeed) {
        this.m_37251_((Entity)entity, entity.m_146909_(), entity.m_146908_(), 0.0f, horizontalSpeed, verticalSpeed);
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.ticksAlive;
        if (this.maxTicksAlive != -1 && this.ticksAlive >= this.maxTicksAlive && !this.m_9236_().f_46443_) {
            this.onDiscard(DiscardReason.TIMEOUT);
        }
        if (this.m_9236_().m_5776_()) {
            this.animate();
        }
    }

    protected void animate() {
    }

    protected void m_8097_() {
    }

    protected void m_5790_(@NotNull EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        this.hurtAffectedEntity(entityHitResult.m_82443_());
        this.playHitEntitySound();
        this.onDiscard(DiscardReason.ENTITY_HIT);
    }

    protected void m_8060_(@NotNull BlockHitResult p_36755_) {
        super.m_8060_(p_36755_);
        Vec3 vec3 = p_36755_.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
        if (!this.m_9236_().f_46443_) {
            this.m_5496_(this.hitGroundSoundEvent, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            this.onDiscard(DiscardReason.BLOCK_HIT);
        }
    }

    protected float m_7139_() {
        return this.gravity;
    }

    protected void hurtAffectedEntity(Entity entity) {
        boolean hitEnderman;
        Entity owner = this.m_19749_();
        if (owner.m_9236_().f_46443_ || EntityUtils.is(owner, entity)) {
            return;
        }
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * this.baseDamage), (double)0.0, (double)2.147483647E9));
        DamageSource damageSource = GahDamageSource.indirect(owner, (Entity)this);
        boolean bl = hitEnderman = entity.m_6095_() == EntityType.f_20566_;
        if (entity.m_6469_(damageSource, (float)i) && !hitEnderman) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.knockback > 0) {
                    double d0 = Math.max(0.0, 1.0 - livingentity.m_21133_(Attributes.f_22278_));
                    Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.knockback * 0.6 * d0);
                    if (vec3.m_82556_() > 0.0) {
                        livingentity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                    }
                }
                if (!this.m_9236_().f_46443_ && owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingentity);
                }
            }
        } else if (!hitEnderman) {
            this.updateRotationOnHitEntity();
        }
    }

    protected void updateRotationOnHitEntity() {
        this.m_20256_(this.m_20184_().m_82490_(-0.1));
        this.m_146922_(this.m_146908_() + 180.0f);
        this.f_19859_ += 180.0f;
    }

    protected void playHitEntitySound() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.m_5496_(this.hitEnemyEvent, 1.0f, 1.0f);
    }

    protected void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("knockback", this.knockback);
        nbt.m_128350_("gravity", this.gravity);
        nbt.m_128405_("maxTicksAlive", this.maxTicksAlive);
        nbt.m_128405_("ticksAlive", this.ticksAlive);
    }

    protected void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.knockback = nbt.m_128451_("knockback");
        this.gravity = nbt.m_128457_("gravity");
        this.maxTicksAlive = nbt.m_128451_("maxTicksAlive");
        this.ticksAlive = nbt.m_128451_("ticksAlive");
    }

    protected void onDiscard(DiscardReason reason) {
        this.m_146870_();
    }

    public boolean m_20069_() {
        if (super.m_20069_() && this.m_9236_().f_46443_ && this.f_19796_.m_188503_(10) == 0) {
            Vec3 vec3 = this.m_20184_();
            double d2 = this.m_20185_() + vec3.f_82479_;
            double d0 = this.m_20186_() + vec3.f_82480_;
            double d1 = this.m_20189_() + vec3.f_82481_;
            for (int i = 0; i < 4; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, d2 - vec3.f_82479_ * 0.25, d0 - vec3.f_82480_ * 0.25, d1 - vec3.f_82481_ * 0.25, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            }
        }
        return false;
    }

    protected static enum DiscardReason {
        TIMEOUT,
        ENTITY_HIT,
        BLOCK_HIT;

    }
}

