/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.projectile.GahProjectileBase;
import com.dee12452.gahoodrpg.common.items.weapons.GahShieldItem;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.RawAnimation;

public class GuardianShield
extends GahProjectileBase<State, AnimationState> {
    protected static final EntityDataAccessor<Integer> SHIELD_ITEM_ID = SynchedEntityData.m_135353_(GuardianShield.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public GuardianShield(EntityType<? extends GahProjectileBase<State, AnimationState>> entityType, Level level) {
        super(entityType, level);
    }

    public GuardianShield(LivingEntity owner) {
        super((EntityType)ProjectileEntityRegistry.GUARDIAN_SHIELD.get(), owner);
    }

    public void setItem(GahShieldItem item) {
        this.f_19804_.m_135381_(SHIELD_ITEM_ID, (Object)Item.m_41393_((Item)item));
    }

    public Optional<GahShieldItem> getItem() {
        int shieldItemId = (Integer)this.f_19804_.m_135370_(SHIELD_ITEM_ID);
        if (shieldItemId < 0) {
            return Optional.empty();
        }
        return Optional.of((GahShieldItem)Item.m_41445_((int)shieldItemId));
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("shieldItemId", ((Integer)this.f_19804_.m_135370_(SHIELD_ITEM_ID)).intValue());
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(SHIELD_ITEM_ID, (Object)nbt.m_128451_("shieldItemId"));
    }

    @Override
    @Nullable
    protected RawAnimation getCurrentAnimation(software.bernie.geckolib.core.animation.AnimationState<GeoAnimatable> event) {
        return ((AnimationState)this.getAnimationState()).animation();
    }

    @Override
    protected AnimationState valueToAnimationState(int value) {
        return AnimationState.values()[value];
    }

    @Override
    protected State valueToEntityState(int value) {
        return State.values()[value];
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHIELD_ITEM_ID, (Object)-1);
    }

    public static enum AnimationState implements GahAnimationState
    {
        IDLE(RawAnimation.begin().thenPlay("animation.guardian_shield.idle")),
        SPIN(RawAnimation.begin().thenLoop("animation.guardian_shield.spin"));

        private final RawAnimation animation;

        private AnimationState(RawAnimation animation) {
            this.animation = animation;
        }

        @Override
        public int value() {
            return this.ordinal();
        }

        @Override
        public RawAnimation animation() {
            return this.animation;
        }
    }

    public static enum State implements GahEntityState
    {
        IDLE;


        @Override
        public int value() {
            return this.ordinal();
        }
    }
}

