/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.entities.projectile.GahThrowableProjectileBase;
import com.dee12452.gahoodrpg.common.network.NetworkChannel;
import com.dee12452.gahoodrpg.common.network.encoders.client.ClientMagicExplosion;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Meteor
extends GahThrowableProjectileBase {
    public Meteor(EntityType<? extends Meteor> type, Level level) {
        super(type, level);
    }

    public Meteor(Player player, Level level) {
        super((EntityType<? extends GahThrowableProjectileBase>)((EntityType)ProjectileEntityRegistry.METEOR.get()), (LivingEntity)player, level, 2.0, 0, (float)(3.5 * Math.pow(10.0, -2.0)), (SoundEvent)Sounds.MAGE_METEOR_HIT.get(), (SoundEvent)Sounds.MAGE_METEOR_HIT.get());
    }

    @Override
    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.hurtSurroundingEnemies(blockHitResult.m_82425_(), null);
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult entityHitResult) {
        super.m_5790_(entityHitResult);
        this.hurtSurroundingEnemies(entityHitResult.m_82443_().m_20097_(), e -> !EntityUtils.is(e, entityHitResult.m_82443_()));
    }

    private void hurtSurroundingEnemies(BlockPos blockPos, @Nullable Predicate<Entity> ignoreEntities) {
        AABB hurtBox = new AABB(blockPos).m_82400_(3.0);
        Stream<Object> entitiesToHurtStream = this.m_9236_().m_45933_(this.m_19749_(), hurtBox).stream();
        if (ignoreEntities != null) {
            entitiesToHurtStream = entitiesToHurtStream.filter(ignoreEntities);
        }
        entitiesToHurtStream.forEach(this::hurtAffectedEntity);
        if (!this.m_9236_().f_46443_) {
            NetworkChannel.sendToClientsInLevel((ServerLevel)this.m_9236_(), new ClientMagicExplosion.Message(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()));
        }
    }
}

