/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahDamageSource;
import com.dee12452.gahoodrpg.common.combat.effects.GahMagicPoisonEffect;
import com.dee12452.gahoodrpg.common.combat.effects.MobEffects;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.projectile.GahProjectileBase;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class PoisonShot
extends GahProjectileBase<PoisonShotState, PoisonShotAnimationState> {
    private static final RawAnimation ANIMATION = RawAnimation.begin().thenLoop("animation.poison_shot");

    public PoisonShot(EntityType<? extends GahProjectileBase<PoisonShotState, PoisonShotAnimationState>> entityType, Level level) {
        super(entityType, level);
        this.setEntityState(PoisonShotState.DEFAULT);
        this.setAnimationState(PoisonShotAnimationState.DEFAULT);
    }

    public PoisonShot(LivingEntity entity) {
        super((EntityType)ProjectileEntityRegistry.POISON_SHOT.get(), entity);
        this.setEntityState(PoisonShotState.DEFAULT);
        this.setAnimationState(PoisonShotAnimationState.DEFAULT);
    }

    @Override
    protected PoisonShotAnimationState valueToAnimationState(int value) {
        return PoisonShotAnimationState.values()[value];
    }

    @Override
    protected PoisonShotState valueToEntityState(int value) {
        return PoisonShotState.values()[value];
    }

    @Override
    @Nullable
    protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
        return ((PoisonShotAnimationState)this.getAnimationState()).animation();
    }

    @Override
    protected void hurtHitEntity(LivingEntity owner, LivingEntity target) {
        if (target.m_21023_((MobEffect)MobEffects.GAH_POISON.get())) {
            return;
        }
        GahCombat combat = GahCombat.entity((Entity)owner);
        GahDamage powerDamage = combat.calculatePowerDamage((Entity)target);
        GahDamage magicDamage = combat.calculateMagicDamage((Entity)target);
        int amount = Math.max(1, (int)magicDamage.magicDamage());
        MobEffectInstance effectInstance = new MobEffectInstance((MobEffect)MobEffects.GAH_POISON.get(), GahMagicPoisonEffect.DEFAULT_TICKS_ACTIVE, amount);
        target.m_7292_(effectInstance);
        target.m_6469_(GahDamageSource.direct((Entity)owner, (Entity)this, powerDamage), powerDamage.total() / 4.0f);
    }

    @Override
    protected float getGravity() {
        return 0.0f;
    }

    @Override
    @Nullable
    protected SoundEvent getHitEntitySoundEffect() {
        return (SoundEvent)Sounds.POISON_SHOT_HIT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getHitBlockSoundEffect() {
        return (SoundEvent)Sounds.POISON_SHOT_HIT.get();
    }

    protected static enum PoisonShotState implements GahEntityState
    {
        DEFAULT;


        @Override
        public int value() {
            return this.ordinal();
        }
    }

    protected static enum PoisonShotAnimationState implements GahAnimationState
    {
        DEFAULT(ANIMATION);

        private final RawAnimation animation;

        private PoisonShotAnimationState(RawAnimation animation) {
            this.animation = animation;
        }

        @Override
        public int value() {
            return this.ordinal();
        }

        @Override
        public RawAnimation animation() {
            return this.animation;
        }
    }
}

