/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.blocks.BlockParticleEmitter;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.projectile.GahProjectileBase;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class PowerSlash
extends GahProjectileBase<GahEntityState, GahAnimationState> {
    public static final int MAX_CHARGE_TIME = TimeUtils.secondsToTicks(3.0f);
    protected static final EntityDataAccessor<Float> SIZE = SynchedEntityData.m_135353_(PowerSlash.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);

    public PowerSlash(EntityType<? extends GahProjectileBase<GahEntityState, GahAnimationState>> entityType, Level level) {
        super(entityType, level);
    }

    public PowerSlash(LivingEntity owner) {
        super((EntityType)ProjectileEntityRegistry.POWER_SLASH.get(), owner);
    }

    public float getSize() {
        return Math.max(0.5f, ((Float)this.f_19804_.m_135370_(SIZE)).floatValue());
    }

    public void setSize(float size) {
        this.f_19804_.m_135381_(SIZE, (Object)Float.valueOf(size));
    }

    @NotNull
    protected AABB m_142242_() {
        AABB box = super.m_142242_();
        box = box.m_82386_(0.0, -1.0, 0.0);
        float size = this.getSize() * 2.0f;
        box = size < 1.0f ? box.m_82406_((double)Math.max(0.1f, 1.0f - size - 0.25f)) : box.m_82377_((double)(size / 4.0f), (double)(size / 3.0f), (double)0.1f);
        return box;
    }

    @Override
    @Nullable
    protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
        return null;
    }

    @Override
    protected GahAnimationState valueToAnimationState(int value) {
        return GahAnimationState.EMPTY;
    }

    @Override
    protected GahEntityState valueToEntityState(int value) {
        return GahEntityState.EMPTY;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE, (Object)Float.valueOf(0.5f));
        this.f_19804_.m_135381_(TICKS_TO_LIVE, (Object)TimeUtils.secondsToTicks(3.5f));
    }

    @Override
    protected void checkForHit() {
        Entity entity = this.m_19749_();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        AABB box = this.m_142242_();
        player.m_9236_().m_6249_((Entity)player, box, e -> e instanceof LivingEntity).forEach(e -> this.hurtHitEntity((LivingEntity)player, (LivingEntity)e));
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult result) {
        super.m_5790_(result);
    }

    @Override
    protected void m_8060_(@NotNull BlockHitResult result) {
        super.m_8060_(result);
    }

    @Override
    protected float getGravity() {
        return 0.0f;
    }

    @Override
    protected void animate() {
        Entity entity;
        Level level = this.m_9236_();
        if (this.f_19796_.m_188499_() || !((entity = this.m_19749_()) instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        float randomScale = this.getSize() * 2.0f * this.f_19796_.m_188501_();
        BlockPos pos = WorldUtils.toBlockPos(this.m_20182_().m_82549_(player.m_20154_().m_82490_((double)randomScale)));
        new BlockParticleEmitter((ParticleOptions)ParticleTypes.f_123766_, level, pos).addParticles(this.f_19796_, true);
    }
}

