/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.Sounds;
import com.dee12452.gahoodrpg.common.combat.effects.MobEffects;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.projectile.GahProjectileBase;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class RootingVine
extends GahProjectileBase<RootingVineState, RootingVineAnimationState> {
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.rooting_vine.idle");

    public RootingVine(EntityType<? extends GahProjectileBase<RootingVineState, RootingVineAnimationState>> entityType, Level level) {
        super(entityType, level);
    }

    public RootingVine(LivingEntity owner) {
        super((EntityType)ProjectileEntityRegistry.ROOTING_VINE.get(), owner);
    }

    @Override
    @Nullable
    protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
        return IDLE_ANIMATION;
    }

    @Override
    protected RootingVineAnimationState valueToAnimationState(int value) {
        return RootingVineAnimationState.IDLE;
    }

    @Override
    protected RootingVineState valueToEntityState(int value) {
        return RootingVineState.IDLE;
    }

    @Override
    protected void hurtHitEntity(LivingEntity owner, LivingEntity target) {
        super.hurtHitEntity(owner, target);
        target.m_7292_(new MobEffectInstance((MobEffect)MobEffects.ROOTED.get(), TimeUtils.secondsToTicks(3.0f)));
    }

    @Override
    @Nullable
    protected SoundEvent getHitEntitySoundEffect() {
        return (SoundEvent)Sounds.RANGER_ROOTING_VINE_HIT.get();
    }

    @Override
    @Nullable
    protected SoundEvent getHitBlockSoundEffect() {
        return (SoundEvent)Sounds.RANGER_ROOTING_VINE_HIT.get();
    }

    @Override
    protected float getGravity() {
        return 0.0f;
    }

    public static enum RootingVineAnimationState implements GahAnimationState
    {
        IDLE(IDLE_ANIMATION, TimeUtils.secondsToTicks(1.0f));

        private final RawAnimation animation;
        private final int duration;

        private RootingVineAnimationState(RawAnimation animation, int duration) {
            this.animation = animation;
            this.duration = duration;
        }

        @Override
        public int value() {
            return this.ordinal();
        }

        @Override
        public RawAnimation animation() {
            return this.animation;
        }

        @Override
        public int duration() {
            return this.duration;
        }
    }

    public static enum RootingVineState implements GahEntityState
    {
        IDLE;


        @Override
        public int value() {
            return this.ordinal();
        }
    }
}

