/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.projectile.GahProjectileBase;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.NbtUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class SentinelBeam
extends GahProjectileBase<GahEntityState, GahAnimationState> {
    private static final EntityDataAccessor<Float> SCALE_RATE = SynchedEntityData.m_135353_(SentinelBeam.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> PLAYER_TARGET = SynchedEntityData.m_135353_(SentinelBeam.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.sentinel_beam.idle");
    private float scaleY = 1.0f;

    public SentinelBeam(EntityType<? extends SentinelBeam> entityType, Level level) {
        super(entityType, level);
        this.disableVanillaRotation();
    }

    public SentinelBeam(LivingEntity owner) {
        super((EntityType)ProjectileEntityRegistry.SENTINEL_BEAM.get(), owner);
        this.disableVanillaRotation();
        this.setTicksToLive(TimeUtils.secondsToTicks(5.0f));
    }

    public void setTarget(Player target) {
        this.f_19804_.m_135381_(PLAYER_TARGET, Optional.of(target.m_20148_()));
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128350_("scaleY", this.scaleY);
        nbt.m_128350_("scaleRate", ((Float)this.f_19804_.m_135370_(SCALE_RATE)).floatValue());
        ((Optional)this.f_19804_.m_135370_(PLAYER_TARGET)).ifPresent(t -> nbt.m_128362_("playerTarget", t));
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.scaleY = nbt.m_128457_("scaleY");
        this.f_19804_.m_135381_(SCALE_RATE, (Object)Float.valueOf(nbt.m_128457_("scaleRate")));
        this.f_19804_.m_135381_(PLAYER_TARGET, NbtUtils.getIfPresent(nbt, "playerTarget", CompoundTag::m_128342_));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SCALE_RATE, (Object)Float.valueOf(0.2f));
        this.f_19804_.m_135372_(PLAYER_TARGET, Optional.empty());
    }

    public float getScale() {
        return this.scaleY;
    }

    public void setScaleRate(float rate) {
        this.f_19804_.m_135381_(SCALE_RATE, (Object)Float.valueOf(rate));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.scaleY += ((Float)this.f_19804_.m_135370_(SCALE_RATE)).floatValue();
        if (this.m_9236_().f_46443_) {
            this.tickParticles();
        }
    }

    public Optional<Player> getPlayerTarget() {
        return ((Optional)this.f_19804_.m_135370_(PLAYER_TARGET)).map(arg_0 -> ((Level)this.m_9236_()).m_46003_(arg_0));
    }

    @NotNull
    protected AABB m_142242_() {
        Entity entity;
        Optional<Player> playerTarget = this.getPlayerTarget();
        if (playerTarget.isEmpty() || !((entity = this.m_19749_()) instanceof LivingEntity)) {
            return EntityDimensions.m_20395_((float)2.0f, (float)this.scaleY).m_20393_(this.m_20182_());
        }
        LivingEntity owner = (LivingEntity)entity;
        Vec3 direction = EntityUtils.getAngleTo(owner, (Entity)playerTarget.get()).m_82490_((double)this.scaleY);
        return new AABB(this.m_20183_(), WorldUtils.toBlockPos(this.m_20182_().m_82549_(direction))).m_82377_(1.0, 2.0, 1.0);
    }

    @Override
    protected void checkForHit() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        List<ServerPlayer> playersHit = EntityUtils.getTargetablePlayers(serverLevel, this.m_20191_());
        playersHit.stream().map(EntityHitResult::new).forEach(this::m_5790_);
    }

    @Override
    protected void m_8060_(@NotNull BlockHitResult result) {
    }

    @Override
    @Nullable
    protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
        return IDLE_ANIMATION;
    }

    @Override
    protected GahAnimationState valueToAnimationState(int value) {
        return GahAnimationState.EMPTY;
    }

    @Override
    protected GahEntityState valueToEntityState(int value) {
        return GahEntityState.EMPTY;
    }

    @Override
    protected void m_5790_(@NotNull EntityHitResult result) {
        Entity hitEntity = result.m_82443_();
        Entity owner = this.m_19749_();
        if (owner instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)owner;
            if (hitEntity instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)hitEntity;
                this.hurtHitEntity(livingOwner, target);
            }
        }
        Optional.ofNullable(this.getHitEntitySoundEffect()).ifPresent(arg_0 -> ((SentinelBeam)this).m_216990_(arg_0));
    }

    @Override
    protected float getGravity() {
        return 0.0f;
    }

    private void tickParticles() {
        if (this.f_19797_ % 5 != 0) {
            return;
        }
        Level level = this.m_9236_();
        for (int times = 0; times < 10; ++times) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_175827_, this.m_20208_(0.5) - (double)this.m_146908_() * 1.5, this.m_20187_() - (double)(this.m_146909_() * this.scaleY), this.m_20262_(0.5) - (double)this.m_146908_() * 1.5, 0.05, 0.05, 0.05);
        }
    }
}

