/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.blocks.BlockParticleEmitter;
import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.projectile.GahProjectileBase;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.NbtUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import com.dee12452.gahoodrpg.utils.WorldUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Twister
extends GahProjectileBase<GahEntityState, GahAnimationState> {
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.twister.idle");
    private final Set<UUID> hitEntities;

    public Twister(EntityType<? extends Twister> entityType, Level level) {
        super(entityType, level);
        this.hitEntities = new HashSet<UUID>();
    }

    public Twister(LivingEntity owner) {
        super((EntityType)ProjectileEntityRegistry.TWISTER.get(), owner);
        this.setTicksToLive(TimeUtils.secondsToTicks(4.0f));
        this.hitEntities = new HashSet<UUID>();
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        NbtUtils.writeList(nbt, "hits", this.hitEntities.stream().toList(), CompoundTag::m_128362_);
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.hitEntities.clear();
        this.hitEntities.addAll(NbtUtils.readList(nbt, "hits", CompoundTag::m_128342_));
    }

    @Override
    @Nullable
    protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
        return IDLE_ANIMATION;
    }

    @Override
    protected GahAnimationState valueToAnimationState(int value) {
        return GahAnimationState.EMPTY;
    }

    @Override
    protected GahEntityState valueToEntityState(int value) {
        return GahEntityState.EMPTY;
    }

    @Override
    protected void animate() {
        Vec3 location;
        if (this.f_19796_.m_188503_(5) == 0) {
            location = new Vec3(1.0, (double)(this.f_19796_.m_188501_() * 2.0f), 0.0);
            location = this.f_19796_.m_188499_() ? this.m_20182_().m_82549_(location) : this.m_20182_().m_82546_(location);
            new BlockParticleEmitter((ParticleOptions)ParticleTypes.f_123796_, this.m_9236_(), WorldUtils.toBlockPos(location)).addParticles(this.f_19796_);
        }
        if (this.f_19796_.m_188503_(5) == 0) {
            location = new Vec3(0.0, (double)(this.f_19796_.m_188501_() * 2.5f), 1.0);
            location = this.f_19796_.m_188499_() ? this.m_20182_().m_82549_(location) : this.m_20182_().m_82546_(location);
            new BlockParticleEmitter((ParticleOptions)ParticleTypes.f_123796_, this.m_9236_(), WorldUtils.toBlockPos(location)).addParticles(this.f_19796_);
        }
    }

    @Override
    protected float getGravity() {
        return 0.0f;
    }

    protected void m_20101_() {
        Vec3 position;
        BlockPos center;
        Level level = this.m_9236_();
        if (level.m_8055_(center = WorldUtils.toBlockPos(position = this.m_20318_(1.0f).m_82520_(0.0, 0.25, 0.0))).m_280296_()) {
            this.onDiscard(GahProjectileBase.DiscardReason.BLOCK_HIT);
            this.m_146870_();
        }
    }

    @Override
    protected void checkForHit() {
        ServerLevel level;
        Level level2;
        block4: {
            block3: {
                level2 = this.m_9236_();
                if (!(level2 instanceof ServerLevel)) break block3;
                level = (ServerLevel)level2;
                level2 = this.m_19749_();
                if (level2 instanceof ServerPlayer) break block4;
            }
            return;
        }
        ServerPlayer player = (ServerPlayer)level2;
        AABB hitbox = this.m_20191_().m_82377_(8.0, 1.5, 8.0);
        List<LivingEntity> hits = level.m_45976_(LivingEntity.class, hitbox).stream().filter(e -> !this.hitEntities.contains(e.m_20148_())).toList();
        for (LivingEntity entity : hits) {
            if (this.hitEntities.contains(entity.m_20148_())) continue;
            this.hitEntities.add(entity.m_20148_());
            this.hurtHitEntity((LivingEntity)player, entity);
            double distanceTo = EntityUtils.getDistanceToEntity(entity, (Entity)this);
            Vec3 vec3 = EntityUtils.getAngleTo(entity, (Entity)this).m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_(distanceTo / 8.0);
            if (!(vec3.m_82556_() > 0.0)) continue;
            entity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
        }
    }
}

