/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.entities.projectile;

import com.dee12452.gahoodrpg.common.entities.GahAnimationState;
import com.dee12452.gahoodrpg.common.entities.GahEntityState;
import com.dee12452.gahoodrpg.common.entities.projectile.GahProjectileBase;
import com.dee12452.gahoodrpg.common.registries.ProjectileEntityRegistry;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;

public class WarriorSkull
extends GahProjectileBase<WarriorSkullState, WarriorSkullAnimationState> {
    protected static final EntityDataAccessor<Integer> TARGET_ID = SynchedEntityData.m_135353_(WarriorSkull.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private Consumer<Entity> onDiscardFunc;

    public WarriorSkull(EntityType<? extends GahProjectileBase<WarriorSkullState, WarriorSkullAnimationState>> entityType, Level level) {
        super(entityType, level);
    }

    public WarriorSkull(LivingEntity owner) {
        super((EntityType)ProjectileEntityRegistry.WARRIOR_SKULL.get(), owner);
    }

    public WarriorSkull(LivingEntity owner, int ticksToLive) {
        this(owner);
        this.setTicksToLive(ticksToLive);
    }

    public void attachTo(LivingEntity target, Consumer<Entity> onDiscard, int ticksToLive) {
        this.f_19804_.m_135381_(TARGET_ID, (Object)target.m_19879_());
        this.setEntityState(WarriorSkullState.ATTACHED);
        this.setAnimationState(WarriorSkullAnimationState.SPIN);
        this.setTicksToLive(ticksToLive);
        this.m_6034_(target.m_20185_(), target.m_20188_() + 0.5, target.m_20189_());
        this.onDiscardFunc = onDiscard;
    }

    @Override
    @Nullable
    protected RawAnimation getCurrentAnimation(AnimationState<GeoAnimatable> event) {
        return ((WarriorSkullAnimationState)this.getAnimationState()).animation();
    }

    @Override
    protected WarriorSkullAnimationState valueToAnimationState(int value) {
        return WarriorSkullAnimationState.values()[value];
    }

    @Override
    protected WarriorSkullState valueToEntityState(int value) {
        return WarriorSkullState.values()[value];
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("targetId", ((Integer)this.f_19804_.m_135370_(TARGET_ID)).intValue());
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag nbt) {
        super.m_7378_(nbt);
        this.f_19804_.m_135381_(TARGET_ID, (Object)nbt.m_128451_("targetId"));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_ID, (Object)-1);
    }

    @Override
    protected void checkForHit() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Optional<Entity> attachedTarget = this.getAttachedTarget(this.m_9236_());
        if (this.getEntityState() == WarriorSkullState.ATTACHED && attachedTarget.isPresent()) {
            this.tickAttached(attachedTarget.get());
        }
    }

    private void tickAttached(@Nullable Entity target) {
        if (target == null || !target.m_6084_()) {
            this.m_146870_();
            return;
        }
        this.m_6034_(target.m_20185_(), target.m_20188_() + 0.5, target.m_20189_());
    }

    @Override
    protected float getGravity() {
        return 0.0f;
    }

    @Override
    protected void onDiscard(GahProjectileBase.DiscardReason reason) {
        super.onDiscard(reason);
        Optional<Entity> target = this.getAttachedTarget(this.m_9236_());
        if (this.onDiscardFunc != null && target.isPresent()) {
            this.onDiscardFunc.accept(target.get());
        }
    }

    private Optional<Entity> getAttachedTarget(Level level) {
        int targetId = (Integer)this.f_19804_.m_135370_(TARGET_ID);
        if (targetId < 0) {
            return Optional.empty();
        }
        return Optional.ofNullable(level.m_6815_(targetId));
    }

    public static enum WarriorSkullState implements GahEntityState
    {
        SHOT,
        ATTACHED;


        @Override
        public int value() {
            return this.ordinal();
        }
    }

    public static enum WarriorSkullAnimationState implements GahAnimationState
    {
        IDLE(RawAnimation.begin().thenLoop("animation.warrior_skull.idle")),
        SPIN(RawAnimation.begin().thenLoop("animation.warrior_skull.spin"));

        private final RawAnimation animation;

        private WarriorSkullAnimationState(RawAnimation animation) {
            this.animation = animation;
        }

        @Override
        public int value() {
            return this.ordinal();
        }

        @Override
        public RawAnimation animation() {
            return this.animation;
        }
    }
}

