/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.events.listeners;

import com.dee12452.gahoodrpg.common.combat.GahAttribute;
import com.dee12452.gahoodrpg.common.combat.GahAttributeModifiers;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.events.listeners.EventListenerBase;
import com.dee12452.gahoodrpg.common.items.Items;
import com.dee12452.gahoodrpg.common.items.weapons.GahSwordItem;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import org.jetbrains.annotations.NotNull;

public class ItemAttributeModifierListener
extends EventListenerBase<ItemAttributeModifierEvent> {
    private static final Map<ItemStatsKey, GahStats> ITEM_BASE_STATS = new HashMap<ItemStatsKey, GahStats>(){
        {
            this.put(new ItemStatsKey((Item)Items.IRON_BOW.get(), EquipmentSlot.MAINHAND), new GahStats.Builder().damage(1.0f, 0.5f).build());
            this.put(new ItemStatsKey((Item)Items.IRON_WAND.get(), EquipmentSlot.MAINHAND), new GahStats.Builder().damage(1.0f, 0.5f).build());
            this.put(new ItemStatsKey(net.minecraft.world.item.Items.f_42383_, EquipmentSlot.MAINHAND), new GahStats.Builder().damage(1.0f, 0.5f).build());
            this.put(new ItemStatsKey((Item)Items.GOLDEN_BOW.get(), EquipmentSlot.MAINHAND), new GahStats.Builder().damage(0.0f, 3.0f).build());
            this.put(new ItemStatsKey((Item)Items.GOLDEN_WAND.get(), EquipmentSlot.MAINHAND), new GahStats.Builder().damage(0.0f, 3.0f).build());
            this.put(new ItemStatsKey(net.minecraft.world.item.Items.f_42430_, EquipmentSlot.MAINHAND), new GahStats.Builder().damage(0.0f, 3.0f).build());
            this.put(new ItemStatsKey((Item)Items.DIAMOND_BOW.get(), EquipmentSlot.MAINHAND), new GahStats.Builder().damage(2.0f, 2.0f).build());
            this.put(new ItemStatsKey((Item)Items.DIAMOND_WAND.get(), EquipmentSlot.MAINHAND), new GahStats.Builder().damage(2.0f, 2.0f).build());
            this.put(new ItemStatsKey(net.minecraft.world.item.Items.f_42388_, EquipmentSlot.MAINHAND), new GahStats.Builder().damage(2.0f, 2.0f).build());
        }
    };

    public ItemAttributeModifierListener(ItemAttributeModifierEvent event) {
        super(event);
    }

    @Override
    public void onEvent() {
        ITEM_BASE_STATS.forEach((key, stats) -> this.addEquipmentStats(key.item, key.slot, (GahStats)stats));
        this.fixBadAttributeModifiers();
    }

    private void addEquipmentStats(Item item, EquipmentSlot slot, GahStats stats) {
        this.addStats(stats, i -> i.stack.m_150930_(item) && i.slot.equals((Object)slot) && Optional.ofNullable(i.stack.m_41783_()).map(tag -> tag.m_128441_("AttributeModifiers")).orElse(false) == false);
    }

    private void addStats(GahStats stats, Predicate<ItemStackInfo> shouldAddStats) {
        if (!shouldAddStats.test(new ItemStackInfo(((ItemAttributeModifierEvent)this.event).getItemStack(), ((ItemAttributeModifierEvent)this.event).getSlotType()))) {
            return;
        }
        if (stats.strength() > 0.0f) {
            ((ItemAttributeModifierEvent)this.event).addModifier((Attribute)GahAttribute.STRENGTH.get(), GahAttributeModifiers.strength(stats.strength()));
        }
        if (stats.intelligence() > 0.0f) {
            ((ItemAttributeModifierEvent)this.event).addModifier((Attribute)GahAttribute.INTELLIGENCE.get(), GahAttributeModifiers.intelligence(stats.intelligence()));
        }
        if (stats.toughness() > 0.0f) {
            ((ItemAttributeModifierEvent)this.event).addModifier((Attribute)GahAttribute.TOUGHNESS.get(), GahAttributeModifiers.toughness(stats.toughness()));
        }
        if (stats.aegis() > 0.0f) {
            ((ItemAttributeModifierEvent)this.event).addModifier((Attribute)GahAttribute.AEGIS.get(), GahAttributeModifiers.aegis(stats.aegis()));
        }
    }

    private void fixBadAttributeModifiers() {
        Multimap itemStackModifiers = ((ItemAttributeModifierEvent)this.event).getOriginalModifiers();
        for (Map.Entry modifier : itemStackModifiers.entries()) {
            Optional<UUID> fixedUUID = ItemAttributeModifierListener.getFixedUUID(modifier);
            if (fixedUUID.isEmpty()) continue;
            ((ItemAttributeModifierEvent)this.event).removeAttribute((Attribute)modifier.getKey());
            AttributeModifier attributeModifier = (AttributeModifier)modifier.getValue();
            AttributeModifier fixedModifier = new AttributeModifier(fixedUUID.get(), attributeModifier.m_22214_(), attributeModifier.m_22218_(), attributeModifier.m_22217_());
            ((ItemAttributeModifierEvent)this.event).addModifier((Attribute)modifier.getKey(), fixedModifier);
        }
    }

    @NotNull
    private static Optional<UUID> getFixedUUID(Map.Entry<Attribute, AttributeModifier> modifier) {
        UUID modifierId = modifier.getValue().m_22209_();
        if (modifierId.equals(GahSwordItem.getAttackDamageAttributeModifierUUID()) && modifierId != GahSwordItem.getAttackDamageAttributeModifierUUID()) {
            return Optional.of(GahSwordItem.getAttackDamageAttributeModifierUUID());
        }
        if (modifierId.equals(GahSwordItem.getAttackSpeedAttributeModifierUUID()) && modifierId != GahSwordItem.getAttackSpeedAttributeModifierUUID()) {
            return Optional.of(GahSwordItem.getAttackSpeedAttributeModifierUUID());
        }
        return Optional.empty();
    }

    private record ItemStackInfo(ItemStack stack, EquipmentSlot slot) {
    }

    public record ItemStatsKey(Item item, EquipmentSlot slot) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemStatsKey that = (ItemStatsKey)o;
            return Objects.equals(this.item, that.item) && this.slot == that.slot;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.item, this.slot);
        }
    }
}

