/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.events.listeners;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.ServerPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import com.dee12452.gahoodrpg.common.combat.GahAttribute;
import com.dee12452.gahoodrpg.common.data.GahWorldSavedData;
import com.dee12452.gahoodrpg.common.events.listeners.EventListenerBase;
import com.dee12452.gahoodrpg.common.network.ClientSync;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerPlayerLevelUp;
import com.dee12452.gahoodrpg.utils.RoleUtils;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class LivingDeathListener
extends EventListenerBase<LivingDeathEvent> {
    public LivingDeathListener(LivingDeathEvent event) {
        super(event);
    }

    @Override
    public void onEvent() {
        LivingEntity livingEntity = ((LivingDeathEvent)this.event).getEntity();
        if (livingEntity instanceof Player) {
            Player deadPlayer = (Player)livingEntity;
            RoleUtils.getUsableSpells(deadPlayer).forEach(spell -> spell.onPlayerDeath(deadPlayer, ((LivingDeathEvent)this.event).getSource().m_7639_()));
            this.saveEquipment(deadPlayer);
        }
        if ((livingEntity = ((LivingDeathEvent)this.event).getSource().m_7639_()) instanceof ServerPlayer) {
            ServerPlayer killingPlayer = (ServerPlayer)livingEntity;
            GahWorldSavedData.load(killingPlayer.m_20194_()).onLivingDeath(((LivingDeathEvent)this.event).getEntity());
            CommonPlayerCapability caps = Capabilities.commonPlayer((Player)killingPlayer);
            Optional<IGahRole> role = caps.getCurrentRole();
            if (role.isEmpty()) {
                return;
            }
            int currentLevel = role.get().getLevel();
            this.addKillExperience(killingPlayer, role.get(), ((LivingDeathEvent)this.event).getEntity());
            int newLevel = role.get().getLevel();
            if (currentLevel != newLevel) {
                new ServerPlayerLevelUp().onServerProcess(killingPlayer, new ServerPlayerLevelUp.Message(newLevel));
            }
            RoleUtils.getUsableSpells((Player)killingPlayer).forEach(spell -> spell.onKillEntity(killingPlayer, ((LivingDeathEvent)this.event).getEntity()));
        }
    }

    private void addKillExperience(ServerPlayer player, IGahRole role, LivingEntity deadEntity) {
        Optional<AttributeInstance> maybeAdditionalXP = Optional.ofNullable(deadEntity.m_21051_((Attribute)GahAttribute.GAH_EXPERIENCE.get()));
        int gahXP = maybeAdditionalXP.map(AttributeInstance::m_22135_).map(Double::intValue).orElse(0);
        if (gahXP == 0 && deadEntity instanceof Monster) {
            gahXP = 1;
        }
        role.addExperience(gahXP);
        new ClientSync.Builder(player).roles().build().sync();
    }

    private void saveEquipment(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerPlayerCapability serverCaps = Capabilities.serverPlayer(serverPlayer);
        if (serverCaps.getGraveboxData().getBoxPos() != null && !serverCaps.getGraveboxData().addToCache(player)) {
            player.m_5661_((Component)Component.m_237115_((String)"message.gahoodrpg.gravebox.full"), false);
        }
        if (!serverCaps.shouldKeepEquipmentOnDeath()) {
            return;
        }
    }
}

