/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.events.listeners;

import com.dee12452.gahoodrpg.common.events.listeners.EventListenerBase;
import com.dee12452.gahoodrpg.common.registries.LivingEntityRegistry;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;

public class LivingEntityModifySpawnPlacementListener
extends EventListenerBase<SpawnPlacementRegisterEvent> {
    public LivingEntityModifySpawnPlacementListener(SpawnPlacementRegisterEvent event) {
        super(event);
    }

    @Override
    public void onEvent() {
        this.updateVanillaSpawnRules();
        this.addTier1PlacementRules();
        this.addTier2PlacementRules();
        this.addTier3PlacementRules();
        this.addTier4PlacementRules();
    }

    private void updateVanillaSpawnRules() {
        Lists.newArrayList((Object[])new EntityType[]{EntityType.f_20526_, EntityType.f_20524_, EntityType.f_20501_, EntityType.f_20479_, EntityType.f_20558_}).forEach(entity -> ((SpawnPlacementRegisterEvent)this.event).register(entity, new SpawnPredicateBuilder().outsideTierBiome("is_tier2").outsideTierBiome("is_tier3").outsideTierBiome("is_spooky").build(), SpawnPlacementRegisterEvent.Operation.AND));
        Lists.newArrayList((Object[])new EntityType[]{EntityType.f_20526_, EntityType.f_20479_, EntityType.f_20558_}).forEach(entity -> ((SpawnPlacementRegisterEvent)this.event).register(entity, new SpawnPredicateBuilder().outsideTierBiome("is_cold/overworld").build(), SpawnPlacementRegisterEvent.Operation.AND));
    }

    private void addTier1PlacementRules() {
        Lists.newArrayList((Object[])new EntityType[]{(EntityType)LivingEntityRegistry.ENRAGED_ZOMBIE.get(), (EntityType)LivingEntityRegistry.ENRAGED_CREEPER.get(), (EntityType)LivingEntityRegistry.ENRAGED_SKELETON.get(), (EntityType)LivingEntityRegistry.ENRAGED_SPIDER.get()}).forEach(entity -> this.registerMobPlacement((EntityType)entity, new SpawnPredicateBuilder().inTierBiome("is_tier1").darkAreas().underground()));
    }

    private void addTier2PlacementRules() {
        this.registerMobPlacement((EntityType)LivingEntityRegistry.ARCHEOLOGIST.get(), new SpawnPredicateBuilder().inTierBiome("is_tier2").underground());
        this.registerMobPlacement((EntityType)LivingEntityRegistry.SCORPION.get(), new SpawnPredicateBuilder().inTierBiome("is_tier2"));
        Lists.newArrayList((Object[])new EntityType[]{(EntityType)LivingEntityRegistry.SPHINX.get(), (EntityType)LivingEntityRegistry.CRAZED_ARCHEOLOGIST.get(), (EntityType)LivingEntityRegistry.DESERT_CREEPER.get()}).forEach(entity -> this.registerMobPlacement((EntityType)entity, new SpawnPredicateBuilder().inTierBiome("is_tier2").darkAreas().underground()));
        this.registerMobPlacement((EntityType)LivingEntityRegistry.CAVE_SCORPION.get(), new SpawnPredicateBuilder().inTierBiome("is_tier2").darkAreas().deepUnderground());
    }

    private void addTier3PlacementRules() {
        this.registerMobPlacement((EntityType)LivingEntityRegistry.POISONOUS_FROG.get(), new SpawnPredicateBuilder().inTierBiome("is_tier3"));
        Lists.newArrayList((Object[])new EntityType[]{(EntityType)LivingEntityRegistry.CAMO_SKELETON.get(), (EntityType)LivingEntityRegistry.CHOMPLANT.get()}).forEach(entity -> this.registerMobPlacement((EntityType)entity, new SpawnPredicateBuilder().inTierBiome("is_tier3").darkAreas().underground()));
        this.registerMobPlacement((EntityType)LivingEntityRegistry.JAGARIX.get(), new SpawnPredicateBuilder().inTierBiome("is_tier3").darkAreas().deepUnderground());
    }

    private void addTier4PlacementRules() {
        this.registerMobPlacement((EntityType)LivingEntityRegistry.ANGRY_SNOWMAN.get(), new SpawnPredicateBuilder().inTierBiome("is_cold/overworld").aboveGround());
        Lists.newArrayList((Object[])new EntityType[]{(EntityType)LivingEntityRegistry.FROST_CREEPER.get(), (EntityType)LivingEntityRegistry.FROST_SPIDER.get()}).forEach(entity -> this.registerMobPlacement((EntityType)entity, new SpawnPredicateBuilder().inTierBiome("is_cold/overworld").darkAreas()));
        this.registerMobPlacement((EntityType)LivingEntityRegistry.FOOLSHROOM.get(), new SpawnPredicateBuilder().inTierBiome("is_spooky").aboveGround());
        this.registerMobPlacement((EntityType)LivingEntityRegistry.SNEAK_GHOUL.get(), new SpawnPredicateBuilder().inTierBiome("is_spooky"));
    }

    private <E extends Mob> void registerMobPlacement(EntityType<E> mobType, SpawnPredicateBuilder spawnPredicateBuilder) {
        ((SpawnPlacementRegisterEvent)this.event).register(mobType, SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, spawnPredicateBuilder.build(), SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    private static class SpawnPredicateBuilder {
        private final List<SpawnPlacements.SpawnPredicate<Mob>> predicates = new ArrayList<SpawnPlacements.SpawnPredicate<Mob>>();

        public SpawnPredicateBuilder inTierBiome(String tierTag) {
            this.predicates.add((SpawnPlacements.SpawnPredicate<Mob>)((SpawnPlacements.SpawnPredicate)(entityType, level, spawnType, pos, random) -> {
                BlockPos aboveGroundBiomePos = new BlockPos(pos.m_123341_(), 64, pos.m_123343_());
                Holder currentBiome = level.m_204166_(aboveGroundBiomePos);
                return currentBiome.containsTag(this.biomeFromTag(level, tierTag));
            }));
            return this;
        }

        public SpawnPredicateBuilder outsideTierBiome(String tierTag) {
            this.predicates.add((SpawnPlacements.SpawnPredicate<Mob>)((SpawnPlacements.SpawnPredicate)(entityType, level, spawnType, pos, random) -> {
                BlockPos aboveGroundBiomePos = new BlockPos(pos.m_123341_(), 64, pos.m_123343_());
                Holder currentBiome = level.m_204166_(aboveGroundBiomePos);
                return !currentBiome.containsTag(this.biomeFromTag(level, tierTag));
            }));
            return this;
        }

        public SpawnPredicateBuilder aboveGround() {
            this.predicates.add((SpawnPlacements.SpawnPredicate<Mob>)((SpawnPlacements.SpawnPredicate)(entityType, level, spawnType, pos, random) -> pos.m_123342_() > 48));
            return this;
        }

        public SpawnPredicateBuilder darkAreas() {
            this.predicates.add((SpawnPlacements.SpawnPredicate<Mob>)((SpawnPlacements.SpawnPredicate)(entityType, level, spawnType, pos, random) -> Monster.m_219009_((ServerLevelAccessor)level, (BlockPos)pos, (RandomSource)random)));
            return this;
        }

        public SpawnPredicateBuilder underground() {
            return this.spawnBelow(48);
        }

        public SpawnPredicateBuilder deepUnderground() {
            return this.spawnBelow(0);
        }

        public SpawnPlacements.SpawnPredicate<? extends Mob> build() {
            return (entityType, level, spawnType, pos, random) -> this.predicates.stream().allMatch(predicate -> predicate.m_217080_(entityType, level, spawnType, pos, random));
        }

        private SpawnPredicateBuilder spawnBelow(int maxY) {
            this.predicates.add((SpawnPlacements.SpawnPredicate<Mob>)((SpawnPlacements.SpawnPredicate)(entityType, level, spawnType, pos, random) -> pos.m_123342_() < maxY));
            return this;
        }

        private TagKey<Biome> biomeFromTag(ServerLevelAccessor level, String tagId) {
            MinecraftServer server = Optional.ofNullable(level.m_7654_()).orElseThrow();
            Registry registry = (Registry)server.m_206579_().m_6632_(Registries.f_256952_).orElseThrow();
            return registry.m_203612_().filter(tag -> ((TagKey)tag.getFirst()).f_203868_().m_135815_().equals(tagId)).map(Pair::getFirst).findFirst().orElseThrow();
        }
    }
}

