/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.events.listeners;

import com.dee12452.gahoodrpg.common.combat.GahAttribute;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.events.listeners.EventListenerBase;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;

public class LivingEntityModifyStatsListener
extends EventListenerBase<EntityAttributeModificationEvent> {
    public LivingEntityModifyStatsListener(EntityAttributeModificationEvent event) {
        super(event);
    }

    @Override
    public void onEvent() {
        new ModifyEntityBuilder(EntityType.f_20566_).setStats(LivingEntityModifyStatsListener.stats(EntityUtils.getTieredHealth(2)).intelligence(25.0f).resistPercent(40.0f)).setExperience(10.0).build();
        new ModifyEntityBuilder(EntityType.f_20565_).setStats(LivingEntityModifyStatsListener.stats(EntityUtils.getTieredBossHealth(3)).strength(EntityUtils.toHealth(8.0f)).intelligence(EntityUtils.toHealth(8.0f)).build()).setExperience(1000.0).build();
        new ModifyEntityBuilder(EntityType.f_20513_).setStats(LivingEntityModifyStatsListener.stats(EntityUtils.getTieredHealth(4)).strength(31.0f).toughnessPercent(50.0f).aegisPercent(40.0f)).setExperience(25.0).build();
        new ModifyEntityBuilder(EntityType.f_20493_).setStats(LivingEntityModifyStatsListener.stats(EntityUtils.getTieredHealth(4)).strength(33.0f).resistPercent(50.0f)).setExperience(25.0).build();
        new ModifyEntityBuilder(EntityType.f_20568_).setStats(LivingEntityModifyStatsListener.stats(EntityUtils.getTieredHealth(4)).intelligence(35.0f).resistPercent(50.0f)).setExperience(30.0).build();
        new ModifyEntityBuilder(EntityType.f_20491_).setStats(LivingEntityModifyStatsListener.stats(EntityUtils.getTieredHealth(3)).strength(31.0f).toughnessPercent(30.0f).aegisPercent(50.0f)).setExperience(25.0).build();
        new ModifyEntityBuilder(EntityType.f_20459_).setStats(LivingEntityModifyStatsListener.stats(EntityUtils.getTieredHealth(4)).intelligence(34.0f).toughnessPercent(50.0f).aegisPercent(30.0f)).setExperience(30.0).build();
        new ModifyEntityBuilder(EntityType.f_20495_).setStats(LivingEntityModifyStatsListener.stats(EntityUtils.getTieredHealth(4)).intelligence(34.0f).resistPercent(50.0f)).setExperience(30.0).build();
        new ModifyEntityBuilder(EntityType.f_217015_).setStats(LivingEntityModifyStatsListener.stats(EntityUtils.getTieredBossHealth(4)).strength(50.0f).resistPercent(60.0f)).setExperience(500.0).build();
        new ModifyEntityBuilder(EntityType.f_20481_).setStats(LivingEntityModifyStatsListener.stats(EntityUtils.getTieredHealth(4)).strength(33.0f).resistPercent(50.0f)).setExperience(30.0).build();
        new ModifyEntityBuilder(EntityType.f_20554_).setStats(LivingEntityModifyStatsListener.stats(EntityUtils.getTieredHealth(2)).strength(20.0f).intelligence(25.0f).resistPercent(25.0f)).setExperience(20.0).build();
        new ModifyEntityBuilder(EntityType.f_20455_).setStats(LivingEntityModifyStatsListener.stats(EntityUtils.getTieredHealth(4)).intelligence(33.0f).resistPercent(50.0f)).setExperience(30.0).build();
        new ModifyEntityBuilder(EntityType.f_20563_).setStats(LivingEntityModifyStatsListener.stats(EntityUtils.getTieredHealth(4) + EntityUtils.toHealth(5.0f)).intelligence(37.0f).resistPercent(60.0f)).setExperience(30.0).build();
    }

    private static GahStats.Builder stats(float health) {
        return new GahStats.Builder().vitality(health);
    }

    private class ModifyEntityBuilder<T extends LivingEntity> {
        private final EntityType<T> entityType;
        private final List<Runnable> modifiers = new ArrayList<Runnable>();

        public ModifyEntityBuilder(EntityType<T> entityType) {
            this.entityType = entityType;
        }

        public ModifyEntityBuilder<T> setStats(GahStats.Builder stats) {
            return this.setStats(stats.build());
        }

        public ModifyEntityBuilder<T> setStats(GahStats stats) {
            this.modifiers.add(() -> {
                this.addEntityStat(this.entityType, (Attribute)GahAttribute.STRENGTH.get(), stats.strength());
                this.addEntityStat(this.entityType, (Attribute)GahAttribute.INTELLIGENCE.get(), stats.intelligence());
                this.addEntityStat(this.entityType, (Attribute)GahAttribute.TOUGHNESS.get(), stats.toughness());
                this.addEntityStat(this.entityType, (Attribute)GahAttribute.AEGIS.get(), stats.aegis());
                this.addEntityStat(this.entityType, (Attribute)GahAttribute.TOUGHNESS_PERCENT.get(), stats.toughnessPercent());
                this.addEntityStat(this.entityType, (Attribute)GahAttribute.AEGIS_PERCENT.get(), stats.aegisPercent());
                this.addEntityStat(this.entityType, Attributes.f_22283_, stats.dexterity());
                this.addEntityStat(this.entityType, Attributes.f_22279_, stats.dexterity());
                this.addEntityStat(this.entityType, Attributes.f_22276_, stats.vitality());
            });
            return this;
        }

        public ModifyEntityBuilder<T> setExperience(double amount) {
            this.modifiers.add(() -> this.addEntityStat(this.entityType, (Attribute)GahAttribute.GAH_EXPERIENCE.get(), amount));
            return this;
        }

        public void build() {
            this.modifiers.forEach(Runnable::run);
        }

        private void addEntityStat(EntityType<T> entityType, Attribute attribute, double amount) {
            if (amount <= 0.0) {
                return;
            }
            ((EntityAttributeModificationEvent)LivingEntityModifyStatsListener.this.event).add(entityType, attribute, amount);
        }
    }
}

