/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.events.listeners;

import com.dee12452.gahoodrpg.common.combat.GahAttributeModifiers;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.events.listeners.EventListenerBase;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;

public class LivingEquipmentChangeListener
extends EventListenerBase<LivingEquipmentChangeEvent> {
    public LivingEquipmentChangeListener(LivingEquipmentChangeEvent event) {
        super(event);
    }

    @Override
    public void onEvent() {
        LivingEntity livingEntity = ((LivingEquipmentChangeEvent)this.event).getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        GahStats stats = GahStats.player(player);
        this.updatePlayerHealth(player, stats);
        this.updatePlayerDexterity(player, stats);
    }

    private void updatePlayerDexterity(Player player, GahStats stats) {
        float dexterity = stats.dexterity();
        this.applyAttributeModifier(player, Attributes.f_22279_, GahAttributeModifiers.dexterity(dexterity / 1000.0f));
        this.applyAttributeModifier(player, Attributes.f_22283_, GahAttributeModifiers.dexterity(dexterity / 3.0f));
    }

    private void updatePlayerHealth(Player player, GahStats stats) {
        float additionalHealth = stats.vitality();
        AttributeModifier healthModifier = GahAttributeModifiers.vitality(additionalHealth);
        this.applyAttributeModifier(player, Attributes.f_22276_, healthModifier);
        player.m_21153_((float)Math.min((double)player.m_21223_(), Attributes.f_22276_.m_22082_() + (double)additionalHealth));
    }

    private void applyAttributeModifier(Player player, Attribute attribute, AttributeModifier modifier) {
        AttributeInstance instance = player.m_21051_(attribute);
        if (instance == null) {
            return;
        }
        instance.m_22120_(modifier.m_22209_());
        if (modifier.m_22218_() > 0.0) {
            instance.m_22118_(modifier);
        }
    }
}

