/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.events.listeners;

import com.dee12452.gahoodrpg.common.capabilities.spell.IGahSpell;
import com.dee12452.gahoodrpg.common.combat.GahCombat;
import com.dee12452.gahoodrpg.common.combat.GahDamage;
import com.dee12452.gahoodrpg.common.combat.GahDamageCalculator;
import com.dee12452.gahoodrpg.common.combat.GahDamageSource;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.entities.living.IGahMob;
import com.dee12452.gahoodrpg.common.events.listeners.EventListenerBase;
import com.dee12452.gahoodrpg.common.items.Items;
import com.dee12452.gahoodrpg.utils.EntityUtils;
import com.dee12452.gahoodrpg.utils.RoleUtils;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class LivingHurtListener
extends EventListenerBase<LivingHurtEvent> {
    public LivingHurtListener(LivingHurtEvent event) {
        super(event);
    }

    @Override
    public void onEvent() {
        Entity directAttacker = ((LivingHurtEvent)this.event).getSource().m_7640_();
        Entity attacker = ((LivingHurtEvent)this.event).getSource().m_7639_();
        LivingEntity target = ((LivingHurtEvent)this.event).getEntity();
        if (GahDamageSource.is(((LivingHurtEvent)this.event).getSource())) {
            return;
        }
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            this.handlePlayerAttack(player, directAttacker, target);
            return;
        }
        if (attacker != null && target instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)target;
            this.handleAttackPlayer(attacker, directAttacker, player);
        }
    }

    private void handlePlayerAttack(ServerPlayer player, Entity directAttacker, LivingEntity target) {
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)Items.ONE_PUNCH_MAN.get())) {
            target.m_6074_();
            ((LivingHurtEvent)this.event).setCanceled(true);
            return;
        }
        float baseDamage = GahDamageCalculator.calculateVanillaDamage(((LivingHurtEvent)this.event).getSource(), ((LivingHurtEvent)this.event).getAmount(), target);
        List<IGahSpell> spells = RoleUtils.getUsableSpells((Player)player);
        GahDamage damageDealt = EntityUtils.is((Entity)player, directAttacker) ? spells.stream().map(spell -> spell.onAttackEntity(player, (Entity)target)).reduce(GahDamage.ZERO, GahDamage::add) : spells.stream().map(spell -> spell.onIndirectAttackEntity(player, directAttacker, (Entity)target)).reduce(GahDamage.ZERO, GahDamage::add);
        ((LivingHurtEvent)this.event).setCanceled(true);
        target.m_6469_(GahDamageSource.direct((Entity)player, directAttacker, damageDealt), damageDealt.total() + baseDamage);
    }

    private void handleAttackPlayer(Entity attacker, Entity directAttacker, ServerPlayer player) {
        float vanillaDamage = GahDamageCalculator.calculateVanillaDamage(((LivingHurtEvent)this.event).getSource(), ((LivingHurtEvent)this.event).getAmount(), (LivingEntity)player);
        GahDamage baseGahDamage = this.calculateBaseDamage(attacker, directAttacker, player);
        List<IGahSpell> currentSpells = RoleUtils.getUsableSpells((Player)player);
        Supplier<Stream> supplierOnEntityAttackCallbacks = () -> currentSpells.stream().map(spell -> spell.onEntityAttack(player, attacker, baseGahDamage));
        if (supplierOnEntityAttackCallbacks.get().anyMatch(Optional::isEmpty)) {
            ((LivingHurtEvent)this.event).setCanceled(true);
            return;
        }
        GahDamage totalGahDamage = supplierOnEntityAttackCallbacks.get().filter(Optional::isPresent).map(Optional::get).reduce(baseGahDamage, GahDamage::add);
        ((LivingHurtEvent)this.event).setCanceled(true);
        player.m_6469_(GahDamageSource.direct(attacker, directAttacker, totalGahDamage), totalGahDamage.total() + vanillaDamage);
    }

    private GahDamage calculateBaseDamage(Entity attacker, Entity directAttacker, ServerPlayer player) {
        if (attacker instanceof IGahMob) {
            IGahMob damageDealer = (IGahMob)attacker;
            if (EntityUtils.is(attacker, directAttacker)) {
                return damageDealer.onDirectDamage((LivingEntity)player);
            }
            return damageDealer.onIndirectDamage(directAttacker, (LivingEntity)player);
        }
        if (!GahStats.of(attacker).equals(GahStats.EMPTY)) {
            return GahCombat.entity(attacker).calculateDamage((Entity)player);
        }
        return GahDamage.ZERO;
    }
}

