/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.events.listeners;

import com.dee12452.gahoodrpg.common.blocks.GahLevelBlock;
import com.dee12452.gahoodrpg.common.events.listeners.EventListenerBase;
import com.dee12452.gahoodrpg.common.items.tools.IGahTool;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PlayerHarvestCheckListener
extends EventListenerBase<PlayerEvent.HarvestCheck> {
    public PlayerHarvestCheckListener(PlayerEvent.HarvestCheck event) {
        super(event);
    }

    @Override
    public void onEvent() {
        if (!((PlayerEvent.HarvestCheck)this.event).canHarvest()) {
            return;
        }
        Block block = ((PlayerEvent.HarvestCheck)this.event).getTargetBlock().m_60734_();
        if (!(block instanceof GahLevelBlock)) {
            return;
        }
        GahLevelBlock levelBlock = (GahLevelBlock)block;
        GahLevelBlock.MiningTool miningTool = levelBlock.getMiningTool();
        int level = levelBlock.getLevel();
        Player player = ((PlayerEvent.HarvestCheck)this.event).getEntity();
        Item toolUsed = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_();
        if (!miningTool.canMine(toolUsed)) {
            ((PlayerEvent.HarvestCheck)this.event).setCanHarvest(false);
            return;
        }
        if (level <= 1) {
            ((PlayerEvent.HarvestCheck)this.event).setCanHarvest(true);
            return;
        }
        if (!(toolUsed instanceof IGahTool)) {
            ((PlayerEvent.HarvestCheck)this.event).setCanHarvest(false);
            return;
        }
        IGahTool tool = (IGahTool)toolUsed;
        ((PlayerEvent.HarvestCheck)this.event).setCanHarvest(tool.getMaterial().getTier() >= level - 1);
    }
}

