/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.events.listeners;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.ServerPlayerCapability;
import com.dee12452.gahoodrpg.common.events.listeners.EventListenerBase;
import com.dee12452.gahoodrpg.common.network.ClientSync;
import com.dee12452.gahoodrpg.utils.RoleUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PlayerRespawnListener
extends EventListenerBase<PlayerEvent.PlayerRespawnEvent> {
    public PlayerRespawnListener(PlayerEvent.PlayerRespawnEvent event) {
        super(event);
    }

    @Override
    public void onEvent() {
        Player player = ((PlayerEvent.PlayerRespawnEvent)this.event).getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        this.loadEquipmentCache(serverPlayer);
        RoleUtils.getUsableSpells((Player)serverPlayer).forEach(spell -> spell.onPlayerRespawn(serverPlayer));
        new ClientSync.Builder(serverPlayer).all().sync();
    }

    private void loadEquipmentCache(ServerPlayer player) {
        ServerPlayerCapability serverCaps = Capabilities.serverPlayer(player);
        serverCaps.getEquipmentCache().load(player);
    }
}

