/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.events.listeners;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.role.GahRoles;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import com.dee12452.gahoodrpg.common.events.listeners.EventListenerBase;
import com.dee12452.gahoodrpg.common.network.ClientSync;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import org.apache.commons.lang3.tuple.Pair;

public class RegisterCommandsListener
extends EventListenerBase<RegisterCommandsEvent> {
    public RegisterCommandsListener(RegisterCommandsEvent event) {
        super(event);
    }

    @Override
    public void onEvent() {
        CommandDispatcher dispatcher = ((RegisterCommandsEvent)this.event).getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"gahoodrpg").requires(source -> source.m_6761_(3))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").then(Commands.m_82127_((String)"all").then(Commands.m_82129_((String)"playerName", (ArgumentType)StringArgumentType.string()).executes(RegisterCommandsListener::resetAll)))).then(Commands.m_82127_((String)"role").then(Commands.m_82129_((String)"roleName", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"playerName", (ArgumentType)StringArgumentType.string()).executes(RegisterCommandsListener::resetRole)))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"experience").then(Commands.m_82127_((String)"max").then(Commands.m_82129_((String)"playerName", (ArgumentType)StringArgumentType.string()).executes(RegisterCommandsListener::maxAll)))).then(Commands.m_82127_((String)"role").then(Commands.m_82129_((String)"roleName", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"expnum", (ArgumentType)IntegerArgumentType.integer()).then(Commands.m_82129_((String)"playerName", (ArgumentType)StringArgumentType.string()).executes(RegisterCommandsListener::setRoleExperienceCommand)))))));
    }

    private static int resetAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = RegisterCommandsListener.findPlayer(context);
        CommonPlayerCapability playerData = Capabilities.commonPlayer((Player)player);
        playerData.clear();
        new ClientSync.Builder(player).all().sync();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"You've successfully cleared your gah powers"), false);
        return 1;
    }

    private static int maxAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = RegisterCommandsListener.findPlayer(context);
        CommonPlayerCapability playerData = Capabilities.commonPlayer((Player)player);
        playerData.clear();
        GahRoles.getRoles().stream().map(pair -> playerData.getRole((UUID)pair.getKey()).orElseThrow()).forEach(role -> role.setLevel(role.getMaxLevel()));
        playerData.setRole(null);
        new ClientSync.Builder(player).all().sync();
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"You are now max level in everything. Have fun!"), false);
        return 1;
    }

    private static int resetRole(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String roleName = StringArgumentType.getString(context, (String)"roleName").toUpperCase();
        try {
            ServerPlayer player = RegisterCommandsListener.findPlayer(context);
            Pair<UUID, IGahRole> role = RegisterCommandsListener.findRole(context, player);
            CommonPlayerCapability cap = Capabilities.commonPlayer((Player)player);
            cap.resetRole((UUID)role.getKey());
            new ClientSync.Builder(player).all().sync();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("You've successfully reset your %s role", roleName)), false);
            return 1;
        }
        catch (Exception ex) {
            LiteralMessage message = new LiteralMessage(String.format("Invalid argument for gah role: %s", roleName));
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)message), (Message)message);
        }
    }

    private static int setRoleExperienceCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String gahRoleStr = StringArgumentType.getString(context, (String)"roleName").toUpperCase();
        int expInt = IntegerArgumentType.getInteger(context, (String)"expnum");
        try {
            ServerPlayer player = RegisterCommandsListener.findPlayer(context);
            Pair<UUID, IGahRole> role = RegisterCommandsListener.findRole(context, player);
            CommonPlayerCapability cap = Capabilities.commonPlayer((Player)player);
            cap.resetRole((UUID)role.getKey());
            IGahRole roleValue = cap.getRole((UUID)role.getKey()).orElseThrow();
            roleValue.addExperience(Math.max(0, expInt));
            roleValue.getAllSpells((Player)player).forEach(spell -> {
                spell.onEnable((Player)player);
                spell.onDisable((Player)player);
            });
            new ClientSync.Builder(player).all().sync();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)String.format("You've updated your %s role experience to %d", gahRoleStr, roleValue.getExperience())), false);
            return 1;
        }
        catch (Exception ex) {
            LiteralMessage message = new LiteralMessage(String.format("Invalid argument for gah role: %s", gahRoleStr));
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)message), (Message)message);
        }
    }

    private static ServerPlayer findPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String playerName = StringArgumentType.getString(context, (String)"playerName");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11255_(playerName);
        if (player == null) {
            LiteralMessage message = new LiteralMessage(String.format("Unable to find player: %s", playerName));
            throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)message), (Message)message);
        }
        return player;
    }

    private static Pair<UUID, IGahRole> findRole(CommandContext<CommandSourceStack> context, ServerPlayer player) throws CommandSyntaxException {
        CommonPlayerCapability cap = Capabilities.commonPlayer((Player)player);
        String gahRoleStr = StringArgumentType.getString(context, (String)"roleName").toLowerCase();
        List<Pair<UUID, Supplier<IGahRole>>> roles = GahRoles.getRoles();
        for (Pair<UUID, Supplier<IGahRole>> role : roles) {
            Optional<IGahRole> roleValue;
            String roleClassName = ((IGahRole)((Supplier)role.getValue()).get()).getClass().getSimpleName().toLowerCase();
            if (!roleClassName.contains(gahRoleStr) || !(roleValue = cap.getRole((UUID)role.getKey())).isPresent()) continue;
            return Pair.of((Object)((UUID)role.getKey()), (Object)roleValue.get());
        }
        LiteralMessage message = new LiteralMessage(String.format("Unable to find role: %s", gahRoleStr));
        throw new CommandSyntaxException((CommandExceptionType)new SimpleCommandExceptionType((Message)message), (Message)message);
    }
}

