/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.items;

import com.dee12452.gahoodrpg.common.entities.living.boss.GahBossBase;
import com.dee12452.gahoodrpg.common.items.SimpleSingleStackItem;
import com.dee12452.gahoodrpg.common.registries.LivingEntityRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BossSpawnItem
extends SimpleSingleStackItem {
    private static final Map<Integer, Supplier<EntityType<? extends GahBossBase<?, ?>>>> BOSS_TIER_MAP = new HashMap<Integer, Supplier<EntityType<? extends GahBossBase<?, ?>>>>(){
        {
            this.put(1, () -> LivingEntityRegistry.THE_ENRAGED.get());
            this.put(2, () -> LivingEntityRegistry.THE_PHARAOH.get());
            this.put(3, () -> LivingEntityRegistry.THE_DRUID.get());
        }
    };
    private final int tier;

    public static EntityType<? extends GahBossBase<?, ?>> getBossType(int tier) {
        return BOSS_TIER_MAP.get(tier).get();
    }

    public BossSpawnItem(int tier) {
        this.tier = tier;
    }

    public int getTier() {
        return this.tier;
    }

    public void m_7373_(@NotNull ItemStack p_41421_, @Nullable Level p_41422_, @NotNull List<Component> components, @NotNull TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, components, p_41424_);
        components.add((Component)Component.m_237119_());
        components.add(this.getEntitySpawnDescription());
    }

    private Component getEntitySpawnDescription() {
        return Component.m_237110_((String)"item.gahoodrpg.tooltip.boss_spawn_item", (Object[])new Object[]{BossSpawnItem.getBossType(this.tier).m_20676_().getString()}).m_130948_(Style.f_131099_.m_131150_(Style.f_131100_).m_131140_(ChatFormatting.DARK_RED));
    }
}

