/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.items;

import com.dee12452.gahoodrpg.common.capabilities.Capabilities;
import com.dee12452.gahoodrpg.common.capabilities.CommonPlayerCapability;
import com.dee12452.gahoodrpg.common.capabilities.role.IGahRole;
import com.dee12452.gahoodrpg.common.network.ClientSync;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerPlayerLevelUp;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GahExperiencePotionItem
extends PotionItem {
    private final int experienceToAdd;

    public GahExperiencePotionItem(int experienceToAdd) {
        super(new Item.Properties());
        this.experienceToAdd = experienceToAdd;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level p_42993_, @NotNull Player player, @NotNull InteractionHand p_42995_) {
        if (Capabilities.commonPlayer(player).getCurrentRole().isEmpty()) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.m_5661_((Component)Component.m_237115_((String)"message.gahoodrpg.potion.no_role_selected"), true);
            }
            return InteractionResultHolder.m_19100_((Object)player.m_21120_(p_42995_));
        }
        return super.m_7203_(p_42993_, player, p_42995_);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack p_42984_, @NotNull Level p_42985_, @NotNull LivingEntity p_42986_) {
        ItemStack result = super.m_5922_(p_42984_, p_42985_, p_42986_);
        if (!(p_42986_ instanceof ServerPlayer)) {
            return result;
        }
        ServerPlayer player = (ServerPlayer)p_42986_;
        CommonPlayerCapability caps = Capabilities.commonPlayer((Player)player);
        Optional<IGahRole> role = caps.getCurrentRole();
        if (role.isEmpty()) {
            return result;
        }
        int previousLevel = role.get().getLevel();
        role.get().addExperience(this.experienceToAdd);
        new ClientSync.Builder(player).roles().build().sync();
        int newLevel = role.get().getLevel();
        if (previousLevel == newLevel) {
            return result;
        }
        new ServerPlayerLevelUp().onServerProcess(player, new ServerPlayerLevelUp.Message(newLevel));
        return result;
    }

    @NotNull
    public String m_5524_() {
        return this.m_41467_();
    }

    public void m_7373_(@NotNull ItemStack p_42988_, @Nullable Level p_42989_, @NotNull List<Component> texts, @NotNull TooltipFlag p_42991_) {
        MutableComponent component = Component.m_237110_((String)"item.gahoodrpg.tooltip.add_experience", (Object[])new Object[]{this.experienceToAdd}).m_130940_(ChatFormatting.YELLOW);
        texts.add((Component)component);
    }

    public boolean m_5812_(@NotNull ItemStack p_42999_) {
        return true;
    }
}

