/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.items;

import com.dee12452.gahoodrpg.common.combat.GahStats;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public enum GahMaterial implements Tier
{
    WOOD(-1, ArmorType.LIGHT),
    IRON(0, ArmorType.HEAVY),
    GOLDEN(0, ArmorType.LIGHT),
    DIAMOND(0, ArmorType.MEDIUM),
    BRONZE(1, ArmorType.HEAVY),
    SILVER(1, ArmorType.MEDIUM),
    AMETHYST(1, ArmorType.LIGHT),
    DESERT_STEEL(2, ArmorType.HEAVY),
    AURIDIUM(2, ArmorType.MEDIUM),
    PHOENIXITE(2, ArmorType.LIGHT),
    PHARAOH_WEAPON(2, ArmorType.MEDIUM),
    SCARLETITE(3, ArmorType.HEAVY),
    PANTHERITE(3, ArmorType.MEDIUM),
    JUNGLE(3, ArmorType.LIGHT),
    UMBRAL(4, ArmorType.HEAVY),
    RAVAGER(4, ArmorType.MEDIUM),
    ABYSS(4, ArmorType.LIGHT),
    FROST(4, ArmorType.LIGHT);

    private final int tier;
    private final ArmorType armorType;

    private GahMaterial(int tier, ArmorType armorType) {
        this.tier = tier;
        this.armorType = armorType;
    }

    public int m_6609_() {
        return Tiers.DIAMOND.m_6609_() + 16 * this.tier;
    }

    public float m_6624_() {
        return Tiers.DIAMOND.m_6624_() + (float)this.tier;
    }

    public float m_6631_() {
        return Tiers.DIAMOND.m_6631_();
    }

    public int m_6604_() {
        return Tiers.DIAMOND.m_6604_();
    }

    public int m_6601_() {
        return 0;
    }

    @NotNull
    public Ingredient m_6282_() {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42616_});
    }

    public int getTier() {
        return this.tier;
    }

    public GahStats getArmorStats(EquipmentSlot slot) {
        GahStats stats;
        if (this.tier < 0) {
            return GahStats.EMPTY;
        }
        switch (slot) {
            case HEAD: 
            case FEET: {
                stats = new GahStats.Builder().damage(1.0f).resist(1.5f).vitality(0.5f).build().multiply(this.tier);
                break;
            }
            case CHEST: 
            case LEGS: {
                stats = new GahStats.Builder().damage(2.0f).resist(2.5f).vitality(1.5f).build().multiply(this.tier);
                break;
            }
            default: {
                return GahStats.EMPTY;
            }
        }
        switch (this.armorType) {
            case HEAVY: {
                return new GahStats.Builder(stats).intelligence(0.0f).strength(stats.strength() + 0.5f * (float)this.tier).toughnessPercent(2.5f * (float)this.tier).build();
            }
            case LIGHT: {
                return new GahStats.Builder(stats).strength(0.0f).intelligence(stats.intelligence() + 0.5f * (float)this.tier).aegisPercent(2.5f * (float)this.tier).build();
            }
        }
        return stats;
    }

    public GahStats getWeaponStats() {
        if (this.tier < 0) {
            return GahStats.EMPTY;
        }
        if (this.tier == 0) {
            if (this.armorType == ArmorType.HEAVY) {
                return new GahStats.Builder().strength(2.0f).build();
            }
            if (this.armorType == ArmorType.MEDIUM) {
                return new GahStats.Builder().damage(3.0f).build();
            }
            if (this.armorType == ArmorType.LIGHT) {
                return new GahStats.Builder().intelligence(2.0f).build();
            }
        }
        return new GahStats.Builder().damage(6.5f).build().multiply(this.tier);
    }

    private static enum ArmorType {
        LIGHT,
        MEDIUM,
        HEAVY;

    }
}

