/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.items.armor;

import com.dee12452.gahoodrpg.common.combat.GahAttributeModifiers;
import com.dee12452.gahoodrpg.common.items.armor.IGahArmor;
import com.dee12452.gahoodrpg.utils.ResourceLocationBuilder;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.model.DefaultedItemGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class GahArmorItem
extends ArmorItem
implements GeoItem,
IGahArmor {
    private static final int DEFAULT_BASE_PROTECTION = 4;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final int baseProtection;

    public GahArmorItem(ArmorItem.Type type) {
        this(type, 4);
    }

    public GahArmorItem(ArmorItem.Type type, int baseProtection) {
        super((ArmorMaterial)ArmorMaterials.DIAMOND, type, new Item.Properties());
        this.baseProtection = baseProtection;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new GahArmorItemClientExtension(this.getArmorRenderer()));
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot != this.m_40402_()) {
            return super.getAttributeModifiers(slot, stack);
        }
        return new GahAttributeModifiers.Builder((Multimap<Attribute, AttributeModifier>)super.getAttributeModifiers(slot, stack)).stats(this.getSlotStats(slot)).build();
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public boolean m_8120_(@NotNull ItemStack stack) {
        return false;
    }

    public final int getAdditionalProtection(@NotNull DamageSource source) {
        int base = this.baseProtection;
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return 0;
        }
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            return base * 2;
        }
        if (source.m_269533_(DamageTypeTags.f_268549_)) {
            return base * 3;
        }
        if (source.m_269533_(DamageTypeTags.f_268415_)) {
            return base * 2;
        }
        return source.m_269533_(DamageTypeTags.f_268524_) ? base * 2 : 0;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    public Supplier<GeoArmorRenderer<GahArmorItem>> getArmorRenderer() {
        String textureName = String.format("armor/%s_armor", this.getGahMaterial().name().toLowerCase());
        ResourceLocation textureLocation = new ResourceLocationBuilder(textureName).named();
        String rendererName = String.format("armor_tier%d", this.getGahMaterial().getTier());
        return () -> {
            String armorPath = String.format("armor/%s", rendererName);
            DefaultedItemGeoModel model = new DefaultedItemGeoModel(new ResourceLocationBuilder(armorPath).named()).withAltTexture(textureLocation);
            return new GeoArmorRenderer((GeoModel)model);
        };
    }

    private record GahArmorItemClientExtension(Supplier<GeoArmorRenderer<GahArmorItem>> armorRendererCreator) implements IClientItemExtensions
    {
        @NotNull
        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
            GeoArmorRenderer<GahArmorItem> renderer = this.armorRendererCreator.get();
            renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
            return renderer;
        }
    }
}

