/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.items.curios;

import com.dee12452.gahoodrpg.common.combat.GahAttributeModifiers;
import com.dee12452.gahoodrpg.common.combat.GahStats;
import com.dee12452.gahoodrpg.common.network.encoders.server.ServerOpenMasteryBook;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class GahTrinketItem
extends Item {
    public GahTrinketItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return CuriosApi.createCurioProvider((ICurio)this.createCurio(stack, nbt));
    }

    public GahStats getStats() {
        return GahStats.EMPTY;
    }

    public void injectAdditionalStats(ItemStack stack, GahStats stats) {
        CompoundTag statsTag = new CompoundTag();
        statsTag.m_128350_(GahAttributeModifiers.ID.STRENGTH.toString(), stats.strength());
        statsTag.m_128350_(GahAttributeModifiers.ID.INTELLIGENCE.toString(), stats.intelligence());
        statsTag.m_128350_(GahAttributeModifiers.ID.TOUGHNESS_PERCENT.toString(), stats.toughnessPercent());
        statsTag.m_128350_(GahAttributeModifiers.ID.AEGIS_PERCENT.toString(), stats.aegisPercent());
        statsTag.m_128350_(GahAttributeModifiers.ID.DEXTERITY.toString(), stats.dexterity());
        statsTag.m_128350_(GahAttributeModifiers.ID.ALACRITY.toString(), stats.alacrity());
        stack.m_41784_().m_128365_("gahStats", (Tag)statsTag);
    }

    public GahStats extractAdditionalStats(ItemStack stack) {
        Optional<CompoundTag> statsTag = Optional.ofNullable(stack.m_41783_()).map(tag -> tag.m_128423_("gahStats")).filter(CompoundTag.class::isInstance).map(tag -> (CompoundTag)tag);
        return statsTag.map(tag -> new GahStats.Builder().strength(tag.m_128457_(GahAttributeModifiers.ID.STRENGTH.toString())).intelligence(tag.m_128457_(GahAttributeModifiers.ID.INTELLIGENCE.toString())).toughnessPercent(tag.m_128457_(GahAttributeModifiers.ID.TOUGHNESS_PERCENT.toString())).aegisPercent(tag.m_128457_(GahAttributeModifiers.ID.AEGIS_PERCENT.toString())).dexterity(tag.m_128457_(GahAttributeModifiers.ID.DEXTERITY.toString())).alacrity(tag.m_128457_(GahAttributeModifiers.ID.ALACRITY.toString())).build()).orElse(GahStats.EMPTY);
    }

    @NotNull
    protected ICurio createCurio(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public boolean canEquip(SlotContext slotContext) {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof ServerPlayer)) {
                    return false;
                }
                ServerPlayer player = (ServerPlayer)livingEntity;
                if (ServerOpenMasteryBook.canOpen(player)) {
                    return true;
                }
                if (player.f_8906_ != null) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.gahoodrpg.belt.monsters"), true);
                }
                return false;
            }

            public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid) {
                GahStats stats = GahTrinketItem.this.getStats().plus(GahTrinketItem.this.extractAdditionalStats(stack));
                ImmutableMultimap modifiers = ImmutableMultimap.of();
                if (stats.isEmpty()) {
                    return modifiers;
                }
                return new GahAttributeModifiers.Builder((Multimap<Attribute, AttributeModifier>)modifiers).stats(stats).build();
            }

            public List<Component> getAttributesTooltip(List<Component> tooltips) {
                List components = super.getAttributesTooltip(tooltips);
                GahAttributeModifiers.colorizeGahAttributeModifiers(components);
                return components;
            }
        };
    }
}

