/*
 * Decompiled with CFR 0.152.
 */
package com.dee12452.gahoodrpg.common.items.curios.back;

import com.dee12452.gahoodrpg.common.items.curios.GahGeoTrinketItem;
import com.dee12452.gahoodrpg.common.items.curios.IActionTrinket;
import com.dee12452.gahoodrpg.utils.NbtUtils;
import com.dee12452.gahoodrpg.utils.TimeUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class EnderWingsItem
extends GahGeoTrinketItem
implements IActionTrinket {
    private static final int MAX_FLY_SECONDS = TimeUtils.secondsToTicks(5.0f);

    @Override
    public String getId() {
        return "ender_wings";
    }

    @Override
    public void onJumpPressed(Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("isFlying", true);
    }

    @Override
    public void onJumpReleased(Player player, ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("isFlying", false);
    }

    @Override
    @NotNull
    protected ICurio createCurio(final ItemStack stack, @Nullable CompoundTag nbt) {
        return new ICurio(){

            public ItemStack getStack() {
                return stack;
            }

            public void curioTick(SlotContext slotContext) {
                Player player = (Player)slotContext.entity();
                if (player.m_7500_() || player.m_5833_()) {
                    return;
                }
                CompoundTag tag = stack.m_41784_();
                if (!tag.m_128441_("flyTicks")) {
                    tag.m_128405_("flyTicks", 0);
                }
                boolean isFlying = NbtUtils.getIfPresent(tag, "isFlying", CompoundTag::m_128471_).orElse(false);
                int flyTicks = tag.m_128451_("flyTicks");
                if (!isFlying && player.m_20096_() && flyTicks < MAX_FLY_SECONDS) {
                    tag.m_128405_("flyTicks", flyTicks + 1);
                } else if (isFlying && flyTicks > 0) {
                    Vec3 deltaMovement = player.m_20184_();
                    player.m_20334_(deltaMovement.f_82479_, deltaMovement.f_82480_ + 0.09, deltaMovement.f_82481_);
                    player.m_183634_();
                    tag.m_128405_("flyTicks", flyTicks - 1);
                }
            }
        };
    }
}

